/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.classFilter.ClassFilterEditor;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerDataViewsConfigurable
implements SearchableConfigurable {
    private JCheckBox myCbAutoscroll;
    private JCheckBox myCbShowSyntheticFields;
    private StateRestoringCheckBox myCbShowValFieldsAsLocalVariables;
    private JCheckBox myCbHideNullArrayElements;
    private JCheckBox myCbShowStatic;
    private JCheckBox myCbShowDeclaredType;
    private JCheckBox myCbShowFQNames;
    private JCheckBox myCbShowObjectId;
    private JCheckBox myCbShowStringsType;
    private JCheckBox myCbHexValue;
    private StateRestoringCheckBox myCbShowStaticFinalFields;
    private JCheckBox myCbEnableAlternateViews;
    private JCheckBox myCbEnableToString;
    private JRadioButton myRbAllThatOverride;
    private JRadioButton myRbFromList;
    private ClassFilterEditor myToStringFilterEditor;
    private Project myProject;

    public DebuggerDataViewsConfigurable(@Nullable Project project) {
        this.myProject = project;
    }

    public void disposeUIResources() {
        this.myToStringFilterEditor = null;
        this.myProject = null;
    }

    public String getDisplayName() {
        return OptionsBundle.message((String)"options.java.display.name", (Object[])new Object[0]);
    }

    public JComponent createComponent() {
        if (this.myProject == null) {
            this.myProject = JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables();
        }
        JPanel panel = new JPanel(new GridBagLayout());
        this.myCbAutoscroll = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.autoscroll", (Object[])new Object[0]));
        this.myCbShowSyntheticFields = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.synthetic.fields", (Object[])new Object[0]));
        this.myCbShowValFieldsAsLocalVariables = new StateRestoringCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.val.fields.as.locals", (Object[])new Object[0]));
        this.myCbHideNullArrayElements = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.hide.null.array.elements", (Object[])new Object[0]));
        this.myCbShowStatic = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.static.fields", (Object[])new Object[0]));
        this.myCbShowStaticFinalFields = new StateRestoringCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.static.final.fields", (Object[])new Object[0]));
        this.myCbEnableAlternateViews = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.alternate.view", (Object[])new Object[0]));
        this.myCbShowStatic.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DebuggerDataViewsConfigurable.this.myCbShowStatic.isSelected()) {
                    DebuggerDataViewsConfigurable.this.myCbShowStaticFinalFields.makeSelectable();
                } else {
                    DebuggerDataViewsConfigurable.this.myCbShowStaticFinalFields.makeUnselectable(false);
                }
            }
        });
        this.myCbShowSyntheticFields.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DebuggerDataViewsConfigurable.this.myCbShowSyntheticFields.isSelected()) {
                    DebuggerDataViewsConfigurable.this.myCbShowValFieldsAsLocalVariables.makeSelectable();
                } else {
                    DebuggerDataViewsConfigurable.this.myCbShowValFieldsAsLocalVariables.makeUnselectable(false);
                }
            }
        });
        this.myCbShowDeclaredType = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.declared.type", (Object[])new Object[0]));
        this.myCbShowFQNames = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.fq.names", (Object[])new Object[0]));
        this.myCbShowObjectId = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.object.id", (Object[])new Object[0]));
        this.myCbHexValue = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.hex.value", (Object[])new Object[0]));
        this.myCbShowStringsType = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.strings.type", (Object[])new Object[0]));
        this.myCbEnableToString = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.enable.toString", (Object[])new Object[0]));
        this.myRbAllThatOverride = new JRadioButton(DebuggerBundle.message((String)"label.base.renderer.configurable.all.overriding", (Object[])new Object[0]));
        this.myRbFromList = new JRadioButton(DebuggerBundle.message((String)"label.base.renderer.configurable.classes.from.list", (Object[])new Object[0]));
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbAllThatOverride);
        group.add(this.myRbFromList);
        this.myToStringFilterEditor = new ClassFilterEditor(this.myProject, null, "reference.viewBreakpoints.classFilters.newPattern");
        this.myCbEnableToString.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = DebuggerDataViewsConfigurable.this.myCbEnableToString.isSelected();
                DebuggerDataViewsConfigurable.this.myRbAllThatOverride.setEnabled(enabled);
                DebuggerDataViewsConfigurable.this.myRbFromList.setEnabled(enabled);
                DebuggerDataViewsConfigurable.this.myToStringFilterEditor.setEnabled(enabled && DebuggerDataViewsConfigurable.this.myRbFromList.isSelected());
            }
        });
        this.myRbFromList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DebuggerDataViewsConfigurable.this.myToStringFilterEditor.setEnabled(DebuggerDataViewsConfigurable.this.myCbEnableToString.isSelected() && DebuggerDataViewsConfigurable.this.myRbFromList.isSelected());
            }
        });
        panel.add((Component)this.myCbAutoscroll, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        JPanel showPanel = new JPanel(new GridBagLayout());
        showPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Show", (boolean)true));
        showPanel.add((Component)this.myCbShowDeclaredType, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        showPanel.add((Component)this.myCbShowObjectId, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        showPanel.add((Component)this.myCbShowSyntheticFields, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        showPanel.add((Component)this.myCbShowStatic, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 10, 0, 0), 0, 0));
        showPanel.add((Component)this.myCbShowValFieldsAsLocalVariables, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 10, 0, 0), 0, 0));
        showPanel.add((Component)this.myCbShowStaticFinalFields, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 10, 0, 0), 0, 0));
        showPanel.add((Component)this.myCbShowFQNames, new GridBagConstraints(3, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)showPanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 2, new Insets(4, 0, 0, 0), 0, 0));
        panel.add((Component)this.myCbShowStringsType, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myCbHexValue, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 11, 2, new Insets(4, 0, 0, 0), 0, 0));
        panel.add((Component)this.myCbHideNullArrayElements, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 11, 2, new Insets(4, 0, 0, 0), 0, 0));
        panel.add((Component)this.myCbEnableAlternateViews, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 10), 0, 0));
        panel.add((Component)this.myCbEnableToString, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, new Insets(4, 0, 0, 0), 0, 0));
        panel.add((Component)this.myRbAllThatOverride, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        panel.add((Component)this.myRbFromList, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.myToStringFilterEditor.setMinimumSize((Dimension)JBUI.size((int)50, (int)100));
        panel.add((Component)this.myToStringFilterEditor, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 0, 0), 0, 0));
        return panel;
    }

    public void apply() {
        ViewsGeneralSettings generalSettings = ViewsGeneralSettings.getInstance();
        NodeRendererSettings rendererSettings = NodeRendererSettings.getInstance();
        generalSettings.AUTOSCROLL_TO_NEW_LOCALS = this.myCbAutoscroll.isSelected();
        rendererSettings.setAlternateCollectionViewsEnabled(this.myCbEnableAlternateViews.isSelected());
        generalSettings.HIDE_NULL_ARRAY_ELEMENTS = this.myCbHideNullArrayElements.isSelected();
        ClassRenderer classRenderer = rendererSettings.getClassRenderer();
        classRenderer.SHOW_STATIC = this.myCbShowStatic.isSelected();
        classRenderer.SHOW_STATIC_FINAL = this.myCbShowStaticFinalFields.isSelectedWhenSelectable();
        classRenderer.SHOW_SYNTHETICS = this.myCbShowSyntheticFields.isSelected();
        classRenderer.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES = this.myCbShowValFieldsAsLocalVariables.isSelectedWhenSelectable();
        classRenderer.SHOW_DECLARED_TYPE = this.myCbShowDeclaredType.isSelected();
        classRenderer.SHOW_FQ_TYPE_NAMES = this.myCbShowFQNames.isSelected();
        classRenderer.SHOW_OBJECT_ID = this.myCbShowObjectId.isSelected();
        classRenderer.SHOW_STRINGS_TYPE = this.myCbShowStringsType.isSelected();
        ToStringRenderer toStringRenderer = rendererSettings.getToStringRenderer();
        toStringRenderer.setEnabled(this.myCbEnableToString.isSelected());
        toStringRenderer.setUseClassFilters(this.myRbFromList.isSelected());
        toStringRenderer.setClassFilters(this.myToStringFilterEditor.getFilters());
        PrimitiveRenderer primitiveRenderer = rendererSettings.getPrimitiveRenderer();
        primitiveRenderer.setShowHexValue(this.myCbHexValue.isSelected());
        rendererSettings.fireRenderersChanged();
    }

    public void reset() {
        ViewsGeneralSettings generalSettings = ViewsGeneralSettings.getInstance();
        NodeRendererSettings rendererSettings = NodeRendererSettings.getInstance();
        this.myCbAutoscroll.setSelected(generalSettings.AUTOSCROLL_TO_NEW_LOCALS);
        this.myCbHideNullArrayElements.setSelected(generalSettings.HIDE_NULL_ARRAY_ELEMENTS);
        this.myCbEnableAlternateViews.setSelected(rendererSettings.areAlternateCollectionViewsEnabled());
        ClassRenderer classRenderer = rendererSettings.getClassRenderer();
        this.myCbShowSyntheticFields.setSelected(classRenderer.SHOW_SYNTHETICS);
        this.myCbShowValFieldsAsLocalVariables.setSelected(classRenderer.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES);
        if (!classRenderer.SHOW_SYNTHETICS) {
            this.myCbShowValFieldsAsLocalVariables.makeUnselectable(false);
        }
        this.myCbShowStatic.setSelected(classRenderer.SHOW_STATIC);
        this.myCbShowStaticFinalFields.setSelected(classRenderer.SHOW_STATIC_FINAL);
        if (!classRenderer.SHOW_STATIC) {
            this.myCbShowStaticFinalFields.makeUnselectable(false);
        }
        this.myCbShowDeclaredType.setSelected(classRenderer.SHOW_DECLARED_TYPE);
        this.myCbShowFQNames.setSelected(classRenderer.SHOW_FQ_TYPE_NAMES);
        this.myCbShowObjectId.setSelected(classRenderer.SHOW_OBJECT_ID);
        this.myCbShowStringsType.setSelected(classRenderer.SHOW_STRINGS_TYPE);
        ToStringRenderer toStringRenderer = rendererSettings.getToStringRenderer();
        boolean toStringEnabled = toStringRenderer.isEnabled();
        boolean useClassFilters = toStringRenderer.isUseClassFilters();
        this.myCbEnableToString.setSelected(toStringEnabled);
        this.myRbAllThatOverride.setSelected(!useClassFilters);
        this.myRbFromList.setSelected(useClassFilters);
        this.myToStringFilterEditor.setFilters(toStringRenderer.getClassFilters());
        this.myToStringFilterEditor.setEnabled(toStringEnabled && useClassFilters);
        this.myRbFromList.setEnabled(toStringEnabled);
        this.myRbAllThatOverride.setEnabled(toStringEnabled);
        PrimitiveRenderer primitiveRenderer = rendererSettings.getPrimitiveRenderer();
        this.myCbHexValue.setSelected(primitiveRenderer.isShowHexValue());
    }

    public boolean isModified() {
        return this.areGeneralSettingsModified() || this.areDefaultRenderersModified();
    }

    private boolean areGeneralSettingsModified() {
        ViewsGeneralSettings generalSettings = ViewsGeneralSettings.getInstance();
        return generalSettings.AUTOSCROLL_TO_NEW_LOCALS != this.myCbAutoscroll.isSelected() || generalSettings.HIDE_NULL_ARRAY_ELEMENTS != this.myCbHideNullArrayElements.isSelected();
    }

    private boolean areDefaultRenderersModified() {
        boolean isToStringRendererModified;
        boolean isClassRendererModified;
        NodeRendererSettings rendererSettings = NodeRendererSettings.getInstance();
        ClassRenderer classRenderer = rendererSettings.getClassRenderer();
        boolean bl = isClassRendererModified = classRenderer.SHOW_STATIC != this.myCbShowStatic.isSelected() || classRenderer.SHOW_STATIC_FINAL != this.myCbShowStaticFinalFields.isSelectedWhenSelectable() || classRenderer.SHOW_SYNTHETICS != this.myCbShowSyntheticFields.isSelected() || classRenderer.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES != this.myCbShowValFieldsAsLocalVariables.isSelectedWhenSelectable() || classRenderer.SHOW_DECLARED_TYPE != this.myCbShowDeclaredType.isSelected() || classRenderer.SHOW_FQ_TYPE_NAMES != this.myCbShowFQNames.isSelected() || classRenderer.SHOW_OBJECT_ID != this.myCbShowObjectId.isSelected() || classRenderer.SHOW_STRINGS_TYPE != this.myCbShowStringsType.isSelected();
        if (isClassRendererModified) {
            return true;
        }
        ToStringRenderer toStringRenderer = rendererSettings.getToStringRenderer();
        boolean bl2 = isToStringRendererModified = toStringRenderer.isEnabled() != this.myCbEnableToString.isSelected() || toStringRenderer.isUseClassFilters() != this.myRbFromList.isSelected() || !DebuggerUtilsEx.filterEquals(toStringRenderer.getClassFilters(), this.myToStringFilterEditor.getFilters());
        if (isToStringRendererModified) {
            return true;
        }
        if (rendererSettings.areAlternateCollectionViewsEnabled() != this.myCbEnableAlternateViews.isSelected()) {
            return true;
        }
        PrimitiveRenderer primitiveRenderer = rendererSettings.getPrimitiveRenderer();
        return primitiveRenderer.isShowHexValue() != this.myCbHexValue.isSelected();
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.idesettings.debugger.dataviews" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/DebuggerDataViewsConfigurable", "getHelpTopic"));
        }
        return "reference.idesettings.debugger.dataviews";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/DebuggerDataViewsConfigurable", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }
}

