/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowsGroup
extends ActionGroup
implements DumbAware {
    private static final Comparator<ActivateToolWindowAction> COMPARATOR = new Comparator<ActivateToolWindowAction>(){

        @Override
        public int compare(ActivateToolWindowAction a1, ActivateToolWindowAction a2) {
            int m1 = ActivateToolWindowAction.getMnemonicForToolWindow(a1.getToolWindowId());
            int m2 = ActivateToolWindowAction.getMnemonicForToolWindow(a2.getToolWindowId());
            if (m1 != -1 && m2 == -1) {
                return -1;
            }
            if (m1 == -1 && m2 != -1) {
                return 1;
            }
            if (m1 != -1) {
                return m1 - m2;
            }
            return a1.getToolWindowId().compareToIgnoreCase(a2.getToolWindowId());
        }
    };

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(ToolWindowsGroup.getEventProject((AnActionEvent)e) != null);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        Project project = ToolWindowsGroup.getEventProject((AnActionEvent)e);
        if (project == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToolWindowsGroup", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        List<ActivateToolWindowAction> result2 = ToolWindowsGroup.getToolWindowActions(project, false);
        AnAction[] anActionArray = result2.toArray(new AnAction[result2.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ToolWindowsGroup", "getChildren"));
        }
        return anActionArray;
    }

    public static List<ActivateToolWindowAction> getToolWindowActions(@NotNull Project project, boolean shouldSkipHidden) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/ToolWindowsGroup", "getToolWindowActions"));
        }
        ActionManager actionManager = ActionManager.getInstance();
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        ArrayList result2 = ContainerUtil.newArrayList();
        for (String id : manager.getToolWindowIds()) {
            String actionId;
            AnAction action;
            if (shouldSkipHidden && !manager.getToolWindow(id).isShowStripeButton() || !((action = actionManager.getAction(actionId = ActivateToolWindowAction.getActionIdForToolWindow(id))) instanceof ActivateToolWindowAction)) continue;
            result2.add((ActivateToolWindowAction)action);
        }
        Collections.sort(result2, COMPARATOR);
        return result2;
    }
}

