/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogModel
implements Disposable {
    public static final Topic<Runnable> LOG_MODEL_CHANGED = Topic.create((String)"LOG_MODEL_CHANGED", Runnable.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
    private final List<Notification> myNotifications;
    private final Map<Notification, String> myStatuses;
    private Trinity<Notification, String, Long> myStatusMessage;
    private final Project myProject;
    final Map<Notification, Runnable> removeHandlers;

    LogModel(@Nullable Project project, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/notification/LogModel", "<init>"));
        }
        this.myNotifications = new ArrayList<Notification>();
        this.myStatuses = ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
        this.removeHandlers = new THashMap();
        this.myProject = project;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNotification(Notification notification) {
        long stamp = System.currentTimeMillis();
        NotificationDisplayType type = NotificationsConfigurationImpl.getSettings(notification.getGroupId()).getDisplayType();
        this.myStatuses.put(notification, EventLog.formatForLog((Notification)notification, (String)"").status);
        if (notification.isImportant() || type != NotificationDisplayType.NONE && type != NotificationDisplayType.TOOL_WINDOW) {
            List<Notification> list = this.myNotifications;
            synchronized (list) {
                this.myNotifications.add(notification);
            }
        }
        this.setStatusMessage(notification, stamp);
        LogModel.fireModelChanged();
    }

    private static void fireModelChanged() {
        ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(LOG_MODEL_CHANGED)).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Notification> takeNotifications() {
        ArrayList<Notification> result2;
        List<Notification> list = this.myNotifications;
        synchronized (list) {
            result2 = this.getNotifications();
            this.myNotifications.clear();
        }
        LogModel.fireModelChanged();
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatusMessage(@Nullable Notification statusMessage, long stamp) {
        List<Notification> list = this.myNotifications;
        synchronized (list) {
            if (this.myStatusMessage != null && this.myStatusMessage.first == statusMessage) {
                return;
            }
            if (this.myStatusMessage == null && statusMessage == null) {
                return;
            }
            this.myStatusMessage = statusMessage == null ? null : Trinity.create((Object)statusMessage, (Object)ObjectUtils.assertNotNull((Object)this.myStatuses.get(statusMessage)), (Object)stamp);
        }
        StatusBar.Info.set((String)"", (Project)this.myProject, (String)"Internal log requestor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Trinity<Notification, String, Long> getStatusMessage() {
        List<Notification> list = this.myNotifications;
        synchronized (list) {
            return this.myStatusMessage;
        }
    }

    void logShown() {
        for (Notification notification : this.getNotifications()) {
            if (notification.isImportant()) continue;
            this.removeNotification(notification);
        }
        this.setStatusToImportant();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Notification> getNotifications() {
        List<Notification> list = this.myNotifications;
        synchronized (list) {
            return new ArrayList<Notification>(this.myNotifications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotification(Notification notification) {
        Trinity<Notification, String, Long> oldStatus;
        List<Notification> list = this.myNotifications;
        synchronized (list) {
            this.myNotifications.remove(notification);
        }
        Runnable handler2 = this.removeHandlers.remove(notification);
        if (handler2 != null) {
            UIUtil.invokeLaterIfNeeded((Runnable)handler2);
        }
        if ((oldStatus = this.getStatusMessage()) != null && notification == oldStatus.first) {
            this.setStatusToImportant();
        }
        LogModel.fireModelChanged();
    }

    private void setStatusToImportant() {
        ArrayList<Notification> notifications = this.getNotifications();
        Collections.reverse(notifications);
        Notification message = (Notification)ContainerUtil.find(notifications, (Condition)new Condition<Notification>(){

            public boolean value(Notification notification) {
                return notification.isImportant();
            }
        });
        if (message == null) {
            this.setStatusMessage(null, 0L);
        } else {
            this.setStatusMessage(message, message.getTimestamp());
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public void dispose() {
    }
}

