/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindowManager;
import gnu.trove.THashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="IdeDocumentHistory", storages={@Storage(file="$WORKSPACE_FILE$")})
public class IdeDocumentHistoryImpl
extends IdeDocumentHistory
implements ProjectComponent,
PersistentStateComponent<RecentlyChangedFilesState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl");
    private static final int BACK_QUEUE_LIMIT = Registry.intValue((String)"editor.navigation.history.stack.size");
    private static final int CHANGE_QUEUE_LIMIT = Registry.intValue((String)"editor.navigation.history.stack.size");
    private final Project myProject;
    private final EditorFactory myEditorFactory;
    private FileDocumentManager myFileDocumentManager;
    private FileEditorManagerEx myEditorManager;
    private final VirtualFileManager myVfManager;
    private final CommandProcessor myCmdProcessor;
    private final ToolWindowManager myToolWindowManager;
    private final LinkedList<PlaceInfo> myBackPlaces;
    private final LinkedList<PlaceInfo> myForwardPlaces;
    private boolean myBackInProgress;
    private boolean myForwardInProgress;
    private Object myLastGroupId;
    private final LinkedList<PlaceInfo> myChangePlaces;
    private int myStartIndex;
    private int myCurrentIndex;
    private PlaceInfo myCurrentChangePlace;
    private PlaceInfo myCommandStartPlace;
    private boolean myCurrentCommandIsNavigation;
    private boolean myCurrentCommandHasChanges;
    private final Set<VirtualFile> myChangedFilesInCurrentCommand;
    private boolean myCurrentCommandHasMoves;
    private final CommandListener myCommandListener;
    private RecentlyChangedFilesState myRecentlyChangedFiles;

    public IdeDocumentHistoryImpl(@NotNull Project project, @NotNull EditorFactory editorFactory, @NotNull FileEditorManager editorManager, @NotNull VirtualFileManager vfManager, @NotNull CommandProcessor cmdProcessor, @NotNull ToolWindowManager toolWindowManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "<init>"));
        }
        if (editorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorFactory", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "<init>"));
        }
        if (editorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorManager", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "<init>"));
        }
        if (vfManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfManager", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "<init>"));
        }
        if (cmdProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmdProcessor", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "<init>"));
        }
        if (toolWindowManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "<init>"));
        }
        this.myBackPlaces = new LinkedList();
        this.myForwardPlaces = new LinkedList();
        this.myBackInProgress = false;
        this.myForwardInProgress = false;
        this.myLastGroupId = null;
        this.myChangePlaces = new LinkedList();
        this.myStartIndex = 0;
        this.myCurrentIndex = 0;
        this.myCurrentChangePlace = null;
        this.myCommandStartPlace = null;
        this.myCurrentCommandIsNavigation = false;
        this.myCurrentCommandHasChanges = false;
        this.myChangedFilesInCurrentCommand = new THashSet();
        this.myCurrentCommandHasMoves = false;
        this.myCommandListener = new CommandAdapter(){

            public void commandStarted(CommandEvent event) {
                IdeDocumentHistoryImpl.this.onCommandStarted();
            }

            public void commandFinished(CommandEvent event) {
                IdeDocumentHistoryImpl.this.onCommandFinished(event.getCommandGroupId());
            }
        };
        this.myRecentlyChangedFiles = new RecentlyChangedFilesState();
        this.myProject = project;
        this.myEditorFactory = editorFactory;
        this.myEditorManager = (FileEditorManagerEx)editorManager;
        this.myVfManager = vfManager;
        this.myCmdProcessor = cmdProcessor;
        this.myToolWindowManager = toolWindowManager;
    }

    public final void projectOpened() {
        this.myEditorManager = (FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject);
        EditorEventMulticaster eventMulticaster = this.myEditorFactory.getEventMulticaster();
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                IdeDocumentHistoryImpl.this.onDocumentChanged(e);
            }
        };
        eventMulticaster.addDocumentListener((DocumentListener)documentListener, (Disposable)this.myProject);
        CaretAdapter caretListener = new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e) {
                IdeDocumentHistoryImpl.this.onCaretPositionChanged(e);
            }
        };
        eventMulticaster.addCaretListener((CaretListener)caretListener, (Disposable)this.myProject);
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$4", "selectionChanged"));
                }
                IdeDocumentHistoryImpl.this.onSelectionChanged();
            }
        });
        VirtualFileAdapter fileListener = new VirtualFileAdapter(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$5", "fileDeleted"));
                }
                IdeDocumentHistoryImpl.this.onFileDeleted();
            }
        };
        this.myVfManager.addVirtualFileListener((VirtualFileListener)fileListener, (Disposable)this.myProject);
        this.myCmdProcessor.addCommandListener(this.myCommandListener, (Disposable)this.myProject);
    }

    public RecentlyChangedFilesState getState() {
        return this.myRecentlyChangedFiles;
    }

    public void loadState(RecentlyChangedFilesState state) {
        this.myRecentlyChangedFiles = state;
    }

    final void onFileDeleted() {
        this.removeInvalidFilesFromStacks();
    }

    public final void onSelectionChanged() {
        this.myCurrentCommandIsNavigation = true;
        this.myCurrentCommandHasMoves = true;
    }

    private void onCaretPositionChanged(CaretEvent e) {
        if (e.getOldPosition().line == e.getNewPosition().line) {
            return;
        }
        Document document = e.getEditor().getDocument();
        if (this.getFileDocumentManager().getFile(document) != null) {
            this.myCurrentCommandHasMoves = true;
        }
    }

    private void onDocumentChanged(DocumentEvent e) {
        Document document = e.getDocument();
        VirtualFile file2 = this.getFileDocumentManager().getFile(document);
        if (file2 != null) {
            this.myCurrentCommandHasChanges = true;
            this.myChangedFilesInCurrentCommand.add(file2);
        }
    }

    final void onCommandStarted() {
        this.myCommandStartPlace = this.getCurrentPlaceInfo();
        this.myCurrentCommandIsNavigation = false;
        this.myCurrentCommandHasChanges = false;
        this.myCurrentCommandHasMoves = false;
        this.myChangedFilesInCurrentCommand.clear();
    }

    private PlaceInfo getCurrentPlaceInfo() {
        Pair<FileEditor, FileEditorProvider> selectedEditorWithProvider = this.getSelectedEditor();
        if (selectedEditorWithProvider != null) {
            return this.createPlaceInfo((FileEditor)selectedEditorWithProvider.getFirst(), (FileEditorProvider)selectedEditorWithProvider.getSecond());
        }
        return null;
    }

    final void onCommandFinished(Object commandGroupId) {
        if (this.myCommandStartPlace != null && this.myCurrentCommandIsNavigation && this.myCurrentCommandHasMoves) {
            if (!this.myBackInProgress) {
                if (!CommandMerger.canMergeGroup(commandGroupId, this.myLastGroupId)) {
                    IdeDocumentHistoryImpl.putLastOrMerge(this.myBackPlaces, this.myCommandStartPlace, BACK_QUEUE_LIMIT);
                }
                if (!this.myForwardInProgress) {
                    this.myForwardPlaces.clear();
                }
            }
            this.removeInvalidFilesFromStacks();
        }
        this.myLastGroupId = commandGroupId;
        if (this.myCurrentCommandHasChanges) {
            this.setCurrentChangePlace();
        } else if (this.myCurrentCommandHasMoves) {
            this.pushCurrentChangePlace();
        }
    }

    public final void projectClosed() {
    }

    @Override
    public final void includeCurrentCommandAsNavigation() {
        this.myCurrentCommandIsNavigation = true;
    }

    @Override
    public final void includeCurrentPlaceAsChangePlace() {
        this.setCurrentChangePlace();
        this.pushCurrentChangePlace();
    }

    private void setCurrentChangePlace() {
        PlaceInfo placeInfo = this.getCurrentPlaceInfo();
        if (placeInfo == null) {
            return;
        }
        VirtualFile file2 = placeInfo.getFile();
        if (this.myChangedFilesInCurrentCommand.contains(file2)) {
            PlaceInfo lastInfo;
            this.myRecentlyChangedFiles.register(file2);
            this.myCurrentChangePlace = placeInfo;
            if (!this.myChangePlaces.isEmpty() && IdeDocumentHistoryImpl.isSame(placeInfo, lastInfo = this.myChangePlaces.getLast())) {
                this.myChangePlaces.removeLast();
            }
            this.myCurrentIndex = this.myStartIndex + this.myChangePlaces.size();
        }
    }

    private void pushCurrentChangePlace() {
        if (this.myCurrentChangePlace != null) {
            this.myChangePlaces.add(this.myCurrentChangePlace);
            if (this.myChangePlaces.size() > CHANGE_QUEUE_LIMIT) {
                this.myChangePlaces.removeFirst();
                ++this.myStartIndex;
            }
            this.myCurrentChangePlace = null;
        }
        this.myCurrentIndex = this.myStartIndex + this.myChangePlaces.size();
    }

    @Override
    public VirtualFile[] getChangedFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        List<String> paths = this.myRecentlyChangedFiles.CHANGED_PATHS;
        for (String path : paths) {
            VirtualFile file2 = lfs.findFileByPath(path);
            if (file2 == null) continue;
            files.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(files);
    }

    @Override
    public final void clearHistory() {
        this.myBackPlaces.clear();
        this.myForwardPlaces.clear();
        this.myChangePlaces.clear();
        this.myLastGroupId = null;
        this.myStartIndex = 0;
        this.myCurrentIndex = 0;
        this.myCurrentChangePlace = null;
        this.myCommandStartPlace = null;
    }

    @Override
    public final void back() {
        this.removeInvalidFilesFromStacks();
        if (this.myBackPlaces.isEmpty()) {
            return;
        }
        final PlaceInfo info = this.myBackPlaces.removeLast();
        PlaceInfo current = this.getCurrentPlaceInfo();
        if (current != null && !IdeDocumentHistoryImpl.isSame(current, info)) {
            IdeDocumentHistoryImpl.putLastOrMerge(this.myForwardPlaces, current, Integer.MAX_VALUE);
        }
        IdeDocumentHistoryImpl.putLastOrMerge(this.myForwardPlaces, info, Integer.MAX_VALUE);
        this.myBackInProgress = true;
        try {
            this.executeCommand(new Runnable(){

                @Override
                public void run() {
                    IdeDocumentHistoryImpl.this.gotoPlaceInfo(info);
                }
            }, "", null);
        }
        finally {
            this.myBackInProgress = false;
        }
    }

    @Override
    public final void forward() {
        this.removeInvalidFilesFromStacks();
        final PlaceInfo target = this.getTargetForwardInfo();
        if (target == null) {
            return;
        }
        this.myForwardInProgress = true;
        try {
            this.executeCommand(new Runnable(){

                @Override
                public void run() {
                    IdeDocumentHistoryImpl.this.gotoPlaceInfo(target);
                }
            }, "", null);
        }
        finally {
            this.myForwardInProgress = false;
        }
    }

    private PlaceInfo getTargetForwardInfo() {
        if (this.myForwardPlaces.isEmpty()) {
            return null;
        }
        PlaceInfo target = this.myForwardPlaces.removeLast();
        PlaceInfo current = this.getCurrentPlaceInfo();
        while (!this.myForwardPlaces.isEmpty() && current != null && IdeDocumentHistoryImpl.isSame(current, target)) {
            target = this.myForwardPlaces.removeLast();
        }
        return target;
    }

    @Override
    public final boolean isBackAvailable() {
        return !this.myBackPlaces.isEmpty();
    }

    @Override
    public final boolean isForwardAvailable() {
        return !this.myForwardPlaces.isEmpty();
    }

    @Override
    public final void navigatePreviousChange() {
        this.removeInvalidFilesFromStacks();
        if (this.myCurrentIndex == this.myStartIndex) {
            return;
        }
        int index = this.myCurrentIndex - 1;
        final PlaceInfo info = this.myChangePlaces.get(index - this.myStartIndex);
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                IdeDocumentHistoryImpl.this.gotoPlaceInfo(info);
            }
        }, "", null);
        this.myCurrentIndex = index;
    }

    @Override
    public final boolean isNavigatePreviousChangeAvailable() {
        return this.myCurrentIndex > this.myStartIndex;
    }

    private void removeInvalidFilesFromStacks() {
        IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myBackPlaces);
        IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myForwardPlaces);
        if (IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myChangePlaces)) {
            this.myCurrentIndex = this.myStartIndex + this.myChangePlaces.size();
        }
    }

    @Override
    public void navigateNextChange() {
        this.removeInvalidFilesFromStacks();
        if (this.myCurrentIndex >= this.myStartIndex + this.myChangePlaces.size() - 1) {
            return;
        }
        int index = this.myCurrentIndex + 1;
        final PlaceInfo info = this.myChangePlaces.get(index - this.myStartIndex);
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                IdeDocumentHistoryImpl.this.gotoPlaceInfo(info);
            }
        }, "", null);
        this.myCurrentIndex = index;
    }

    @Override
    public boolean isNavigateNextChangeAvailable() {
        return this.myCurrentIndex < this.myStartIndex + this.myChangePlaces.size() - 1;
    }

    private static boolean removeInvalidFilesFrom(@NotNull List<PlaceInfo> backPlaces) {
        if (backPlaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backPlaces", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "removeInvalidFilesFrom"));
        }
        boolean removed = false;
        Iterator<PlaceInfo> iterator = backPlaces.iterator();
        while (iterator.hasNext()) {
            PlaceInfo info = iterator.next();
            VirtualFile file2 = info.myFile;
            if (file2.isValid()) continue;
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    private void gotoPlaceInfo(@NotNull PlaceInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "gotoPlaceInfo"));
        }
        boolean wasActive = this.myToolWindowManager.isEditorComponentActive();
        EditorWindow wnd = info.getWindow();
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = wnd != null && wnd.isValid() ? this.myEditorManager.openFileWithProviders(info.getFile(), wasActive, wnd) : this.myEditorManager.openFileWithProviders(info.getFile(), wasActive, false);
        this.myEditorManager.setSelectedEditor(info.getFile(), info.getEditorTypeId());
        FileEditor[] editors = (FileEditor[])editorsWithProviders.getFirst();
        FileEditorProvider[] providers = (FileEditorProvider[])editorsWithProviders.getSecond();
        for (int i = 0; i < editors.length; ++i) {
            String typeId = providers[i].getEditorTypeId();
            if (!typeId.equals(info.getEditorTypeId())) continue;
            editors[i].setState(info.getNavigationState());
        }
    }

    protected Pair<FileEditor, FileEditorProvider> getSelectedEditor() {
        VirtualFile file2 = this.myEditorManager.getCurrentFile();
        return file2 != null ? this.myEditorManager.getSelectedEditorWithProvider(file2) : null;
    }

    private PlaceInfo createPlaceInfo(@NotNull FileEditor fileEditor, FileEditorProvider fileProvider) {
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "createPlaceInfo"));
        }
        VirtualFile file2 = this.myEditorManager.getFile(fileEditor);
        LOG.assertTrue(file2 != null);
        FileEditorState state = fileEditor.getState(FileEditorStateLevel.NAVIGATION);
        return new PlaceInfo(file2, state, fileProvider.getEditorTypeId(), this.myEditorManager.getCurrentWindow());
    }

    @NotNull
    public final String getComponentName() {
        if ("IdeDocumentHistory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "getComponentName"));
        }
        return "IdeDocumentHistory";
    }

    private static void putLastOrMerge(@NotNull LinkedList<PlaceInfo> list, @NotNull PlaceInfo next, int limitSizeLimit) {
        PlaceInfo prev;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "putLastOrMerge"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "putLastOrMerge"));
        }
        if (!list.isEmpty() && IdeDocumentHistoryImpl.isSame(prev = list.getLast(), next)) {
            list.removeLast();
        }
        list.add(next);
        if (list.size() > limitSizeLimit) {
            list.removeFirst();
        }
    }

    private FileDocumentManager getFileDocumentManager() {
        if (this.myFileDocumentManager == null) {
            this.myFileDocumentManager = FileDocumentManager.getInstance();
        }
        return this.myFileDocumentManager;
    }

    @NotNull
    List<PlaceInfo> getBackPlaces() {
        LinkedList<PlaceInfo> linkedList = this.myBackPlaces;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "getBackPlaces"));
        }
        return linkedList;
    }

    public final void initComponent() {
    }

    public final void disposeComponent() {
        this.myLastGroupId = null;
    }

    protected void executeCommand(Runnable runnable2, String name, Object groupId) {
        this.myCmdProcessor.executeCommand(this.myProject, runnable2, name, groupId);
    }

    private static boolean isSame(@NotNull PlaceInfo first, @NotNull PlaceInfo second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "isSame"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl", "isSame"));
        }
        if (first.getFile().equals(second.getFile())) {
            FileEditorState secondState;
            FileEditorState firstState = first.getNavigationState();
            return firstState.equals(secondState = second.getNavigationState()) || firstState.canBeMergedWith(secondState, FileEditorStateLevel.NAVIGATION);
        }
        return false;
    }

    private static final class PlaceInfo {
        private final VirtualFile myFile;
        private final FileEditorState myNavigationState;
        private final String myEditorTypeId;
        private final WeakReference<EditorWindow> myWindow;

        public PlaceInfo(@NotNull VirtualFile file2, @NotNull FileEditorState navigationState, @NotNull String editorTypeId, @Nullable EditorWindow window) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo", "<init>"));
            }
            if (navigationState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationState", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo", "<init>"));
            }
            if (editorTypeId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorTypeId", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo", "<init>"));
            }
            this.myNavigationState = navigationState;
            this.myFile = file2;
            this.myEditorTypeId = editorTypeId;
            this.myWindow = new WeakReference<EditorWindow>(window);
        }

        public EditorWindow getWindow() {
            return (EditorWindow)this.myWindow.get();
        }

        @NotNull
        private FileEditorState getNavigationState() {
            FileEditorState fileEditorState = this.myNavigationState;
            if (fileEditorState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo", "getNavigationState"));
            }
            return fileEditorState;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo", "getFile"));
            }
            return virtualFile;
        }

        @NotNull
        public String getEditorTypeId() {
            String string = this.myEditorTypeId;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo", "getEditorTypeId"));
            }
            return string;
        }

        public String toString() {
            return this.getFile().getName() + " " + this.getNavigationState();
        }
    }

    public static class RecentlyChangedFilesState {
        public List<String> CHANGED_PATHS = new ArrayList<String>();

        public void register(VirtualFile file2) {
            String path = file2.getPath();
            this.CHANGED_PATHS.remove(path);
            this.CHANGED_PATHS.add(path);
            this.trimToSize();
        }

        private void trimToSize() {
            int limit = UISettings.getInstance().RECENT_FILES_LIMIT + 1;
            while (this.CHANGED_PATHS.size() > limit) {
                this.CHANGED_PATHS.remove(0);
            }
        }
    }
}

