/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.TypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class AlphaNumericTypeCommand
extends TypeCommand {
    public AlphaNumericTypeCommand(String text, int line) {
        super(text, line);
    }

    @Override
    public ActionCallback _execute(PlaybackContext context) {
        return this.type(context, this.getText());
    }

    protected ActionCallback type(final PlaybackContext context, final String text) {
        final ActionCallback result2 = new ActionCallback();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                TypingTarget typingTarget = AlphaNumericTypeCommand.findTarget(context);
                if (typingTarget != null) {
                    typingTarget.type(text).doWhenDone(result2.createSetDoneRunnable()).doWhenRejected(new Runnable(){

                        @Override
                        public void run() {
                            AlphaNumericTypeCommand.this.typeByRobot(context.getRobot(), text).notify(result2);
                        }
                    });
                } else {
                    AlphaNumericTypeCommand.this.typeByRobot(context.getRobot(), text).notify(result2);
                }
            }
        });
        return result2;
    }

    private ActionCallback typeByRobot(final Robot robot, final String text) {
        final ActionCallback result2 = new ActionCallback();
        Runnable typeRunnable = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < text.length(); ++i) {
                    char each = text.charAt(i);
                    if ('\\' == each && i + 1 < text.length()) {
                        char next = text.charAt(i + 1);
                        boolean processed = true;
                        switch (next) {
                            case 'n': {
                                AlphaNumericTypeCommand.this.type(robot, 10, 0);
                                break;
                            }
                            case 't': {
                                AlphaNumericTypeCommand.this.type(robot, 9, 0);
                                break;
                            }
                            case 'r': {
                                AlphaNumericTypeCommand.this.type(robot, 10, 0);
                                break;
                            }
                            default: {
                                processed = false;
                            }
                        }
                        if (processed) {
                            ++i;
                            continue;
                        }
                    }
                    AlphaNumericTypeCommand.this.type(robot, AlphaNumericTypeCommand.this.get(each));
                }
                result2.setDone();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(typeRunnable);
        } else {
            typeRunnable.run();
        }
        return result2;
    }

    @Nullable
    public static TypingTarget findTarget(PlaybackContext context) {
        if (!context.isUseTypingTargets()) {
            return null;
        }
        for (Component each = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); each != null; each = each.getParent()) {
            if (!(each instanceof TypingTarget)) continue;
            return (TypingTarget)each;
        }
        return null;
    }
}

