/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcsUtil.UIVcsUtil;
import java.util.ArrayList;
import java.util.List;

public class ChangesBrowserChangeListNode
extends ChangesBrowserNode<ChangeList> {
    private final List<ChangeListDecorator> myDecorators;
    private final ChangeListManagerEx myClManager;
    private final ChangeListRemoteState myChangeListRemoteState;

    public ChangesBrowserChangeListNode(Project project, ChangeList userObject, ChangeListRemoteState changeListRemoteState) {
        super(userObject);
        this.myChangeListRemoteState = changeListRemoteState;
        this.myClManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
        this.myDecorators = ServiceKt.getComponents((ComponentManager)project, ChangeListDecorator.class);
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (this.userObject instanceof LocalChangeList) {
            LocalChangeList list = (LocalChangeList)this.userObject;
            renderer.appendTextWithIssueLinks(list.getName(), list.isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.appendCount(renderer);
            for (ChangeListDecorator decorator : this.myDecorators) {
                decorator.decorateChangeList(list, (ColoredTreeCellRenderer)renderer, selected, expanded, hasFocus);
            }
            String freezed = this.myClManager.isFreezed();
            if (freezed != null) {
                renderer.append(UIVcsUtil.spaceAndThinSpace() + freezed, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else if (this.myClManager.isInUpdate()) {
                renderer.append((this.getCountText().isEmpty() ? UIVcsUtil.spaceAndThinSpace() : ", ") + VcsBundle.message((String)"changes.nodetitle.updating", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            if (!this.myChangeListRemoteState.getState()) {
                renderer.append(UIVcsUtil.spaceAndThinSpace());
                renderer.append(VcsBundle.message((String)"changes.nodetitle.have.outdated.files", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        } else {
            renderer.append(((ChangeList)this.getUserObject()).getName(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
            this.appendCount(renderer);
        }
    }

    @Override
    public String getTextPresentation() {
        return ((ChangeList)this.getUserObject()).getName().trim();
    }

    @Override
    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        Change[] changes = dragBean.getChanges();
        for (Change change : ((ChangeList)this.getUserObject()).getChanges()) {
            for (Change incomingChange : changes) {
                if (change != incomingChange) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
        if (!(this.userObject instanceof LocalChangeList)) {
            return;
        }
        LocalChangeList dropList = (LocalChangeList)this.getUserObject();
        dragOwner.moveChangesTo(dropList, dragBean.getChanges());
        ArrayList<VirtualFile> toUpdate = new ArrayList<VirtualFile>();
        ChangesBrowserChangeListNode.addIfNotNull(toUpdate, dragBean.getUnversionedFiles());
        ChangesBrowserChangeListNode.addIfNotNull(toUpdate, dragBean.getIgnoredFiles());
        if (!toUpdate.isEmpty()) {
            dragOwner.addUnversionedFiles(dropList, toUpdate);
        }
    }

    private static void addIfNotNull(List<VirtualFile> unversionedFiles1, List<VirtualFile> ignoredFiles) {
        if (ignoredFiles != null) {
            unversionedFiles1.addAll(ignoredFiles);
        }
    }

    @Override
    public int getSortWeight() {
        if (this.userObject instanceof LocalChangeList && ((LocalChangeList)this.userObject).isDefault()) {
            return 1;
        }
        return 2;
    }

    @Override
    public int compareUserObjects(Object o2) {
        if (o2 instanceof ChangeList) {
            return ((ChangeList)this.getUserObject()).getName().compareToIgnoreCase(((ChangeList)o2).getName());
        }
        return 0;
    }
}

