/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.lang.java.JavaFindUsagesProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil");

    private MoveClassesOrPackagesUtil() {
    }

    public static UsageInfo[] findUsages(PsiElement element, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, String newQName) {
        PsiManager manager = element.getManager();
        ArrayList<UsageInfo> results = new ArrayList<UsageInfo>();
        HashSet<PsiReference> foundReferences = new HashSet<PsiReference>();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)manager.getProject());
        for (PsiReference reference : ReferencesSearch.search((PsiElement)element, (SearchScope)projectScope, (boolean)false)) {
            TextRange range = reference.getRangeInElement();
            if (foundReferences.contains(reference)) continue;
            results.add((UsageInfo)new MoveRenameUsageInfo(reference.getElement(), reference, range.getStartOffset(), range.getEndOffset(), element, false));
            foundReferences.add(reference);
        }
        MoveClassesOrPackagesUtil.findNonCodeUsages(searchInStringsAndComments, searchInNonJavaFiles, element, newQName, results);
        MoveClassesOrPackagesUtil.preprocessUsages(results);
        return results.toArray(new UsageInfo[results.size()]);
    }

    private static void preprocessUsages(ArrayList<UsageInfo> results) {
        for (MoveClassHandler handler2 : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
            handler2.preprocessUsages(results);
        }
    }

    public static void findNonCodeUsages(boolean searchInStringsAndComments, boolean searchInNonJavaFiles, PsiElement element, String newQName, ArrayList<UsageInfo> results) {
        String stringToSearch = MoveClassesOrPackagesUtil.getStringToSearch(element);
        if (stringToSearch == null) {
            return;
        }
        TextOccurrencesUtil.findNonCodeUsages(element, stringToSearch, searchInStringsAndComments, searchInNonJavaFiles, newQName, results);
    }

    private static String getStringToSearch(PsiElement element) {
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiDirectory) {
            return MoveClassesOrPackagesUtil.getStringToSearch((PsiElement)JavaDirectoryService.getInstance().getPackage((PsiDirectory)element));
        }
        LOG.error("Unknown element type");
        return null;
    }

    public static PsiPackage doMovePackage(PsiPackage aPackage, MoveDestination moveDestination) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        PackageWrapper targetPackage = moveDestination.getTargetPackage();
        String newPrefix = "".equals(targetPackage.getQualifiedName()) ? "" : targetPackage.getQualifiedName() + ".";
        String newPackageQualifiedName = newPrefix + aPackage.getName();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)aPackage.getProject());
        for (PsiDirectory dir : dirs = aPackage.getDirectories(projectScope)) {
            PsiDirectory targetDirectory = moveDestination.getTargetDirectory(dir);
            if (targetDirectory == null) continue;
            MoveClassesOrPackagesUtil.moveDirectoryRecursively(dir, targetDirectory);
        }
        aPackage.handleQualifiedNameChange(newPackageQualifiedName);
        return JavaPsiFacade.getInstance((Project)targetPackage.getManager().getProject()).findPackage(newPackageQualifiedName);
    }

    public static void moveDirectoryRecursively(PsiDirectory dir, PsiDirectory destination) throws IncorrectOperationException {
        if (dir.getParentDirectory() == destination) {
            return;
        }
        MoveClassesOrPackagesUtil.moveDirectoryRecursively(dir, destination, new HashSet<VirtualFile>());
    }

    private static void moveDirectoryRecursively(PsiDirectory dir, PsiDirectory destination, HashSet<VirtualFile> movedPaths) throws IncorrectOperationException {
        PsiDirectory subdirectoryInDest;
        String sourcePackageName;
        PsiManager manager = dir.getManager();
        VirtualFile destVFile = destination.getVirtualFile();
        VirtualFile sourceVFile = dir.getVirtualFile();
        if (movedPaths.contains(sourceVFile)) {
            return;
        }
        String targetName = dir.getName();
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        if (aPackage != null && !(sourcePackageName = aPackage.getName()).equals(targetName)) {
            targetName = sourcePackageName;
        }
        boolean isSourceRoot = RefactoringUtil.isSourceRoot(dir);
        if (VfsUtil.isAncestor((VirtualFile)sourceVFile, (VirtualFile)destVFile, (boolean)false) || isSourceRoot) {
            PsiDirectory exitsingSubdir = destination.findSubdirectory(targetName);
            if (exitsingSubdir == null) {
                subdirectoryInDest = destination.createSubdirectory(targetName);
                movedPaths.add(subdirectoryInDest.getVirtualFile());
            } else {
                subdirectoryInDest = exitsingSubdir;
            }
        } else {
            subdirectoryInDest = destination.findSubdirectory(targetName);
        }
        if (subdirectoryInDest == null) {
            VirtualFile virtualFile = dir.getVirtualFile();
            MoveFilesOrDirectoriesUtil.doMoveDirectory(dir, destination);
            movedPaths.add(virtualFile);
        } else {
            PsiDirectory[] subdirectories;
            PsiFile[] files;
            for (PsiFile file2 : files = dir.getFiles()) {
                try {
                    subdirectoryInDest.checkAdd((PsiElement)file2);
                }
                catch (IncorrectOperationException e) {
                    continue;
                }
                MoveFilesOrDirectoriesUtil.doMoveFile(file2, subdirectoryInDest);
            }
            for (PsiDirectory subdirectory : subdirectories = dir.getSubdirectories()) {
                if (subdirectory.equals(subdirectoryInDest)) continue;
                MoveClassesOrPackagesUtil.moveDirectoryRecursively(subdirectory, subdirectoryInDest, movedPaths);
            }
            if (!isSourceRoot && dir.getFiles().length == 0 && dir.getSubdirectories().length == 0) {
                dir.delete();
            }
        }
    }

    public static void prepareMoveClass(PsiClass aClass) {
        for (MoveClassHandler handler2 : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
            handler2.prepareMove(aClass);
        }
    }

    public static void finishMoveClass(PsiClass aClass) {
        for (MoveClassHandler handler2 : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
            handler2.finishMoveClass(aClass);
        }
    }

    public static PsiClass doMoveClass(PsiClass aClass, PsiDirectory moveDestination) throws IncorrectOperationException {
        return MoveClassesOrPackagesUtil.doMoveClass(aClass, moveDestination, true);
    }

    public static PsiClass doMoveClass(PsiClass aClass, PsiDirectory moveDestination, boolean moveAllClassesInFile) throws IncorrectOperationException {
        PsiClass newClass;
        if (!moveAllClassesInFile) {
            for (MoveClassHandler handler2 : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
                newClass = handler2.doMoveClass(aClass, moveDestination);
                if (newClass == null) continue;
                return newClass;
            }
        }
        PsiFile file2 = aClass.getContainingFile();
        PsiPackage newPackage = JavaDirectoryService.getInstance().getPackage(moveDestination);
        newClass = aClass;
        PsiDirectory containingDirectory = file2.getContainingDirectory();
        if (!Comparing.equal((Object)moveDestination.getVirtualFile(), (Object)(containingDirectory != null ? containingDirectory.getVirtualFile() : null))) {
            LOG.assertTrue(file2.getVirtualFile() != null, (Object)aClass);
            MoveFilesOrDirectoriesUtil.doMoveFile(file2, moveDestination);
            if (file2 instanceof PsiClassOwner && newPackage != null && !FileTypeUtils.isInServerPageFile((PsiElement)file2)) {
                String aClassName = aClass.getName();
                ((PsiClassOwner)file2).setPackageName(newPackage.getQualifiedName());
                newClass = MoveClassesOrPackagesUtil.findClassByName((PsiClassOwner)file2, aClassName);
                LOG.assertTrue(newClass != null, (Object)("name: " + aClassName + ", file: " + file2 + ", classes: " + StringUtil.join((Object[])((PsiClassOwner)file2).getClasses(), (Function)new Function<PsiClass, String>(){

                    public String fun(PsiClass psiClass) {
                        return psiClass.getName();
                    }
                }, (String)" ")));
            }
        }
        return newClass;
    }

    @Nullable
    private static PsiClass findClassByName(PsiClassOwner file2, String name) {
        PsiClass[] classes;
        for (PsiClass aClass : classes = file2.getClasses()) {
            if (!name.equals(aClass.getName())) continue;
            return aClass;
        }
        return null;
    }

    public static String getPackageName(PackageWrapper aPackage) {
        if (aPackage == null) {
            return null;
        }
        String name = aPackage.getQualifiedName();
        if (name.length() > 0) {
            return name;
        }
        return JavaFindUsagesProvider.DEFAULT_PACKAGE_NAME;
    }

    @Nullable
    public static PsiDirectory chooseDestinationPackage(Project project, String packageName, @Nullable PsiDirectory baseDir) {
        PsiDirectory directory;
        boolean isBaseDirInTestSources;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        final PackageWrapper packageWrapper = new PackageWrapper(psiManager, packageName);
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        PsiDirectory[] directories = aPackage != null ? aPackage.getDirectories() : null;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile baseDirVirtualFile = baseDir != null ? baseDir.getVirtualFile() : null;
        boolean bl = isBaseDirInTestSources = baseDirVirtualFile != null && fileIndex.isInTestSourceContent(baseDirVirtualFile);
        if (directories != null && directories.length == 1 && (baseDirVirtualFile == null || fileIndex.isInTestSourceContent(directories[0].getVirtualFile()) == isBaseDirInTestSources)) {
            directory = directories[0];
        } else {
            final List<VirtualFile> contentSourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots(project);
            if (contentSourceRoots.size() == 1 && (baseDirVirtualFile == null || fileIndex.isInTestSourceContent(contentSourceRoots.get(0)) == isBaseDirInTestSources)) {
                directory = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                    public PsiDirectory compute() {
                        return RefactoringUtil.createPackageDirectoryInSourceRoot(packageWrapper, (VirtualFile)contentSourceRoots.get(0));
                    }
                });
            } else {
                final VirtualFile sourceRootForFile = MoveClassesOrPackagesUtil.chooseSourceRoot(packageWrapper, contentSourceRoots, baseDir);
                if (sourceRootForFile == null) {
                    return null;
                }
                directory = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                    public PsiDirectory compute() {
                        return new AutocreatingSingleSourceRootMoveDestination(packageWrapper, sourceRootForFile).getTargetDirectory((PsiDirectory)null);
                    }
                });
            }
        }
        return directory;
    }

    public static VirtualFile chooseSourceRoot(PackageWrapper targetPackage, List<VirtualFile> contentSourceRoots, PsiDirectory initialDirectory) {
        Project project = targetPackage.getManager().getProject();
        LinkedHashSet<PsiDirectory> targetDirectories = new LinkedHashSet<PsiDirectory>();
        HashMap relativePathsToCreate = new HashMap();
        MoveClassesOrPackagesUtil.buildDirectoryList(targetPackage, contentSourceRoots, targetDirectories, (Map<PsiDirectory, String>)relativePathsToCreate);
        PsiDirectory selectedDirectory = DirectoryChooserUtil.chooseDirectory(targetDirectories.toArray(new PsiDirectory[targetDirectories.size()]), initialDirectory, project, (Map<PsiDirectory, String>)relativePathsToCreate);
        if (selectedDirectory == null) {
            return null;
        }
        VirtualFile virt = selectedDirectory.getVirtualFile();
        VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(virt);
        LOG.assertTrue(sourceRootForFile != null);
        return sourceRootForFile;
    }

    public static void buildDirectoryList(PackageWrapper aPackage, List<VirtualFile> contentSourceRoots, LinkedHashSet<PsiDirectory> targetDirectories, Map<PsiDirectory, String> relativePathsToCreate) {
        PsiDirectory[] directories = aPackage.getDirectories();
        block2: for (VirtualFile root : contentSourceRoots) {
            String qNameToCreate;
            for (PsiDirectory directory : directories) {
                if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)directory.getVirtualFile(), (boolean)false)) continue;
                targetDirectories.add(directory);
                continue block2;
            }
            try {
                qNameToCreate = RefactoringUtil.qNameToCreateInSourceRoot(aPackage, root);
            }
            catch (IncorrectOperationException e) {
                continue;
            }
            PsiDirectory currentDirectory = aPackage.getManager().findDirectory(root);
            if (currentDirectory == null) continue;
            String[] shortNames = qNameToCreate.split("\\.");
            for (int j = 0; j < shortNames.length; ++j) {
                String shortName = shortNames[j];
                PsiDirectory subdirectory = currentDirectory.findSubdirectory(shortName);
                if (subdirectory == null) {
                    targetDirectories.add(currentDirectory);
                    StringBuffer postfix = new StringBuffer();
                    for (int k = j; k < shortNames.length; ++k) {
                        String name = shortNames[k];
                        postfix.append(File.separatorChar);
                        postfix.append(name);
                    }
                    relativePathsToCreate.put(currentDirectory, postfix.toString());
                    continue block2;
                }
                currentDirectory = subdirectory;
            }
        }
        LOG.assertTrue(targetDirectories.size() <= contentSourceRoots.size());
        LOG.assertTrue(relativePathsToCreate.size() <= contentSourceRoots.size());
    }
}

