/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.HashMap;
import java.util.Map;
import org.intellij.plugins.relaxNG.config.NoNamespaceConfig;
import org.intellij.plugins.relaxNG.config.NoNamespaceConfigPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NoNamespaceConfig.Mappings", storages={@Storage(file="$WORKSPACE_FILE$")})
class NoNamespaceConfigImpl
extends NoNamespaceConfig
implements PersistentStateComponent<Mappings> {
    private final Map<VirtualFilePointer, VirtualFilePointer> myMappings = new HashMap<VirtualFilePointer, VirtualFilePointer>();
    private final Project myProject;

    NoNamespaceConfigImpl(Project project) {
        this.myProject = project;
    }

    private VirtualFilePointer getMappedPointer(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/config/NoNamespaceConfigImpl", "getMappedPointer"));
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String url = virtualFile.getUrl();
        for (VirtualFilePointer pointer : this.myMappings.keySet()) {
            if (!url.equals(pointer.getUrl())) continue;
            return this.myMappings.get(pointer);
        }
        return null;
    }

    @Override
    @Nullable
    public String getMapping(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/config/NoNamespaceConfigImpl", "getMapping"));
        }
        VirtualFilePointer pointer = this.getMappedPointer(file2);
        return pointer != null ? pointer.getUrl() : null;
    }

    @Override
    public VirtualFile getMappedFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/config/NoNamespaceConfigImpl", "getMappedFile"));
        }
        VirtualFilePointer url = this.getMappedPointer(file2);
        return url != null ? url.getFile() : null;
    }

    @Override
    public void setMapping(@NotNull PsiFile file2, String location) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/config/NoNamespaceConfigImpl", "setMapping"));
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        assert (virtualFile != null);
        String url = virtualFile.getUrl();
        VirtualFilePointerManager manager = VirtualFilePointerManager.getInstance();
        for (VirtualFilePointer pointer : this.myMappings.keySet()) {
            if (!url.equals(pointer.getUrl())) continue;
            if (location == null) {
                this.myMappings.remove(pointer);
                return;
            }
            if (location.equals(this.myMappings.get(pointer).getUrl())) continue;
            this.myMappings.remove(pointer);
            this.myMappings.put(pointer, manager.create(location, (Disposable)this.myProject, null));
            return;
        }
        if (location != null) {
            this.myMappings.put(manager.create(url, (Disposable)this.myProject, null), manager.create(location, (Disposable)this.myProject, null));
        }
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("RELAX-NG.NoNamespaceConfig" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/config/NoNamespaceConfigImpl", "getComponentName"));
        }
        return "RELAX-NG.NoNamespaceConfig";
    }

    public void projectOpened() {
    }

    public void projectClosed() {
        this.reset();
    }

    public Mappings getState() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<VirtualFilePointer, VirtualFilePointer> entry : this.myMappings.entrySet()) {
            map.put(entry.getKey().getUrl(), entry.getValue().getUrl());
        }
        return new Mappings(map);
    }

    public void loadState(Mappings state) {
        this.reset();
        VirtualFilePointerManager manager = VirtualFilePointerManager.getInstance();
        Map<String, String> map = state.myMappings;
        for (String file2 : map.keySet()) {
            this.myMappings.put(manager.create(file2, (Disposable)this.myProject, null), manager.create(map.get(file2), (Disposable)this.myProject, null));
        }
    }

    private void reset() {
        this.myMappings.clear();
    }

    public static class HectorProvider
    implements HectorComponentPanelsProvider {
        @Nullable
        public HectorComponentPanel createConfigurable(@NotNull PsiFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/config/NoNamespaceConfigImpl$HectorProvider", "createConfigurable"));
            }
            if (file2 instanceof XmlFile) {
                try {
                    XmlTag rootTag = ((XmlFile)file2).getDocument().getRootTag();
                    if (rootTag.getNamespace().length() == 0) {
                        return new NoNamespaceConfigPanel(NoNamespaceConfig.getInstance(file2.getProject()), file2);
                    }
                }
                catch (NullPointerException e) {
                    return null;
                }
            }
            return null;
        }
    }

    public static class Mappings {
        @MapAnnotation(surroundWithTag=false, entryTagName="mapping", keyAttributeName="file", valueAttributeName="schema")
        public Map<String, String> myMappings;

        public Mappings() {
            this.myMappings = new HashMap<String, String>();
        }

        Mappings(Map<String, String> map) {
            this.myMappings = map;
        }
    }
}

