/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroupKt;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.VariableContext;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B;\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J!\u0010 \u001a\u0015\u0012\f\u0012\n #*\u0004\u0018\u00010\"0\"0!\u00a2\u0006\u0002\b$2\u0006\u0010%\u001a\u00020&J\n\u0010'\u001a\u0004\u0018\u00010(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010(H\u0016J\n\u0010*\u001a\u0004\u0018\u00010(H\u0016J\n\u0010+\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010,\u001a\u00020\u0006H\u0016J\b\u0010-\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/debugger/frame/CallFrameView;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "Lorg/jetbrains/debugger/VariableContext;", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "script", "Lorg/jetbrains/debugger/Script;", "sourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "isInLibraryContent", "", "(Lorg/jetbrains/debugger/CallFrame;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;Ljava/lang/Boolean;)V", "getCallFrame", "()Lorg/jetbrains/debugger/CallFrame;", "evaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "getScript", "()Lorg/jetbrains/debugger/Script;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "customizePresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "getEqualityObject", "", "getEvaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getEvaluator", "getMemberFilter", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/MemberFilter;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "scope", "Lorg/jetbrains/debugger/Scope;", "getName", "", "getParent", "getScope", "getSourcePosition", "getViewSupport", "watchableAsEvaluationExpression", "script-debugger-ui"})
public final class CallFrameView
extends XStackFrame
implements VariableContext {
    private final SourceInfo sourceInfo;
    private final boolean isInLibraryContent;
    private XDebuggerEvaluator evaluator;
    @NotNull
    private final CallFrame callFrame;
    private final DebuggerViewSupport viewSupport;
    @Nullable
    private final Script script;

    @NotNull
    public Object getEqualityObject() {
        return this.callFrame.getEqualityObject();
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        node.setAlreadySorted(true);
        ScopeVariablesGroupKt.createAndAddScopeList(node, this.callFrame.getVariableScopes(), this, this.callFrame);
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        return this.callFrame.getEvaluateContext();
    }

    @Nullable
    public Void getName() {
        return null;
    }

    @Nullable
    public Void getParent() {
        return null;
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return true;
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        return this.viewSupport;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        return this.viewSupport.getMemberFilter(this);
    }

    @NotNull
    public final Promise<MemberFilter> getMemberFilter(@NotNull Scope scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        return ScopeVariablesGroupKt.createVariableContext(scope, this, this.callFrame).getMemberFilter();
    }

    @Nullable
    public Void getScope() {
        return null;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.viewSupport.createFrameEvaluator(this);
        }
        return this.evaluator;
    }

    @Nullable
    public SourceInfo getSourcePosition() {
        return this.sourceInfo;
    }

    /*
     * Unable to fully structure code
     */
    public void customizePresentation(@NotNull ColoredTextContainer component) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        if (this.sourceInfo == null) {
            scriptName = this.script == null ? "unknown" : this.script.getUrl().trimParameters().toDecodedForm();
            line = this.callFrame.getLine();
            component.append(line == -1 ? scriptName : scriptName + ":" + line, SimpleTextAttributes.ERROR_ATTRIBUTES);
            return;
        }
        fileName = this.sourceInfo.getFile().getName();
        line = this.sourceInfo.getLine() + 1;
        textAttributes = this.isInLibraryContent != false ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        functionName = this.sourceInfo.getFunctionName();
        if (functionName == null) ** GOTO lbl-1000
        var6_8 = functionName;
        if ($receiver$iv.length() == 0 && this.callFrame.getHasOnlyGlobalScope()) lbl-1000:
        // 2 sources

        {
            if (StringsKt.startsWith$default((String)fileName, (String)"index.", (boolean)false, (int)2, null)) {
                v0 = this.sourceInfo.getFile().getParent();
                if (v0 != null) {
                    $receiver$iv = v0;
                    it = (VirtualFile)$receiver$iv;
                    component.append(it.getName() + "/", textAttributes);
                    v1 = Unit.INSTANCE;
                } else {
                    v1 = null;
                }
            }
            component.append(fileName + ":" + line, textAttributes);
        } else {
            $receiver$iv = functionName;
            if ($receiver$iv.length() == 0) {
                component.append("anonymous", this.isInLibraryContent != false ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
            } else {
                component.append(functionName, textAttributes);
            }
            component.append("(), " + fileName + ":" + line, textAttributes);
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
    }

    @NotNull
    public final CallFrame getCallFrame() {
        return this.callFrame;
    }

    @Nullable
    public final Script getScript() {
        return this.script;
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport viewSupport, @Nullable Script script, @Nullable SourceInfo sourceInfo, @Nullable Boolean isInLibraryContent) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        Intrinsics.checkParameterIsNotNull((Object)viewSupport, (String)"viewSupport");
        this.callFrame = callFrame;
        this.viewSupport = viewSupport;
        this.script = script;
        SourceInfo sourceInfo2 = sourceInfo;
        if (sourceInfo2 == null) {
            sourceInfo2 = this.viewSupport.getSourceInfo(this.script, this.callFrame);
        }
        this.sourceInfo = sourceInfo2;
        Boolean bl = isInLibraryContent;
        this.isInLibraryContent = bl != null ? bl : this.sourceInfo != null && this.viewSupport.isInLibraryContent(this.sourceInfo, this.script);
    }

    @JvmOverloads
    public /* synthetic */ CallFrameView(CallFrame callFrame, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            script = null;
        }
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        if ((n & 0x10) != 0) {
            bl = null;
        }
        this(callFrame, debuggerViewSupport, script, sourceInfo, bl);
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport debuggerViewSupport, @Nullable Script script, @Nullable SourceInfo sourceInfo) {
        this(callFrame, debuggerViewSupport, script, sourceInfo, null, 16, null);
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport debuggerViewSupport, @Nullable Script script) {
        this(callFrame, debuggerViewSupport, script, null, null, 24, null);
    }

    @JvmOverloads
    public CallFrameView(@NotNull CallFrame callFrame, @NotNull DebuggerViewSupport debuggerViewSupport) {
        this(callFrame, debuggerViewSupport, null, null, null, 28, null);
    }
}

