/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.info;

import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoClient;
import org.jetbrains.idea.svn.info.InfoConsumer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitInfoClient
extends BaseSvnClient
implements InfoClient {
    public SVNWCClient getClient() {
        return this.myVcs.getSvnKitManager().createWCClient();
    }

    @Override
    public Info doInfo(@NotNull File path, @Nullable SVNRevision revision) throws SvnBindException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/info/SvnKitInfoClient", "doInfo"));
        }
        try {
            return Info.create(this.getClient().doInfo(path, revision));
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public Info doInfo(@NotNull SvnTarget target, @Nullable SVNRevision revision) throws SvnBindException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/info/SvnKitInfoClient", "doInfo"));
        }
        this.assertUrl(target);
        try {
            return Info.create(this.getClient().doInfo(target.getURL(), target.getPegRevision(), revision));
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void doInfo(@NotNull Collection<File> paths, @Nullable InfoConsumer handler) throws SvnBindException {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/idea/svn/info/SvnKitInfoClient", "doInfo"));
        }
        throw new UnsupportedOperationException();
    }
}

