/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionProfileWrapper");
    public static final Key<Function<InspectionProfileWrapper, InspectionProfileWrapper>> CUSTOMIZATION_KEY = Key.create((String)"Inspection Profile Wrapper Customization");
    protected final InspectionProfile myProfile;
    private static boolean alreadyChecked;

    public InspectionProfileWrapper(@NotNull InspectionProfile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInspection/ex/InspectionProfileWrapper", "<init>"));
        }
        this.myProfile = profile;
    }

    @NotNull
    public InspectionToolWrapper[] getInspectionTools(PsiElement element) {
        InspectionToolWrapper[] inspectionToolWrapperArray = this.myProfile.getInspectionTools(element);
        if (inspectionToolWrapperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileWrapper", "getInspectionTools"));
        }
        return inspectionToolWrapperArray;
    }

    public static void checkInspectionsDuplicates(@NotNull InspectionToolWrapper[] toolWrappers) {
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/ex/InspectionProfileWrapper", "checkInspectionsDuplicates"));
        }
        if (alreadyChecked) {
            return;
        }
        alreadyChecked = true;
        THashSet uniqTools = new THashSet(toolWrappers.length);
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            if (uniqTools.add(toolWrapper.getTool())) continue;
            LOG.error("Inspection " + toolWrapper.getDisplayName() + " (" + toolWrapper.getTool().getClass() + ") already registered");
        }
    }

    public String getName() {
        return this.myProfile.getName();
    }

    public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
        return this.myProfile.isToolEnabled(key, element);
    }

    public InspectionToolWrapper getInspectionTool(String shortName, PsiElement element) {
        return this.myProfile.getInspectionTool(shortName, element);
    }

    public void init(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileWrapper", "init"));
        }
        List profileEntries = this.myProfile.getAllEnabledInspectionTools(project);
        for (Tools profileEntry : profileEntries) {
            for (ScopeToolState toolState : profileEntry.getTools()) {
                toolState.getTool().projectOpened(project);
            }
        }
    }

    public void cleanup(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileWrapper", "cleanup"));
        }
        this.myProfile.cleanup(project);
    }

    @NotNull
    public InspectionProfile getInspectionProfile() {
        InspectionProfile inspectionProfile = this.myProfile;
        if (inspectionProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileWrapper", "getInspectionProfile"));
        }
        return inspectionProfile;
    }
}

