/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.notification.Notification;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMessage {
    private boolean myIsRead = false;
    private boolean myIsSubmitting = false;
    private SubmittedReportInfo mySubmissionInfo;
    private String myAdditionalInfo;
    private Notification myNotification;
    private Integer myAssigneeId;
    private final Date myDate = Calendar.getInstance().getTime();

    public abstract String getThrowableText();

    public abstract Throwable getThrowable();

    public abstract String getMessage();

    public boolean isRead() {
        return this.myIsRead;
    }

    public void setRead(boolean aReadFlag) {
        this.myIsRead = aReadFlag;
        if (this.myNotification != null && aReadFlag) {
            this.myNotification.expire();
            this.myNotification = null;
        }
    }

    public void setSubmitted(SubmittedReportInfo info) {
        this.myIsSubmitting = false;
        this.mySubmissionInfo = info;
    }

    public SubmittedReportInfo getSubmissionInfo() {
        return this.mySubmissionInfo;
    }

    public void setNotification(Notification notification) {
        this.myNotification = notification;
    }

    public boolean isSubmitting() {
        return this.myIsSubmitting;
    }

    public void setSubmitting(boolean isSubmitting) {
        this.myIsSubmitting = isSubmitting;
    }

    public boolean isSubmitted() {
        return this.mySubmissionInfo != null && (this.mySubmissionInfo.getStatus() == SubmittedReportInfo.SubmissionStatus.NEW_ISSUE || this.mySubmissionInfo.getStatus() == SubmittedReportInfo.SubmissionStatus.DUPLICATE);
    }

    public String getAdditionalInfo() {
        return this.myAdditionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.myAdditionalInfo = additionalInfo;
    }

    public Date getDate() {
        return this.myDate;
    }

    public Integer getAssigneeId() {
        return this.myAssigneeId;
    }

    public void setAssigneeId(Integer assigneeId) {
        this.myAssigneeId = assigneeId;
    }

    public List<Attachment> getAllAttachments() {
        return Collections.emptyList();
    }

    public List<Attachment> getIncludedAttachments() {
        return ContainerUtil.filter(this.getAllAttachments(), (Condition)new Condition<Attachment>(){

            public boolean value(Attachment attachment) {
                return attachment.isIncluded();
            }
        });
    }

    @NotNull
    public List<Attachment> getAttachments() {
        List<Attachment> list = this.getIncludedAttachments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/AbstractMessage", "getAttachments"));
        }
        return list;
    }
}

