/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class IndentInfo {
    private final int mySpaces;
    private final int myIndentSpaces;
    private final int myHiddenSpaces;
    private final int myLineFeeds;
    private final boolean myForceSkipTabulationsUsage;
    private boolean myIndentEmptyLines;

    public IndentInfo(int lineFeeds, int indentSpaces, int spaces) {
        this(lineFeeds, indentSpaces, spaces, 0, false);
    }

    public IndentInfo(int lineFeeds, int indentSpaces, int spaces, int hiddenSpaces) {
        this(lineFeeds, indentSpaces, spaces, hiddenSpaces, false);
    }

    public IndentInfo(int lineFeeds, int indentSpaces, int spaces, boolean forceSkipTabulationsUsage) {
        this(lineFeeds, indentSpaces, spaces, 0, forceSkipTabulationsUsage);
    }

    public IndentInfo(int lineFeeds, int indentSpaces, int spaces, int hiddenSpaces, boolean forceSkipTabulationsUsage) {
        this.mySpaces = spaces;
        this.myIndentSpaces = indentSpaces;
        this.myLineFeeds = lineFeeds;
        this.myForceSkipTabulationsUsage = forceSkipTabulationsUsage;
        this.myHiddenSpaces = hiddenSpaces;
    }

    public int getSpaces() {
        return this.mySpaces;
    }

    public int getIndentSpaces() {
        return this.myIndentSpaces;
    }

    public String generateNewWhiteSpace(CommonCodeStyleSettings.IndentOptions options) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.myLineFeeds; ++i) {
            if (options.KEEP_INDENTS_ON_EMPTY_LINES && i > 0) {
                int spaces = this.myIndentEmptyLines ? this.myIndentSpaces + options.INDENT_SIZE : this.myIndentSpaces;
                IndentInfo.generateLineWhitespace(buffer, options, spaces, 0, true);
            }
            buffer.append('\n');
        }
        IndentInfo.generateLineWhitespace(buffer, options, this.myIndentSpaces, this.mySpaces, !this.myForceSkipTabulationsUsage || this.myLineFeeds > 0);
        return buffer.toString();
    }

    private static void generateLineWhitespace(@NotNull StringBuffer buffer, @NotNull CommonCodeStyleSettings.IndentOptions options, int indentSpaces, int alignmentSpaces, boolean tabsAllowed) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/formatting/IndentInfo", "generateLineWhitespace"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/formatting/IndentInfo", "generateLineWhitespace"));
        }
        if (options.USE_TAB_CHARACTER && tabsAllowed) {
            if (options.SMART_TABS) {
                int tabCount = indentSpaces / options.TAB_SIZE;
                int leftSpaces = indentSpaces - tabCount * options.TAB_SIZE;
                if (tabCount > 0) {
                    StringUtil.repeatSymbol((Appendable)buffer, (char)'\t', (int)tabCount);
                }
                if (leftSpaces + alignmentSpaces > 0) {
                    StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(leftSpaces + alignmentSpaces));
                }
            } else {
                int size = indentSpaces + alignmentSpaces;
                while (size > 0) {
                    if (size >= options.TAB_SIZE) {
                        buffer.append('\t');
                        size -= options.TAB_SIZE;
                        continue;
                    }
                    buffer.append(' ');
                    --size;
                }
            }
        } else {
            int spaces = indentSpaces + alignmentSpaces;
            if (spaces > 0) {
                StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)spaces);
            }
        }
    }

    public IndentInfo setIndentEmptyLines(boolean indentEmptyLines) {
        this.myIndentEmptyLines = indentEmptyLines;
        return this;
    }
}

