/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startupWizard;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.startupWizard.SelectPluginsStep;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.ui.wizard.WizardModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class StartupWizardModel
extends WizardModel {
    private final Set<String> myDisabledPluginIds = new HashSet();
    private final Map<String, SelectPluginsStep> myStepMap = new HashMap<String, SelectPluginsStep>();
    private Map<PluginId, SelectPluginsStep> myPluginToStepMap = new HashMap<PluginId, SelectPluginsStep>();
    private MultiMap<IdeaPluginDescriptor, IdeaPluginDescriptor> myBackwardDependencies = new MultiMap();
    private SelectPluginsStep myOtherStep;
    private IdeaPluginDescriptor[] myAllPlugins;

    public StartupWizardModel(List<ApplicationInfoEx.PluginChooserPage> pluginChooserPages) {
        super(ApplicationNamesInfo.getInstance().getFullProductName() + " Initial Configuration Wizard");
        this.loadDisabledPlugins(new File(PathManager.getConfigPath()));
        for (ApplicationInfoEx.PluginChooserPage page : pluginChooserPages) {
            if (page.getCategory() == null) {
                this.myOtherStep = new SelectPluginsStep(page.getTitle(), this, null);
                continue;
            }
            this.addSelectPluginsStep(page.getCategory(), page.getTitle(), page.getDependentPlugin());
        }
        if (this.myOtherStep != null) {
            this.add(this.myOtherStep);
        }
        this.myAllPlugins = PluginManager.loadDescriptors(null, ContainerUtil.newArrayList());
        for (IdeaPluginDescriptor pluginDescriptor : this.myAllPlugins) {
            if (pluginDescriptor.getPluginId().getIdString().equals("com.intellij")) continue;
            PluginManager.initClassLoader(this.getClass().getClassLoader(), (IdeaPluginDescriptorImpl)pluginDescriptor);
            SelectPluginsStep step = this.myStepMap.get(pluginDescriptor.getCategory());
            if (step == null) {
                step = this.myOtherStep;
            }
            if (step == null) continue;
            step.addPlugin(pluginDescriptor);
            this.myPluginToStepMap.put(pluginDescriptor.getPluginId(), step);
            for (PluginId pluginId : pluginDescriptor.getDependentPluginIds()) {
                IdeaPluginDescriptor dependee;
                if (ArrayUtil.contains((Object)pluginId, (Object[])pluginDescriptor.getOptionalDependentPluginIds()) || (dependee = this.findPlugin(pluginId)) == null) continue;
                this.myBackwardDependencies.putValue((Object)dependee, (Object)pluginDescriptor);
            }
        }
        for (SelectPluginsStep step : this.myStepMap.values()) {
            step.fillPlugins();
        }
        if (this.myOtherStep != null) {
            this.myOtherStep.fillPlugins();
        }
    }

    @Nullable
    private IdeaPluginDescriptor findPlugin(PluginId pluginId) {
        for (IdeaPluginDescriptor pluginDescriptor : this.myAllPlugins) {
            if (!pluginDescriptor.getPluginId().equals(pluginId)) continue;
            return pluginDescriptor;
        }
        return null;
    }

    static List<PluginId> getNonOptionalDependencies(IdeaPluginDescriptor descriptor) {
        ArrayList<PluginId> result2 = new ArrayList<PluginId>();
        for (PluginId pluginId : descriptor.getDependentPluginIds()) {
            if (pluginId.getIdString().equals("com.intellij") || ArrayUtil.contains((Object)pluginId, (Object[])descriptor.getOptionalDependentPluginIds())) continue;
            result2.add(pluginId);
        }
        return result2;
    }

    private SelectPluginsStep addSelectPluginsStep(String category, String title, String requirePlugin) {
        SelectPluginsStep step = new SelectPluginsStep(title, this, requirePlugin);
        this.add(step);
        this.myStepMap.put(category, step);
        return step;
    }

    public void loadDisabledPlugins(File configDir) {
        PluginManager.loadDisabledPlugins(configDir.getPath(), this.myDisabledPluginIds);
    }

    public Collection<String> getDisabledPluginIds() {
        return this.myDisabledPluginIds;
    }

    public boolean isDisabledPlugin(IdeaPluginDescriptor descriptor) {
        return this.myDisabledPluginIds.contains(descriptor.getPluginId().toString());
    }

    public void setPluginEnabled(IdeaPluginDescriptor desc, boolean value) {
        if (value) {
            this.myDisabledPluginIds.remove(desc.getPluginId().toString());
        } else {
            this.myDisabledPluginIds.add(desc.getPluginId().toString());
        }
    }

    public void setPluginEnabledWithDependencies(IdeaPluginDescriptor desc) {
        this.setPluginEnabled(desc, true);
        for (PluginId id : StartupWizardModel.getNonOptionalDependencies(desc)) {
            IdeaPluginDescriptor dependent = this.findPlugin(id);
            if (dependent == null) continue;
            this.setPluginEnabledWithDependencies(dependent);
        }
    }

    public void setPluginDisabledWithDependents(IdeaPluginDescriptor desc) {
        this.setPluginEnabled(desc, false);
        for (IdeaPluginDescriptor plugin : this.myAllPlugins) {
            if (!ArrayUtil.contains((Object)desc.getPluginId(), (Object[])plugin.getDependentPluginIds()) || ArrayUtil.contains((Object)desc.getPluginId(), (Object[])plugin.getOptionalDependentPluginIds())) continue;
            this.setPluginDisabledWithDependents(plugin);
        }
    }

    public boolean isForceEnable(IdeaPluginDescriptor descriptor) {
        return this.getDependentsOnEarlierPages(descriptor, true).size() > 0;
    }

    public List<IdeaPluginDescriptor> getDependentsOnEarlierPages(IdeaPluginDescriptor descriptor, boolean includeSamePage) {
        ArrayList<IdeaPluginDescriptor> dependents = new ArrayList<IdeaPluginDescriptor>();
        int thisStep = this.getPluginStepIndex(descriptor);
        for (IdeaPluginDescriptor dependent : this.myBackwardDependencies.get((Object)descriptor)) {
            int index;
            if (this.myDisabledPluginIds.contains(dependent.getPluginId().toString()) || (index = this.getPluginStepIndex(dependent)) >= thisStep && (!includeSamePage || index != thisStep || this.getDependentsOnEarlierPages(dependent, true).size() <= 0)) continue;
            dependents.add(dependent);
        }
        return dependents;
    }

    private int getPluginStepIndex(IdeaPluginDescriptor descriptor) {
        return this.getStepIndex(this.myPluginToStepMap.get(descriptor.getPluginId()));
    }
}

