/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EditorWithProviderComposite
extends EditorComposite {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite");
    private FileEditorProvider[] myProviders;

    EditorWithProviderComposite(@NotNull VirtualFile file2, @NotNull FileEditor[] editors, @NotNull FileEditorProvider[] providers, @NotNull FileEditorManagerEx fileEditorManager) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorWithProviderComposite", "<init>"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/openapi/fileEditor/impl/EditorWithProviderComposite", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/openapi/fileEditor/impl/EditorWithProviderComposite", "<init>"));
        }
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/intellij/openapi/fileEditor/impl/EditorWithProviderComposite", "<init>"));
        }
        super(file2, editors, fileEditorManager);
        this.myProviders = providers;
    }

    @NotNull
    public FileEditorProvider[] getProviders() {
        if (this.myProviders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorWithProviderComposite", "getProviders"));
        }
        return this.myProviders;
    }

    @Override
    public boolean isModified() {
        FileEditor[] editors;
        for (FileEditor editor : editors = this.getEditors()) {
            if (!editor.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider() {
        LOG.assertTrue(this.myEditors.length > 0, (Object)this.myEditors.length);
        if (this.myEditors.length == 1) {
            LOG.assertTrue(this.myTabbedPaneWrapper == null);
            Pair pair = Pair.create((Object)this.myEditors[0], (Object)this.myProviders[0]);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorWithProviderComposite", "getSelectedEditorWithProvider"));
            }
            return pair;
        }
        LOG.assertTrue(this.myTabbedPaneWrapper != null);
        int index = this.myTabbedPaneWrapper.getSelectedIndex();
        if (index == -1) {
            index = 0;
        }
        LOG.assertTrue(index >= 0, (Object)index);
        LOG.assertTrue(index < this.myEditors.length, (Object)index);
        Pair pair = Pair.create((Object)this.myEditors[index], (Object)this.myProviders[index]);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorWithProviderComposite", "getSelectedEditorWithProvider"));
        }
        return pair;
    }

    @NotNull
    public HistoryEntry currentStateAsHistoryEntry() {
        Object[] editors = this.getEditors();
        FileEditorState[] states = new FileEditorState[editors.length];
        for (int j = 0; j < states.length; ++j) {
            states[j] = editors[j].getState(FileEditorStateLevel.FULL);
            LOG.assertTrue(states[j] != null);
        }
        int selectedProviderIndex = ArrayUtil.find((Object[])editors, (Object)this.getSelectedEditor());
        LOG.assertTrue(selectedProviderIndex != -1);
        FileEditorProvider[] providers = this.getProviders();
        HistoryEntry historyEntry = new HistoryEntry(this.getFile(), providers, states, providers[selectedProviderIndex]);
        if (historyEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorWithProviderComposite", "currentStateAsHistoryEntry"));
        }
        return historyEntry;
    }

    public void addEditor(@NotNull FileEditor editor, FileEditorProvider provider) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/EditorWithProviderComposite", "addEditor"));
        }
        this.addEditor(editor);
        this.myProviders = (FileEditorProvider[])ArrayUtil.append((Object[])this.myProviders, (Object)provider);
    }
}

