/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleJdkConfigurable
implements Disposable {
    private JdkComboBox myCbModuleJdk;
    private JPanel myJdkPanel;
    private ClasspathEditor myModuleEditor;
    private final ProjectSdksModel myJdksModel;
    private boolean myFreeze = false;
    private final SdkModel.Listener myListener = new SdkModel.Listener(){

        public void sdkAdded(Sdk sdk) {
            ModuleJdkConfigurable.this.reloadModel();
        }

        public void beforeSdkRemove(Sdk sdk) {
            ModuleJdkConfigurable.this.reloadModel();
        }

        public void sdkChanged(Sdk sdk, String previousName) {
            ModuleJdkConfigurable.this.reloadModel();
        }

        public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
            ModuleJdkConfigurable.this.reloadModel();
        }
    };

    public ModuleJdkConfigurable(ClasspathEditor moduleEditor, ProjectSdksModel jdksModel) {
        this.myModuleEditor = moduleEditor;
        this.myJdksModel = jdksModel;
        this.myJdksModel.addListener(this.myListener);
        this.init();
    }

    public JComponent createComponent() {
        return this.myJdkPanel;
    }

    private void reloadModel() {
        this.myFreeze = true;
        this.myCbModuleJdk.reloadModel(new JdkComboBox.ProjectJdkComboBoxItem(), this.getRootModel().getModule().getProject());
        this.reset();
        this.myFreeze = false;
    }

    protected abstract ModifiableRootModel getRootModel();

    private void init() {
        this.myJdkPanel = new JPanel(new GridBagLayout());
        this.myCbModuleJdk = new JdkComboBox(this.myJdksModel);
        this.myCbModuleJdk.insertItemAt(new JdkComboBox.ProjectJdkComboBoxItem(), 0);
        this.myCbModuleJdk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ModuleJdkConfigurable.this.myFreeze) {
                    return;
                }
                Sdk newJdk = ModuleJdkConfigurable.this.myCbModuleJdk.getSelectedJdk();
                ModuleJdkConfigurable.this.myModuleEditor.setSdk(newJdk);
                ModuleJdkConfigurable.this.clearCaches();
            }
        });
        this.myJdkPanel.add((Component)new JLabel(ProjectBundle.message((String)"module.libraries.target.jdk.module.radio", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 6, 12, 0), 0, 0));
        this.myJdkPanel.add((Component)((Object)this.myCbModuleJdk), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(6, 6, 12, 0), 0, 0));
        Project project = this.getRootModel().getModule().getProject();
        JButton setUpButton = new JButton(ApplicationBundle.message((String)"button.new", (Object[])new Object[0]));
        this.myCbModuleJdk.setSetupButton(setUpButton, project, this.myJdksModel, (JdkComboBox.JdkComboBoxItem)new JdkComboBox.ProjectJdkComboBoxItem(), new Condition<Sdk>(){

            public boolean value(Sdk jdk) {
                int res;
                Sdk projectJdk = ModuleJdkConfigurable.this.myJdksModel.getProjectSdk();
                if (projectJdk == null && (res = Messages.showYesNoDialog((Component)ModuleJdkConfigurable.this.myJdkPanel, (String)ProjectBundle.message((String)"project.roots.no.jdk.on.project.message", (Object[])new Object[0]), (String)ProjectBundle.message((String)"project.roots.no.jdk.on.project.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon())) == 0) {
                    ModuleJdkConfigurable.this.myJdksModel.setProjectSdk(jdk);
                    return true;
                }
                return false;
            }
        }, true);
        this.myJdkPanel.add((Component)setUpButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 7, 0), 0, 0));
        JButton editButton = new JButton(ApplicationBundle.message((String)"button.edit", (Object[])new Object[0]));
        this.myCbModuleJdk.setEditButton(editButton, this.getRootModel().getModule().getProject(), new Computable<Sdk>(){

            @Nullable
            public Sdk compute() {
                return ModuleJdkConfigurable.this.getRootModel().getSdk();
            }
        });
        this.myJdkPanel.add((Component)editButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 4, 7, 0), 0, 0));
    }

    private void clearCaches() {
        Module module = this.getRootModel().getModule();
        Project project = module.getProject();
        StructureConfigurableContext context = ModuleStructureConfigurable.getInstance(project).getContext();
        context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, module));
    }

    public void reset() {
        this.myFreeze = true;
        String jdkName = this.getRootModel().getSdkName();
        if (jdkName != null && !this.getRootModel().isSdkInherited()) {
            Sdk selectedModuleJdk = this.myJdksModel.findSdk(jdkName);
            if (selectedModuleJdk != null) {
                this.myCbModuleJdk.setSelectedJdk(selectedModuleJdk);
            } else {
                this.myCbModuleJdk.setInvalidJdk(jdkName);
                this.clearCaches();
            }
        } else {
            this.myCbModuleJdk.setSelectedJdk(null);
        }
        this.myFreeze = false;
    }

    public void dispose() {
        this.myModuleEditor = null;
        this.myCbModuleJdk = null;
        this.myJdkPanel = null;
        this.myJdksModel.removeListener(this.myListener);
    }
}

