/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.peer.impl;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.RemoteFilePath;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class VcsContextFactoryImpl
implements VcsContextFactory {
    @NotNull
    public VcsContext createCachedContextOn(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/peer/impl/VcsContextFactoryImpl", "createCachedContextOn"));
        }
        VcsContext vcsContext = VcsContextWrapper.createCachedInstanceOn(event);
        if (vcsContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createCachedContextOn"));
        }
        return vcsContext;
    }

    @NotNull
    public VcsContext createContextOn(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/peer/impl/VcsContextFactoryImpl", "createContextOn"));
        }
        VcsContextWrapper vcsContextWrapper = new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace(), event.getPresentation().getText());
        if (vcsContextWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createContextOn"));
        }
        return vcsContextWrapper;
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        FilePath filePath = this.createFilePath(virtualFile.getPath(), virtualFile.isDirectory());
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        return filePath;
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(file2);
        FilePath filePath = vf != null ? this.createFilePathOn(vf) : this.createFilePath(file2.getPath(), file2.isDirectory());
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        return filePath;
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull File file2, @NotNull NotNullFunction<File, Boolean> detector) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file2);
        if (virtualFile != null) {
            FilePath filePath = this.createFilePathOn(virtualFile);
            if (filePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
            }
            return filePath;
        }
        FilePath filePath = this.createFilePathOn(file2, (Boolean)detector.fun((Object)file2));
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        return filePath;
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull File file2, boolean isDirectory) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        FilePath filePath = this.createFilePath(file2.getPath(), isDirectory);
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        return filePath;
    }

    @NotNull
    public FilePath createFilePathOnNonLocal(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOnNonLocal"));
        }
        RemoteFilePath remoteFilePath = new RemoteFilePath(path, isDirectory);
        if (remoteFilePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOnNonLocal"));
        }
        return remoteFilePath;
    }

    @NotNull
    public FilePath createFilePathOnDeleted(@NotNull File file2, boolean isDirectory) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOnDeleted"));
        }
        FilePath filePath = this.createFilePathOn(file2, isDirectory);
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOnDeleted"));
        }
        return filePath;
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull VirtualFile parent, @NotNull String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        FilePath filePath = this.createFilePath(parent, name, false);
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        return filePath;
    }

    @NotNull
    public FilePath createFilePath(@NotNull VirtualFile parent, @NotNull String fileName, boolean isDirectory) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePath"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePath"));
        }
        FilePath filePath = this.createFilePath(parent.getPath() + "/" + fileName, isDirectory);
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePath"));
        }
        return filePath;
    }

    @NotNull
    public LocalChangeList createLocalChangeList(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/peer/impl/VcsContextFactoryImpl", "createLocalChangeList"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/peer/impl/VcsContextFactoryImpl", "createLocalChangeList"));
        }
        LocalChangeListImpl localChangeListImpl = LocalChangeListImpl.createEmptyChangeListImpl(project, name);
        if (localChangeListImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createLocalChangeList"));
        }
        return localChangeListImpl;
    }

    @NotNull
    public FilePath createFilePath(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePath"));
        }
        LocalFilePath localFilePath = new LocalFilePath(path, isDirectory);
        if (localFilePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePath"));
        }
        return localFilePath;
    }
}

