/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0002$%B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J(\u0010\u0015\u001a\u0004\u0018\u00010\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0015\u0010\u0019\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020!J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0007R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "", "rawSources", "", "", "canonicalizedUrls", "", "Lcom/intellij/util/Url;", "sourceContents", "(Ljava/util/List;[Lcom/intellij/util/Url;Ljava/util/List;)V", "canonicalizedUrlToSourceIndex", "Lcom/intellij/util/containers/ObjectIntHashMap;", "getCanonicalizedUrls$script_debugger_backend", "()[Lcom/intellij/util/Url;", "[Lcom/intellij/util/Url;", "findByFile", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findMappings", "resolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver$Resolver;", "sourceUrls", "getLocalFilePath", "Lorg/jetbrains/annotations/NotNull;", "entry", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getRawSource", "getSource", "getSourceContent", "sourceIndex", "", "getSourceIndex", "url", "Companion", "Resolver", "script-debugger-backend"})
public final class SourceResolver {
    private final ObjectIntHashMap<Url> canonicalizedUrlToSourceIndex;
    private final List<String> rawSources;
    @NotNull
    private final Url[] canonicalizedUrls;
    private final List<String> sourceContents;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Url getSource(@NotNull MappingEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        int index = entry.getSource();
        return index < 0 ? (Url)null : this.canonicalizedUrls[index];
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final String getSourceContent(@NotNull MappingEntry entry) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        if (UtilKt.isNullOrEmpty(this.sourceContents)) {
            return null;
        }
        int index = entry.getSource();
        if (index >= 0) {
            List<String> list = this.sourceContents;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (index < list.size()) {
                string = this.sourceContents.get(index);
                return string;
            }
        }
        string = null;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final String getSourceContent(int sourceIndex) {
        String string;
        if (UtilKt.isNullOrEmpty(this.sourceContents)) {
            return null;
        }
        if (sourceIndex >= 0) {
            List<String> list = this.sourceContents;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (sourceIndex < list.size()) {
                string = this.sourceContents.get(sourceIndex);
                return string;
            }
        }
        string = null;
        return string;
    }

    public final int getSourceIndex(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return ArrayUtil.indexOf((Object[])this.canonicalizedUrls, (Object)url);
    }

    @Nullable
    public final String getRawSource(@NotNull MappingEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        int index = entry.getSource();
        return index < 0 ? (String)null : this.rawSources.get(index);
    }

    @Nullable
    public final MappingList findMappings(@Nullable VirtualFile sourceFile, @NotNull SourceMap sourceMap, @NotNull Resolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        int index = resolver.resolve(sourceFile, this.canonicalizedUrlToSourceIndex);
        return index < 0 ? (MappingList)null : sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
    }

    @Nullable
    public final MappingList findMappings(@NotNull List<? extends Url> sourceUrls, @NotNull SourceMap sourceMap, @Nullable VirtualFile sourceFile) {
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        for (Url url : sourceUrls) {
            int index = this.canonicalizedUrlToSourceIndex.get((Object)url);
            if (index == -1) continue;
            return sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
        }
        if (sourceFile != null) {
            MappingList mappingList = this.findByFile(sourceMap, sourceFile);
            if (mappingList != null) {
                MappingList mappingList2 = mappingList;
                MappingList it = mappingList2;
                return it;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MappingList findByFile(@NotNull SourceMap sourceMap, @NotNull VirtualFile sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        int index = this.canonicalizedUrlToSourceIndex.get((Object)Urls.newFromVirtualFile(sourceFile).trimParameters());
        if (index != -1) {
            return sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
        }
        if (sourceFile.isInLocalFileSystem() && (index = this.canonicalizedUrlToSourceIndex.get((Object)Urls.newLocalFileUrl(sourceFile))) != -1) {
            return sourceMap.getSourceIndexToMappings$script_debugger_backend()[index];
        }
        VirtualFile canonicalFile = sourceFile.getCanonicalFile();
        if (canonicalFile != null && Intrinsics.areEqual((Object)canonicalFile, (Object)sourceFile) ^ true) {
            int n;
            IntRange intRange = ArraysKt.getIndices((Object[])this.canonicalizedUrls);
            int n2 = intRange.getFirst();
            if (n2 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    Url url;
                    if (Urls.equalsIgnoreParameters(url = this.canonicalizedUrls[i], canonicalFile)) {
                        return sourceMap.getSourceIndexToMappings$script_debugger_backend()[i];
                    }
                    if (i == n) break;
                    ++i;
                }
            }
        }
        return null;
    }

    @Nullable
    public final String getLocalFilePath(@NotNull MappingEntry entry) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        Url url = (Url)ArraysKt.getOrNull((Object[])this.canonicalizedUrls, (int)entry.getSource());
        if (url != null) {
            Url $receiver$iv = url;
            Url it = $receiver$iv;
            string = it.isInLocalFileSystem() ? it.getPath() : (String)null;
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final Url[] getCanonicalizedUrls$script_debugger_backend() {
        return this.canonicalizedUrls;
    }

    /*
     * WARNING - void declaration
     */
    public SourceResolver(@NotNull List<String> rawSources, @NotNull Url[] canonicalizedUrls, @Nullable List<String> sourceContents) {
        Intrinsics.checkParameterIsNotNull(rawSources, (String)"rawSources");
        Intrinsics.checkParameterIsNotNull((Object)canonicalizedUrls, (String)"canonicalizedUrls");
        this.rawSources = rawSources;
        this.canonicalizedUrls = canonicalizedUrls;
        this.sourceContents = sourceContents;
        this.canonicalizedUrlToSourceIndex = SystemInfo.isFileSystemCaseSensitive ? new ObjectIntHashMap(this.rawSources.size()) : new ObjectIntHashMap(this.rawSources.size(), Urls.getCaseInsensitiveUrlHashingStrategy());
        IntRange intRange = CollectionsKt.getIndices((Collection)this.rawSources);
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                void i;
                this.canonicalizedUrlToSourceIndex.put((Object)this.canonicalizedUrls[i], (int)i);
                if (i == n2) break;
                ++i;
            }
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&\u00a8\u0006\t"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceResolver$Resolver;", "", "resolve", "", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "map", "Lcom/intellij/util/containers/ObjectIntHashMap;", "Lcom/intellij/util/Url;", "script-debugger-backend"})
    public static interface Resolver {
        public int resolve(@Nullable VirtualFile var1, @NotNull ObjectIntHashMap<Url> var2);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceResolver$Companion;", "", "()V", "isAbsolute", "", "path", "", "script-debugger-backend"})
    public static final class Companion {
        public final boolean isAbsolute(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return Intrinsics.areEqual((Object)StringsKt.firstOrNull((CharSequence)path), (Object)Character.valueOf('/')) || SystemInfo.isWindows && path.length() > 2 && path.charAt(1) == ':';
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

