/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.intentions.InfixCallToOrdinaryIntention;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/InfixCallFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "expression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class InfixCallFix
extends KotlinQuickFixAction<KtBinaryExpression>
implements CleanupFix {
    public static final Companion Companion = new Companion(null);

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        InfixCallToOrdinaryIntention.Companion.convert((KtBinaryExpression)this.getElement());
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Replace infix call with ordinary call";
    }

    public InfixCallFix(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        super((PsiElement)expression2);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/InfixCallFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtModifierListOwner target;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Diagnostic diagnostic2 = diagnostic;
            if (!(diagnostic2 instanceof DiagnosticWithParameters2)) {
                diagnostic2 = null;
            }
            DiagnosticWithParameters2 diagnosticWithParameters2 = (DiagnosticWithParameters2)diagnostic2;
            Object object = diagnosticWithParameters2 != null ? diagnosticWithParameters2.getA() : null;
            if (!(object instanceof FunctionDescriptor)) {
                object = null;
            }
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)object;
            if (functionDescriptor == null) {
                return null;
            }
            FunctionDescriptor functionDescriptor2 = functionDescriptor;
            Project project = diagnostic.getPsiFile().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"diagnostic.psiFile.project");
            PsiElement psiElement = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, functionDescriptor2);
            if (!(psiElement instanceof KtModifierListOwner)) {
                psiElement = null;
            }
            if ((target = (KtModifierListOwner)psiElement) == null || JetRefactoringUtilKt.canRefactor(target)) {
                return null;
            }
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtOperationReferenceExpression)) {
                psiElement2 = null;
            }
            KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)psiElement2;
            Object object2 = ktOperationReferenceExpression != null ? ktOperationReferenceExpression.getParent() : null;
            if (!(object2 instanceof KtBinaryExpression)) {
                object2 = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)object2;
            if (ktBinaryExpression == null) {
                return null;
            }
            KtBinaryExpression infixCall = ktBinaryExpression;
            return new InfixCallFix(infixCall);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

