/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeSelectionDialog
extends DialogWrapper {
    @NotNull
    private final ThemeSelectionPanel myPanel;

    public ThemeSelectionDialog(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/configurations/ThemeSelectionDialog", "<init>"));
        }
        super(configuration.getModule().getProject());
        this.myPanel = new ThemeSelectionPanel(this, configuration);
        this.setTitle("Select Theme");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel contentPanel = this.myPanel.getContentPanel();
        contentPanel.setPreferredSize(new Dimension(800, 500));
        return contentPanel;
    }

    protected void doOKAction() {
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "AndroidThemeDialog";
    }

    @Nullable
    public String getTheme() {
        return this.myPanel.getTheme();
    }

    public void checkValidation() {
        this.initValidation();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String theme = this.myPanel.getTheme();
        if (theme == null) {
            return new ValidationInfo("Select a theme");
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }
}

