/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.nodes.AndroidManifestFileNode;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestsGroupNode
extends ProjectViewNode<AndroidFacet>
implements DirectoryGroupNode {
    private static final String MANIFESTS_NODE = "manifests";
    @NotNull
    private final Set<VirtualFile> mySources;

    protected AndroidManifestsGroupNode(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull ViewSettings viewSettings, @NotNull Set<VirtualFile> sources) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/AndroidManifestsGroupNode", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/navigator/nodes/AndroidManifestsGroupNode", "<init>"));
        }
        if (viewSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSettings", "com/android/tools/idea/navigator/nodes/AndroidManifestsGroupNode", "<init>"));
        }
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/android/tools/idea/navigator/nodes/AndroidManifestsGroupNode", "<init>"));
        }
        super(project, (Object)facet, viewSettings);
        this.mySources = sources;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/navigator/nodes/AndroidManifestsGroupNode", "contains"));
        }
        return this.mySources.contains(file);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList children = Lists.newArrayList();
        for (VirtualFile manifest : this.mySources) {
            PsiFile psiFile = psiManager.findFile(manifest);
            if (psiFile == null) continue;
            children.add(new AndroidManifestFileNode(this.myProject, psiFile, this.getSettings(), (AndroidFacet)((Object)this.getValue())));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidManifestsGroupNode", "getChildren"));
        }
        return arrayList;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(MANIFESTS_NODE, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = AndroidSourceType.MANIFEST.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(MANIFESTS_NODE);
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public boolean canNavigate() {
        return !this.mySources.isEmpty();
    }

    public void navigate(boolean requestFocus) {
        VirtualFile fileToOpen = this.findFileToOpen(this.mySources);
        if (fileToOpen == null) {
            return;
        }
        new OpenFileDescriptor(this.myProject, fileToOpen).navigate(requestFocus);
    }

    @Nullable
    private VirtualFile findFileToOpen(@NotNull Set<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/navigator/nodes/AndroidManifestsGroupNode", "findFileToOpen"));
        }
        VirtualFile bestFile = (VirtualFile)Iterables.getFirst(files, null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile f : files) {
            IdeaSourceProvider sourceProvider;
            PsiFile psiFile = psiManager.findFile(f);
            if (psiFile == null || (sourceProvider = AndroidManifestFileNode.getSourceProvider((AndroidFacet)((Object)this.getValue()), psiFile)) == null || !"main".equals(sourceProvider.getName())) continue;
            bestFile = f;
        }
        return bestFile;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        if (PsiDirectory.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidManifestsGroupNode", "getDirectories"));
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public Comparable getSortKey() {
        return AndroidSourceType.MANIFEST;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return AndroidSourceType.MANIFEST;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return MANIFESTS_NODE;
    }
}

