/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;

public class HtmlTextCompletionConfidence
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/codeInsight/completion/HtmlTextCompletionConfidence", "shouldSkipAutopopup"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/completion/HtmlTextCompletionConfidence", "shouldSkipAutopopup"));
        }
        ThreeState threeState = HtmlTextCompletionConfidence.shouldSkipAutopopupInHtml(contextElement, offset) ? ThreeState.YES : ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/HtmlTextCompletionConfidence", "shouldSkipAutopopup"));
        }
        return threeState;
    }

    public static boolean shouldSkipAutopopupInHtml(@NotNull PsiElement contextElement, int offset) {
        PsiElement parent;
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/codeInsight/completion/HtmlTextCompletionConfidence", "shouldSkipAutopopupInHtml"));
        }
        ASTNode node = contextElement.getNode();
        if (node != null && node.getElementType() == XmlTokenType.XML_DATA_CHARACTERS && ((parent = contextElement.getParent()) instanceof XmlText || parent instanceof XmlDocument)) {
            String contextElementText = contextElement.getText();
            int endOffset = offset - contextElement.getTextRange().getStartOffset();
            String prefix = contextElementText.substring(0, Math.min(contextElementText.length(), endOffset));
            return !StringUtil.startsWithChar((CharSequence)prefix, (char)'<') && !StringUtil.startsWithChar((CharSequence)prefix, (char)'&');
        }
        return false;
    }
}

