/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.ConstructorBodyGenerator;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateConstructorMatchingSuperFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorMatchingSuperFix");
    private final PsiClass myClass;

    public CreateConstructorMatchingSuperFix(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorMatchingSuperFix", "<init>"));
        }
        this.myClass = aClass;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.constructor.matching.super", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorMatchingSuperFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorMatchingSuperFix", "isAvailable"));
        }
        if (!this.myClass.isValid() || !this.myClass.getManager().isInProject((PsiElement)this.myClass)) {
            return false;
        }
        this.setText(QuickFixBundle.message("create.constructor.matching.super", new Object[0]));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) {
        PsiMethod[] baseConstrs;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorMatchingSuperFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myClass.getContainingFile())) {
            return;
        }
        PsiClass baseClass = this.myClass.getSuperClass();
        LOG.assertTrue(baseClass != null);
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)this.myClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        ArrayList<PsiMethodMember> baseConstructors = new ArrayList<PsiMethodMember>();
        for (PsiMethod baseConstr : baseConstrs = baseClass.getConstructors()) {
            if (!PsiUtil.isAccessible((PsiMember)baseConstr, (PsiElement)this.myClass, (PsiClass)this.myClass)) continue;
            baseConstructors.add(new PsiMethodMember(baseConstr, substitutor));
        }
        CreateConstructorMatchingSuperFix.chooseConstructor2Delegate(project, editor, substitutor, baseConstructors, baseConstrs, this.myClass);
    }

    public static void chooseConstructor2Delegate(final Project project, Editor editor, PsiSubstitutor substitutor, List<PsiMethodMember> baseConstructors, PsiMethod[] baseConstrs, final PsiClass targetClass) {
        ClassMember[] constructors = baseConstructors.toArray(new PsiMethodMember[baseConstructors.size()]);
        if (constructors.length == 0) {
            constructors = new PsiMethodMember[baseConstrs.length];
            for (int i = 0; i < baseConstrs.length; ++i) {
                constructors[i] = new PsiMethodMember(baseConstrs[i], substitutor);
            }
        }
        LOG.assertTrue(constructors.length >= 1);
        boolean isCopyJavadoc = true;
        if (constructors.length > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            MemberChooser chooser = new MemberChooser(constructors, false, true, project);
            chooser.setTitle(QuickFixBundle.message("super.class.constructors.chooser.title", new Object[0]));
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return;
            }
            constructors = (PsiMethodMember[])chooser.getSelectedElements(new PsiMethodMember[0]);
            isCopyJavadoc = chooser.isCopyJavadoc();
        }
        ClassMember[] constructors1 = constructors;
        boolean isCopyJavadoc1 = isCopyJavadoc;
        ApplicationManager.getApplication().runWriteAction(new Runnable((PsiMethodMember[])constructors1, isCopyJavadoc1, editor){
            final /* synthetic */ PsiMethodMember[] val$constructors1;
            final /* synthetic */ boolean val$isCopyJavadoc1;
            final /* synthetic */ Editor val$editor;
            {
                this.val$constructors1 = psiMethodMemberArray;
                this.val$isCopyJavadoc1 = bl;
                this.val$editor = editor;
            }

            @Override
            public void run() {
                try {
                    if (targetClass.getLBrace() == null) {
                        PsiClass psiClass = JavaPsiFacade.getInstance((Project)targetClass.getProject()).getElementFactory().createClass("X");
                        targetClass.addRangeAfter(psiClass.getLBrace(), psiClass.getRBrace(), targetClass.getLastChild());
                    }
                    JVMElementFactory factory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)project);
                    CodeStyleManager formatter = CodeStyleManager.getInstance((Project)project);
                    PsiMethod derived = null;
                    for (PsiMethodMember candidate : this.val$constructors1) {
                        PsiDocComment docComment;
                        PsiMethod base = (PsiMethod)candidate.getElement();
                        derived = GenerateMembersUtil.substituteGenericMethod(base, candidate.getSubstitutor(), (PsiElement)targetClass);
                        if (!this.val$isCopyJavadoc1 && (docComment = derived.getDocComment()) != null) {
                            docComment.delete();
                        }
                        String targetClassName = targetClass.getName();
                        LOG.assertTrue(targetClassName != null, (Object)targetClass);
                        derived.setName(targetClassName);
                        ConstructorBodyGenerator generator = (ConstructorBodyGenerator)ConstructorBodyGenerator.INSTANCE.forLanguage(derived.getLanguage());
                        if (generator != null) {
                            StringBuilder buffer = new StringBuilder();
                            generator.start(buffer, derived.getName(), PsiParameter.EMPTY_ARRAY);
                            generator.generateSuperCallIfNeeded(buffer, derived.getParameterList().getParameters());
                            generator.finish(buffer);
                            PsiMethod stub = factory.createMethodFromText(buffer.toString(), (PsiElement)targetClass);
                            derived.getBody().replace((PsiElement)stub.getBody());
                        }
                        derived = (PsiMethod)formatter.reformat((PsiElement)derived);
                        derived = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)derived);
                        PsiGenerationInfo<PsiMethod> info = OverrideImplementUtil.createGenerationInfo(derived);
                        info.insert(targetClass, null, true);
                        derived = info.getPsiMember();
                    }
                    if (derived != null) {
                        this.val$editor.getCaretModel().moveToOffset(derived.getTextRange().getStartOffset());
                        this.val$editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                UndoUtil.markPsiFileForUndo((PsiFile)targetClass.getContainingFile());
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

