/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JCiPUtil {
    @NonNls
    private static final String IMMUTABLE = "net.jcip.annotations.Immutable";
    @NonNls
    private static final String GUARDED_BY = "net.jcip.annotations.GuardedBy";

    static boolean isJCiPAnnotation(String ref) {
        return "Immutable".equals(ref) || "GuardedBy".equals(ref) || "ThreadSafe".equals("ref");
    }

    private JCiPUtil() {
    }

    public static boolean isImmutable(PsiClass aClass) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{IMMUTABLE});
        if (annotation != null) {
            return true;
        }
        PsiDocComment comment = aClass.getDocComment();
        return comment != null && comment.findTagByName("@Immutable") != null;
    }

    @Nullable
    static String findGuardForMember(PsiMember member) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{GUARDED_BY});
        if (annotation != null) {
            return JCiPUtil.getGuardValue(annotation);
        }
        if (member instanceof PsiCompiledElement && ((member = (PsiMember)member.getNavigationElement()) == null || member instanceof PsiCompiledElement)) {
            return null;
        }
        GuardedTagVisitor visitor = new GuardedTagVisitor();
        member.accept((PsiElementVisitor)visitor);
        return visitor.getGuardString();
    }

    static boolean isGuardedBy(PsiMember member, String guard) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{GUARDED_BY});
        if (annotation != null) {
            PsiAnnotationParameterList parameters = annotation.getParameterList();
            PsiNameValuePair[] pairs = parameters.getAttributes();
            String fieldName = '\"' + guard + '\"';
            for (PsiNameValuePair pair : pairs) {
                PsiAnnotationMemberValue value;
                String name = pair.getName();
                if (!"value".equals(name) && name != null || (value = pair.getValue()) == null || !value.getText().equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isGuardedBy(PsiMember member, PsiField field) {
        return JCiPUtil.isGuardedBy(member, field.getName());
    }

    static boolean isGuardedByAnnotation(PsiAnnotation annotation) {
        return GUARDED_BY.equals(annotation.getQualifiedName());
    }

    static boolean isGuardedByTag(PsiDocTag tag) {
        String text = tag.getText();
        return text.startsWith("@GuardedBy") && text.contains("(") && text.contains(")");
    }

    @Nullable
    static String getGuardValue(PsiAnnotation annotation) {
        PsiNameValuePair[] pairs;
        PsiAnnotationParameterList parameters = annotation.getParameterList();
        for (PsiNameValuePair pair : pairs = parameters.getAttributes()) {
            PsiMember member;
            PsiAnnotationMemberValue psiAnnotationMemberValue;
            String name = pair.getName();
            if (!"value".equals(name) && name != null || (psiAnnotationMemberValue = pair.getValue()) == null) continue;
            String value = psiAnnotationMemberValue.getText();
            String trim = value.substring(1, value.length() - 1).trim();
            if (trim.equals("itself") && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class)) != null) {
                return member.getName();
            }
            return trim;
        }
        return null;
    }

    @NotNull
    static String getGuardValue(PsiDocTag tag) {
        String text = tag.getText();
        String string = text.substring(text.indexOf(40) + 1, text.indexOf(41)).trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/JCiPUtil", "getGuardValue"));
        }
        return string;
    }

    private static class GuardedTagVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private String guardString;

        private GuardedTagVisitor() {
        }

        public void visitDocTag(PsiDocTag tag) {
            super.visitDocTag(tag);
            String text = tag.getText();
            if (text.startsWith("@GuardedBy") && text.contains("(") && text.contains(")")) {
                this.guardString = text.substring(text.indexOf(40) + 1, text.indexOf(41));
            }
        }

        @Nullable
        private String getGuardString() {
            return this.guardString;
        }
    }
}

