/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.palette.PaletteGroupComponent;
import com.intellij.designer.palette.PaletteItemsComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class PaletteContainer
extends JPanel
implements Scrollable {
    public PaletteContainer() {
        super(new PaletteContainerLayout());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private static class PaletteContainerLayout
    implements LayoutManager {
        private PaletteContainerLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = parent.getWidth();
            int height = 0;
            for (Component component : parent.getComponents()) {
                if (!(component instanceof PaletteGroupComponent)) continue;
                PaletteGroupComponent groupComponent = (PaletteGroupComponent)component;
                groupComponent.setLocation(0, height);
                if (groupComponent.isVisible()) {
                    int groupHeight = groupComponent.getPreferredSize().height;
                    groupComponent.setSize(width, groupHeight);
                    height += groupHeight;
                } else {
                    groupComponent.setSize(0, 0);
                }
                if (!groupComponent.isSelected() && groupComponent.isVisible()) continue;
                PaletteItemsComponent itemsComponent = groupComponent.getItemsComponent();
                int itemsHeight = itemsComponent.getPreferredSize().height;
                itemsComponent.setBounds(0, height, width, itemsHeight);
                height += itemsHeight;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int width = parent.getWidth();
            int height = 0;
            for (Component component : parent.getComponents()) {
                if (!(component instanceof PaletteGroupComponent)) continue;
                PaletteGroupComponent groupComponent = (PaletteGroupComponent)component;
                height += groupComponent.getHeight();
                if (!groupComponent.isSelected()) continue;
                height += groupComponent.getItemsComponent().getPreferredHeight(width);
            }
            return new Dimension(10, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

