/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffEmptyHighlighterRenderer;
import com.intellij.diff.util.DiffLineMarkerRenderer;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.ui.JBColor;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffDrawUtil {
    private static final int STRIPE_LAYER = 4999;
    private static final int DEFAULT_LAYER = 5997;
    private static final int INLINE_LAYER = 5998;
    private static final int LINE_MARKER_LAYER = 5999;
    public static final double CTRL_PROXIMITY_X = 0.3;

    private DiffDrawUtil() {
    }

    @NotNull
    public static Color getDividerColor() {
        Color color = DiffDrawUtil.getDividerColor(null);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getDividerColor"));
        }
        return color;
    }

    @NotNull
    public static Color getDividerColor(@Nullable Editor editor) {
        Color color = DiffDrawUtil.getDividerColorFromScheme(editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme());
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getDividerColor"));
        }
        return color;
    }

    @NotNull
    public static Color getDividerColorFromScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/diff/util/DiffDrawUtil", "getDividerColorFromScheme"));
        }
        Color gutterBackground = scheme.getColor(EditorColors.GUTTER_BACKGROUND);
        if (gutterBackground == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        Color color = gutterBackground;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getDividerColorFromScheme"));
        }
        return color;
    }

    public static void drawConnectorLineSeparator(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawConnectorLineSeparator"));
        }
        DiffDrawUtil.drawConnectorLineSeparator(g, x1, x2, start1, end1, start2, end2, null);
    }

    public static void drawConnectorLineSeparator(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable EditorColorsScheme scheme) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawConnectorLineSeparator"));
        }
        DiffLineSeparatorRenderer.drawConnectorLine(g, x1, x2, start1, start2, end1 - start1, scheme);
    }

    public static void drawDoubleChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawDoubleChunkBorderLine"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDrawUtil", "drawDoubleChunkBorderLine"));
        }
        UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
        UIUtil.drawLine((Graphics2D)g, (int)x1, (int)(y + 1), (int)x2, (int)(y + 1), null, (Color)color);
    }

    public static void drawChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawChunkBorderLine"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDrawUtil", "drawChunkBorderLine"));
        }
        UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
    }

    public static void drawDottedDoubleChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawDottedDoubleChunkBorderLine"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDrawUtil", "drawDottedDoubleChunkBorderLine"));
        }
        UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
        UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)y, null, (Color)color, (boolean)false);
    }

    public static void drawDottedChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawDottedChunkBorderLine"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDrawUtil", "drawDottedChunkBorderLine"));
        }
        UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
    }

    public static void drawChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color, boolean doubleLine, boolean dottedLine) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawChunkBorderLine"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDrawUtil", "drawChunkBorderLine"));
        }
        if (dottedLine && doubleLine) {
            DiffDrawUtil.drawDottedDoubleChunkBorderLine(g, x1, x2, y, color);
        } else if (dottedLine) {
            DiffDrawUtil.drawDottedChunkBorderLine(g, x1, x2, y, color);
        } else if (doubleLine) {
            DiffDrawUtil.drawDoubleChunkBorderLine(g, x1, x2, y, color);
        } else {
            DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y, color);
        }
    }

    public static void drawTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @NotNull Color color) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawTrapezium"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDrawUtil", "drawTrapezium"));
        }
        DiffDrawUtil.drawTrapezium(g, x1, x2, start1, end1, start2, end2, color, null);
    }

    public static void drawTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawTrapezium"));
        }
        if (fillColor != null) {
            int[] xPoints = new int[]{x1, x2, x2, x1};
            int[] yPoints = new int[]{start1, start2, end2 + 1, end1 + 1};
            g.setColor(fillColor);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawLine(x1, start1, x2, start2);
            g.drawLine(x1, end1, x2, end2);
        }
    }

    public static void drawCurveTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @NotNull Color color) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawCurveTrapezium"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDrawUtil", "drawCurveTrapezium"));
        }
        DiffDrawUtil.drawCurveTrapezium(g, x1, x2, start1, end1, start2, end2, color, null);
    }

    public static void drawCurveTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawCurveTrapezium"));
        }
        Shape upperCurve = DiffDrawUtil.makeCurve(x1, x2, start1, start2, true);
        Shape lowerCurve = DiffDrawUtil.makeCurve(x1, x2, end1 + 1, end2 + 1, false);
        Shape lowerCurveBorder = DiffDrawUtil.makeCurve(x1, x2, end1, end2, false);
        if (fillColor != null) {
            Path2D.Double path = new Path2D.Double();
            path.append(upperCurve, true);
            path.append(lowerCurve, true);
            g.setColor(fillColor);
            g.fill(path);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.draw(upperCurve);
            g.draw(lowerCurveBorder);
        }
    }

    private static Shape makeCurve(int x1, int x2, int y1, int y2, boolean forward) {
        int width = x2 - x1;
        if (forward) {
            return new CubicCurve2D.Double(x1, y1, (double)x1 + (double)width * 0.3, y1, (double)x1 + (double)width * 0.7, y2, x1 + width, y2);
        }
        return new CubicCurve2D.Double(x1 + width, y2, (double)x1 + (double)width * 0.7, y2, (double)x1 + (double)width * 0.3, y1, x1, y1);
    }

    @NotNull
    private static TextAttributes getTextAttributes(final @NotNull TextDiffType type, final @Nullable Editor editor, final boolean ignored) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "getTextAttributes"));
        }
        TextAttributes textAttributes = new TextAttributes(){

            public Color getBackgroundColor() {
                return ignored ? type.getIgnoredColor(editor) : type.getColor(editor);
            }
        };
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getTextAttributes"));
        }
        return textAttributes;
    }

    @NotNull
    private static TextAttributes getStripeTextAttributes(final @NotNull TextDiffType type, final @NotNull Editor editor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "getStripeTextAttributes"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "getStripeTextAttributes"));
        }
        TextAttributes textAttributes = new TextAttributes(){

            public Color getErrorStripeColor() {
                return type.getMarkerColor(editor);
            }
        };
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getStripeTextAttributes"));
        }
        return textAttributes;
    }

    private static void installGutterRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType type, boolean ignoredFoldingOutline, boolean resolved) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/diff/util/DiffDrawUtil", "installGutterRenderer"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "installGutterRenderer"));
        }
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new DiffLineMarkerRenderer(type, ignoredFoldingOutline, resolved));
    }

    private static void installEmptyRangeRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType type) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/diff/util/DiffDrawUtil", "installEmptyRangeRenderer"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "installEmptyRangeRenderer"));
        }
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new DiffEmptyHighlighterRenderer(type));
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        List<RangeHighlighter> list = DiffDrawUtil.createHighlighter(editor, start, end, type, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type, boolean ignored) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        List<RangeHighlighter> list = DiffDrawUtil.createHighlighter(editor, start, end, type, ignored, HighlighterTargetArea.EXACT_RANGE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type, boolean ignored, @NotNull HighlighterTargetArea area) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        List<RangeHighlighter> list = DiffDrawUtil.createHighlighter(editor, start, end, type, ignored, area, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type, boolean ignored, @NotNull HighlighterTargetArea area, boolean resolved) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        TextAttributes attributes = start != end && !resolved ? DiffDrawUtil.getTextAttributes(type, editor, ignored) : null;
        TextAttributes stripeAttributes = start != end && !resolved ? DiffDrawUtil.getStripeTextAttributes(type, editor) : null;
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(start, end, 5997, attributes, area);
        DiffDrawUtil.installGutterRenderer(highlighter, type, ignored, resolved);
        if (stripeAttributes == null) {
            List<RangeHighlighter> list = Collections.singletonList(highlighter);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
            }
            return list;
        }
        RangeHighlighter stripeHighlighter = editor.getMarkupModel().addRangeHighlighter(start, end, 4999, stripeAttributes, area);
        List list = ContainerUtil.list((Object[])new RangeHighlighter[]{highlighter, stripeHighlighter});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createInlineHighlighter(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createInlineHighlighter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createInlineHighlighter"));
        }
        TextAttributes attributes = DiffDrawUtil.getTextAttributes(type, editor, false);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(start, end, 5998, attributes, HighlighterTargetArea.EXACT_RANGE);
        if (start == end) {
            DiffDrawUtil.installEmptyRangeRenderer(highlighter, type);
        }
        List<RangeHighlighter> list = Collections.singletonList(highlighter);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createInlineHighlighter"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type, @NotNull SeparatorPlacement placement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        List<RangeHighlighter> list = DiffDrawUtil.createLineMarker(editor, line, type, placement, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type, @NotNull SeparatorPlacement placement, boolean doubleLine) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        List<RangeHighlighter> list = DiffDrawUtil.createLineMarker(editor, line, type, placement, doubleLine, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(final @NotNull Editor editor, int line, final @NotNull TextDiffType type, @NotNull SeparatorPlacement placement, final boolean doubleLine, final boolean applied) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        LineSeparatorRenderer renderer = new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                Rectangle clip = g.getClipBounds();
                x2 = clip.x + clip.width;
                DiffDrawUtil.drawChunkBorderLine((Graphics2D)g, x1, x2, y, type.getColor(editor), doubleLine, applied);
            }
        };
        List<RangeHighlighter> list = DiffDrawUtil.createLineMarker(editor, line, placement, type, renderer, applied);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createBorderLineMarker(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createBorderLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createBorderLineMarker"));
        }
        LineSeparatorRenderer renderer = new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                Rectangle clip = g.getClipBounds();
                x2 = clip.x + clip.width;
                g.setColor(JBColor.border());
                g.drawLine(x1, y, x2, y);
            }
        };
        List<RangeHighlighter> list = DiffDrawUtil.createLineMarker(editor, line, placement, null, renderer, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createBorderLineMarker"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement, @Nullable TextDiffType type, @NotNull LineSeparatorRenderer renderer, boolean applied) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        int offset = DocumentUtil.getFirstNonSpaceCharOffset(editor.getDocument(), line);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 5999, null, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setLineSeparatorPlacement(placement);
        highlighter.setLineSeparatorRenderer(renderer);
        if (type == null || applied) {
            List<RangeHighlighter> list = Collections.singletonList(highlighter);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
            }
            return list;
        }
        TextAttributes stripeAttributes = DiffDrawUtil.getStripeTextAttributes(type, editor);
        RangeHighlighter stripeHighlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
        List list = ContainerUtil.list((Object[])new RangeHighlighter[]{highlighter, stripeHighlighter});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2, @NotNull BooleanGetter condition) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineSeparatorHighlighter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/diff/util/DiffDrawUtil", "createLineSeparatorHighlighter"));
        }
        RangeHighlighter marker = editor.getMarkupModel().addRangeHighlighter(offset1, offset2, 5999, null, HighlighterTargetArea.LINES_IN_RANGE);
        DiffLineSeparatorRenderer renderer = new DiffLineSeparatorRenderer(editor, condition);
        marker.setLineSeparatorPlacement(SeparatorPlacement.TOP);
        marker.setLineSeparatorRenderer((LineSeparatorRenderer)renderer);
        marker.setLineMarkerRenderer((LineMarkerRenderer)renderer);
        List<RangeHighlighter> list = Collections.singletonList(marker);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineSeparatorHighlighter"));
        }
        return list;
    }
}

