/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.HyperLink;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.AttachToProcessListener;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTRunnerConsoleView
extends BaseTestsOutputConsoleView {
    private SMTestRunnerResultsForm myResultsViewer;
    @Nullable
    private final String mySplitterProperty;
    private final List<AttachToProcessListener> myAttachToProcessListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public SMTRunnerConsoleView(TestConsoleProperties consoleProperties, ExecutionEnvironment environment) {
        this(consoleProperties, environment, null);
    }

    public SMTRunnerConsoleView(TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable String splitterProperty) {
        super(consoleProperties, null);
        this.mySplitterProperty = splitterProperty;
    }

    public SMTRunnerConsoleView(TestConsoleProperties consoleProperties) {
        this(consoleProperties, (String)null);
    }

    public SMTRunnerConsoleView(TestConsoleProperties consoleProperties, @Nullable String splitterProperty) {
        super(consoleProperties, null);
        this.mySplitterProperty = splitterProperty;
    }

    @Override
    protected TestResultsPanel createTestResultsPanel() {
        this.myResultsViewer = new SMTestRunnerResultsForm(this.getConsole().getComponent(), this.getConsole().createConsoleActions(), this.myProperties, this.mySplitterProperty);
        return this.myResultsViewer;
    }

    @Override
    public void initUI() {
        super.initUI();
        this.myResultsViewer.addEventsListener(new TestResultsViewer.SMEventsAdapter(){

            @Override
            public void onSelected(final @Nullable SMTestProxy selectedTestProxy, @NotNull TestResultsViewer viewer, @NotNull TestFrameworkRunningModel model) {
                if (viewer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/execution/testframework/sm/runner/ui/SMTRunnerConsoleView$1", "onSelected"));
                }
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/execution/testframework/sm/runner/ui/SMTRunnerConsoleView$1", "onSelected"));
                }
                if (selectedTestProxy == null) {
                    return;
                }
                SMRunnerUtil.runInEventDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        SMTRunnerConsoleView.this.getPrinter().updateOnTestSelected(selectedTestProxy);
                    }
                }, ModalityState.NON_MODAL);
            }
        });
    }

    public SMTestRunnerResultsForm getResultsViewer() {
        return this.myResultsViewer;
    }

    @Override
    public void print(final @NotNull String s, final @NotNull ConsoleViewContentType contentType) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/testframework/sm/runner/ui/SMTRunnerConsoleView", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/testframework/sm/runner/ui/SMTRunnerConsoleView", "print"));
        }
        this.myResultsViewer.getRoot().addLast(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(s, contentType);
            }
        });
    }

    @Override
    public void printHyperlink(String hyperlinkText, HyperlinkInfo info) {
        this.myResultsViewer.getRoot().addLast(new HyperLink(hyperlinkText, info));
    }

    @Override
    public void attachToProcess(ProcessHandler processHandler2) {
        super.attachToProcess(processHandler2);
        for (AttachToProcessListener listener : this.myAttachToProcessListeners) {
            listener.onAttachToProcess(processHandler2);
        }
    }

    public void addAttachToProcessListener(@NotNull AttachToProcessListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/testframework/sm/runner/ui/SMTRunnerConsoleView", "addAttachToProcessListener"));
        }
        this.myAttachToProcessListeners.add(listener);
    }

    public void remoteAttachToProcessListener(@NotNull AttachToProcessListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/testframework/sm/runner/ui/SMTRunnerConsoleView", "remoteAttachToProcessListener"));
        }
        this.myAttachToProcessListeners.remove(listener);
    }

    @Override
    public void dispose() {
        this.myAttachToProcessListeners.clear();
        super.dispose();
    }
}

