/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import java.awt.GraphicsConfiguration;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AWTUtilitiesWrapper {
    private static Class<?> awtUtilitiesClass;
    private static Class<?> translucencyClass;
    private static Method mIsTranslucencySupported;
    private static Method mIsTranslucencyCapable;
    private static Method mSetWindowShape;
    private static Method mSetWindowOpacity;
    private static Method mSetWindowOpaque;
    public static Object PERPIXEL_TRANSPARENT;
    public static Object TRANSLUCENT;
    public static Object PERPIXEL_TRANSLUCENT;

    static void init() {
        try {
            ?[] kinds;
            awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
            translucencyClass = Class.forName("com.sun.awt.AWTUtilities$Translucency");
            if (translucencyClass.isEnum() && (kinds = translucencyClass.getEnumConstants()) != null) {
                PERPIXEL_TRANSPARENT = kinds[0];
                TRANSLUCENT = kinds[1];
                PERPIXEL_TRANSLUCENT = kinds[2];
            }
            mIsTranslucencySupported = awtUtilitiesClass.getMethod("isTranslucencySupported", translucencyClass);
            mIsTranslucencyCapable = awtUtilitiesClass.getMethod("isTranslucencyCapable", GraphicsConfiguration.class);
            mSetWindowShape = awtUtilitiesClass.getMethod("setWindowShape", Window.class, Shape.class);
            mSetWindowOpacity = awtUtilitiesClass.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            mSetWindowOpaque = awtUtilitiesClass.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static boolean isSupported(Method method, Object kind) {
        if (awtUtilitiesClass == null || method == null) {
            return false;
        }
        try {
            Object ret = method.invoke(null, kind);
            if (ret instanceof Boolean) {
                return (Boolean)ret;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isTranslucencySupported(Object kind) {
        if (!AWTUtilitiesWrapper.isTranslucencyAPISupported()) {
            return false;
        }
        return AWTUtilitiesWrapper.isSupported(mIsTranslucencySupported, kind);
    }

    public static boolean isTranslucencyAPISupported() {
        return translucencyClass != null;
    }

    public static boolean isTranslucencyCapable(GraphicsConfiguration gc) {
        return AWTUtilitiesWrapper.isSupported(mIsTranslucencyCapable, gc);
    }

    private static void set(Method method, Window window, Object value) {
        if (awtUtilitiesClass == null || method == null) {
            return;
        }
        try {
            method.invoke(null, window, value);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static void setWindowShape(Window window, Shape shape) {
        AWTUtilitiesWrapper.set(mSetWindowShape, window, shape);
    }

    public static void setWindowOpacity(Window window, float opacity) {
        AWTUtilitiesWrapper.set(mSetWindowOpacity, window, Float.valueOf(opacity));
    }

    public static void setWindowOpaque(Window window, boolean opaque) {
        AWTUtilitiesWrapper.set(mSetWindowOpaque, window, opaque);
    }

    static {
        AWTUtilitiesWrapper.init();
    }
}

