/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BasePlatformRefactoringAction;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class IntroduceFunctionalParameterAction
extends BasePlatformRefactoringAction {
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.functional.parameter.title");

    @Override
    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    @Override
    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/actions/IntroduceFunctionalParameterAction", "isEnabledOnElements"));
        }
        return false;
    }

    @Override
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/actions/IntroduceFunctionalParameterAction", "getRefactoringHandler"));
        }
        return new IntroduceParameterHandler(){

            @Override
            public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/actions/IntroduceFunctionalParameterAction$1", "invoke"));
                }
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/actions/IntroduceFunctionalParameterAction$1", "invoke"));
                }
                if (dataContext != null) {
                    PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                    if (file2 != null && editor != null && !this.introduceStrategy(project, editor, file2, elements)) {
                        this.showErrorMessage(project, editor);
                    }
                }
            }

            @Override
            public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file2, DataContext dataContext) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/actions/IntroduceFunctionalParameterAction$1", "invoke"));
                }
                ExtractMethodHandler.selectAndPass(project, editor, file2, new Pass<PsiElement[]>(){

                    public void pass(PsiElement[] elements) {
                        if (!this.introduceStrategy(project, editor, file2, elements)) {
                            this.showErrorMessage(project, editor);
                        }
                    }
                });
            }

            private void showErrorMessage(@NotNull Project project, Editor editor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/actions/IntroduceFunctionalParameterAction$1", "showErrorMessage"));
                }
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.introduceParameter");
            }
        };
    }
}

