/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodHandler;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineOptionsWithSearchSettingsDialog;

public class InlineMethodDialog
extends InlineOptionsWithSearchSettingsDialog {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.method.title");
    private final PsiJavaCodeReferenceElement myReferenceElement;
    private final Editor myEditor;
    private final boolean myAllowInlineThisOnly;
    private final PsiMethod myMethod;
    private int myOccurrencesNumber = -1;

    public InlineMethodDialog(Project project, PsiMethod method, PsiJavaCodeReferenceElement ref, Editor editor, boolean allowInlineThisOnly) {
        super(project, true, (PsiElement)method);
        this.myMethod = method;
        this.myReferenceElement = ref;
        this.myEditor = editor;
        this.myAllowInlineThisOnly = allowInlineThisOnly;
        this.myInvokedOnReference = ref != null;
        this.setTitle(REFACTORING_NAME);
        this.myOccurrencesNumber = InlineMethodDialog.initOccurrencesNumber((PsiNameIdentifierOwner)method);
        this.init();
    }

    @Override
    protected String getNameLabelText() {
        String methodText = PsiFormatUtil.formatMethod((PsiMethod)this.myMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        return RefactoringBundle.message((String)"inline.method.method.label", (Object[])new Object[]{methodText});
    }

    @Override
    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.method.border.title");
    }

    @Override
    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.invocation.only.and.keep.the.method");
    }

    @Override
    protected String getInlineAllText() {
        String occurrencesString = this.myOccurrencesNumber > -1 ? " (" + this.myOccurrencesNumber + " occurrence" + (this.myOccurrencesNumber == 1 ? ")" : "s)") : "";
        return (this.myMethod.isWritable() ? RefactoringBundle.message((String)"all.invocations.and.remove.the.method") : RefactoringBundle.message((String)"all.invocations.in.project")) + occurrencesString;
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.invokeRefactoring(new InlineMethodProcessor(this.getProject(), this.myMethod, this.myReferenceElement, this.myEditor, this.isInlineThisOnly(), this.isSearchInCommentsAndStrings(), this.isSearchForTextOccurrences()));
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_METHOD_THIS = this.isInlineThisOnly();
        }
    }

    protected void doHelpAction() {
        if (this.myMethod.isConstructor()) {
            HelpManager.getInstance().invokeHelp("refactoring.inlineConstructor");
        } else {
            HelpManager.getInstance().invokeHelp("refactoring.inlineMethod");
        }
    }

    @Override
    protected boolean canInlineThisOnly() {
        return InlineMethodHandler.checkRecursive(this.myMethod) || this.myAllowInlineThisOnly;
    }

    @Override
    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_METHOD_THIS;
    }

    @Override
    protected boolean isSearchInCommentsAndStrings() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD;
    }

    @Override
    protected void saveSearchInCommentsAndStrings(boolean searchInComments) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD = searchInComments;
    }

    @Override
    protected boolean isSearchForTextOccurrences() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD;
    }

    @Override
    protected void saveSearchInTextOccurrences(boolean searchInTextOccurrences) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD = searchInTextOccurrences;
    }
}

