/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tokenindex;

import com.intellij.tokenindex.TokenIndexKey;
import com.intellij.util.containers.HashSet;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TokenIndexKeyDescriptor
implements KeyDescriptor<TokenIndexKey> {
    public int getHashCode(TokenIndexKey value) {
        return value.hashCode();
    }

    public boolean isEqual(TokenIndexKey val1, TokenIndexKey val2) {
        return val1.equals(val2);
    }

    public void save(@NotNull DataOutput out, TokenIndexKey value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/tokenindex/TokenIndexKeyDescriptor", "save"));
        }
        Set<String> languages = value.getLanguages();
        out.writeInt(languages.size());
        for (String language : languages) {
            out.writeUTF(language);
        }
        out.writeInt(value.getBlockId());
    }

    public TokenIndexKey read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/tokenindex/TokenIndexKeyDescriptor", "read"));
        }
        int languagesCount = in.readInt();
        HashSet languages = new HashSet();
        for (int i = 0; i < languagesCount; ++i) {
            String languageId = in.readUTF();
            languages.add(languageId);
        }
        int blockId = in.readInt();
        return new TokenIndexKey((Set<String>)languages, blockId);
    }
}

