/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.UriUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.NetUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandlerKt;
import org.jetbrains.io.NettyKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u001a\"\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bH\u0000\u001a\u001a\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "canBeAccessedDirectly", "", "path", "", "compareNameAndProjectBasePath", "projectName", "project", "Lcom/intellij/openapi/project/Project;", "doProcess", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectNameAsHost", "findIndexFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "basedir", "Ljava/io/File;", "isOwnHostName", "host", "toIdeaPath", "decodedPath", "offset", "", "built-in-server"})
public final class BuiltInWebServerKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(BuiltInWebServer.class);

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean doProcess(FullHttpRequest request, ChannelHandlerContext context, String projectNameAsHost) {
        block18: {
            decodedPath = URLUtil.unescapePercentSequences((String)UriUtil.trimParameters(request.uri()));
            offset = new Ref.IntRef();
            isEmptyPath = new Ref.BooleanRef();
            isCustomHost = projectNameAsHost != null;
            projectName = new Ref.ObjectRef();
            if (isCustomHost) {
                v0 = projectNameAsHost;
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                projectName.element = v0;
                offset.element = 0;
                var8_8 = decodedPath;
                var18_9 = isEmptyPath;
                var18_9.element = var19_10 = $receiver$iv.length() == 0;
            } else {
                offset.element = StringsKt.indexOf$default((CharSequence)decodedPath, (char)'/', (int)1, (boolean)false, (int)4, null);
                $receiver$iv = decodedPath;
                $i$f$isEmpty = true;
                var10_14 = offset.element == -1 ? decodedPath.length() : offset.element;
                var18_9 = projectName;
                v1 = $receiver$iv;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                v2 = v1.substring((int)startIndex$iv, (int)endIndex$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                var19_11 = v2;
                var18_9.element = var19_11;
                isEmptyPath.element = offset.element == -1;
            }
            $receiver$iv = new Ref.ObjectRef();
            $receiver$iv.element = null;
            endIndex$iv = ProjectManager.getInstance().getOpenProjects();
            for ($i$f$substring = 0; $i$f$substring < ((void)$receiver$iv).length; ++$i$f$substring) {
                block20: {
                    block21: {
                        block19: {
                            element$iv = $receiver$iv[$i$f$substring];
                            project = (Project)element$iv;
                            if (!project.isDisposed()) break block19;
                            v3 = false;
                            break block20;
                        }
                        name = project.getName();
                        if (!isCustomHost) break block21;
                        if (!StringsKt.equals((String)((String)projectName.element), (String)name, (boolean)true)) ** GOTO lbl-1000
                        if (!SystemInfoRt.isFileSystemCaseSensitive) {
                            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                            projectName.element = projectName.element;
                        }
                        v3 = true;
                        break block20;
                    }
                    v4 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"name");
                    if (!StringsKt.regionMatches((String)decodedPath, (int)1, (String)v4, (int)0, (int)name.length(), (boolean)(SystemInfoRt.isFileSystemCaseSensitive == false))) ** GOTO lbl-1000
                    v5 = isEmptyPathCandidate = decodedPath.length() == name.length() + 1;
                    if (isEmptyPathCandidate || decodedPath.charAt(name.length() + 1) == '/') {
                        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                        projectName.element = projectName.element;
                        offset.element = name.length() + 1;
                        isEmptyPath.element = isEmptyPathCandidate;
                        v3 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        if ((Project)candidateByDirectoryName.element == null && BuiltInWebServerKt.compareNameAndProjectBasePath((String)projectName.element, project)) {
                            candidateByDirectoryName.element = project;
                        }
                        v3 = false;
                    }
                }
                if (!v3) continue;
                v6 = element$iv;
                break block18;
            }
            v6 = null;
        }
        if ((v7 = (Project)v6) == null) {
            v7 = (Project)candidateByDirectoryName.element;
        }
        if (v7 == null) {
            return false;
        }
        project = v7;
        if (isEmptyPath.element) {
            v8 = (HttpRequest)request;
            v9 = context.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"context.channel()");
            WebServerPathHandlerKt.redirectToDirectory(v8, v9, (String)projectName.element);
            return true;
        }
        v10 = decodedPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"decodedPath");
        path = BuiltInWebServerKt.toIdeaPath(v10, offset.element);
        if (path == null) {
            BuiltInWebServerKt.LOG.warn(decodedPath + " is not valid");
            Responses.sendStatus(HttpResponseStatus.NOT_FOUND, context.channel(), (HttpRequest)request);
            return true;
        }
        if (NettyKt.getOrigin((HttpRequest)request) == null && NettyKt.getReferrer((HttpRequest)request) == null && NettyKt.isRegularBrowser((HttpRequest)request) && !BuiltInWebServerKt.canBeAccessedDirectly(path)) {
            Responses.sendStatus(HttpResponseStatus.NOT_FOUND, context.channel(), (HttpRequest)request);
            return true;
        }
        var13_20 = (WebServerPathHandler[])WebServerPathHandler.Companion.getEP_NAME$built_in_server().getExtensions();
        for (var12_19 = 0; var12_19 < var13_20.length; ++var12_19) {
            pathHandler = var13_20[var12_19];
            name = BuiltInWebServerKt.LOG;
            try {
                v11 = (String)projectName.element;
                v12 = decodedPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"decodedPath");
                if (!pathHandler.process(path, project, request, context, v11, v12, isCustomHost)) continue;
                return true;
            }
            catch (ProcessCanceledException e$iv) {
                continue;
            }
            catch (Throwable e$iv) {
                $receiver$iv.error(e$iv);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final String toIdeaPath(String decodedPath, int offset) {
        void startIndex$iv;
        String $receiver$iv = decodedPath;
        String string = $receiver$iv;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(offset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String path = string2;
        if (!StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null)) {
            return null;
        }
        $receiver$iv = FileUtil.toCanonicalPath((String)path, (char)'/');
        boolean $i$f$substring = true;
        String string3 = $receiver$iv;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring((int)startIndex$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        return string4;
    }

    public static final boolean compareNameAndProjectBasePath(@NotNull String projectName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String basePath = project.getBasePath();
        return basePath != null && FileUtilKt.endsWithName(basePath, projectName);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile findIndexFile(@NotNull VirtualFile basedir) {
        void elements$iv;
        VirtualFile[] children2;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
                children2 = basedir.getChildren();
                if (children2 == null) break block6;
                Object[] $receiver$iv = children2;
                if (!($receiver$iv.length == 0)) break block7;
            }
            return null;
        }
        String[] stringArray = new String[]{"index.", "default."};
        String[] stringArray2 = (String[])((Object[])elements$iv);
        for (int i = 0; i < stringArray2.length; ++i) {
            String indexNamePrefix = stringArray2[i];
            VirtualFile index = null;
            String preferredName = indexNamePrefix + "html";
            for (int j = 0; j < children2.length; ++j) {
                VirtualFile child = children2[j];
                if (child.isDirectory()) continue;
                String name = child.getName();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2, null)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final File findIndexFile(@NotNull File basedir) {
        void elements$iv;
        File[] children2;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
                children2 = basedir.listFiles(findIndexFile.children.1.INSTANCE);
                if (children2 == null) break block6;
                Object[] $receiver$iv = children2;
                if (!($receiver$iv.length == 0)) break block7;
            }
            return null;
        }
        String[] stringArray = new String[]{"index.", "default."};
        String[] stringArray2 = (String[])((Object[])elements$iv);
        for (int i = 0; i < stringArray2.length; ++i) {
            String indexNamePrefix = stringArray2[i];
            File index = null;
            String preferredName = indexNamePrefix + "html";
            for (int j = 0; j < children2.length; ++j) {
                File child = children2[j];
                if (child.isDirectory()) continue;
                String name = child.getName();
                if (Intrinsics.areEqual((Object)name, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name, (String)indexNamePrefix, (boolean)false, (int)2, null)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    public static final boolean isOwnHostName(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            if (Intrinsics.areEqual((Object)host, (Object)address.getHostAddress()) || StringsKt.equals((String)host, (String)address.getCanonicalHostName(), (boolean)true)) {
                return true;
            }
            String localHostName = InetAddress.getLocalHost().getHostName();
            return StringsKt.equals((String)localHostName, (String)host, (boolean)true) || StringsKt.endsWith$default((String)host, (String)".local", (boolean)false, (int)2, null) && StringsKt.regionMatches((String)localHostName, (int)0, (String)host, (int)0, (int)(host.length() - ".local".length()), (boolean)true);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private static final boolean canBeAccessedDirectly(String path) {
        WebServerFileHandler[] webServerFileHandlerArray = (WebServerFileHandler[])WebServerFileHandler.Companion.getEP_NAME$built_in_server().getExtensions();
        for (int i = 0; i < webServerFileHandlerArray.length; ++i) {
            WebServerFileHandler fileHandler = webServerFileHandlerArray[i];
            String[] stringArray = fileHandler.getPageFileExtensions();
            for (int j = 0; j < stringArray.length; ++j) {
                String ext = stringArray[j];
                if (!FileUtilRt.extensionEquals((String)path, (String)ext)) continue;
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean access$doProcess(@NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @Nullable String projectNameAsHost) {
        return BuiltInWebServerKt.doProcess(request, context, projectNameAsHost);
    }
}

