/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.StaticFileHandlerKt;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiProcessor;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0016J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/builtInWebServer/StaticFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "pageFileExtensions", "", "", "getPageFileExtensions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "ssiProcessor", "Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "processSsi", "", "file", "Ljava/io/File;", "path", "built-in-server"})
final class StaticFileHandler
extends WebServerFileHandler {
    @NotNull
    private final String[] pageFileExtensions;
    private SsiProcessor ssiProcessor;

    @Override
    @NotNull
    public String[] getPageFileExtensions() {
        return this.pageFileExtensions;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost) {
        block11: {
            File file2;
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
                Intrinsics.checkParameterIsNotNull((Object)canonicalPath, (String)"canonicalPath");
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                if (pathInfo.getIoFile() != null) break block10;
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                if (!virtualFile.isInLocalFileSystem()) break block11;
            }
            if ((file2 = pathInfo.getIoFile()) == null) {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                File file3 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                file2 = file3;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"VfsUtilCore.virtualToIoFile(pathInfo.file!!)");
            }
            File ioFile = file2;
            String nameSequence = pathInfo.getName();
            if (!(StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtml") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".stm") || StringUtilRt.endsWithIgnoreCase((CharSequence)nameSequence, (CharSequence)".shtm"))) {
                File file4 = VfsUtilCore.virtualToIoFile((VirtualFile)pathInfo.getRoot());
                Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"VfsUtilCore.virtualToIoFile(pathInfo.root)");
                StaticFileHandlerKt.access$sendIoFile(channel, ioFile, file4, (HttpRequest)request);
                return true;
            }
            String string = PathUtilRt.getParentPath((String)((Object)canonicalPath).toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getParentPath(canonicalPath.toString())");
            this.processSsi(ioFile, string, project, request, channel);
            return true;
        }
        VirtualFile virtualFile = pathInfo.getFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile file5 = virtualFile;
        HttpResponse httpResponse = FileResponses.prepareSend((HttpRequest)request, channel, file5.getTimeStamp(), file5.getName());
        if (httpResponse == null) return true;
        HttpResponse response = httpResponse;
        boolean keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)file5.getLength());
        }
        channel.write((Object)response);
        if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
            channel.write((Object)new ChunkedStream(file5.getInputStream()));
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (keepAlive) return true;
        future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processSsi(File file2, String path, Project project, FullHttpRequest request, Channel channel) {
        boolean keepAlive;
        if (this.ssiProcessor == null) {
            this.ssiProcessor = new SsiProcessor(false);
        }
        ByteBuf buffer = channel.alloc().ioBuffer();
        boolean releaseBuffer = true;
        try {
            HttpResponse httpResponse;
            long lastModified;
            SsiProcessor ssiProcessor = this.ssiProcessor;
            if (ssiProcessor == null) {
                Intrinsics.throwNpe();
            }
            if (FileResponses.prepareSend((HttpRequest)request, channel, lastModified = ssiProcessor.process(new SsiExternalResolver(project, (HttpRequest)request, path, file2.getParentFile()), file2, new ByteBufUtf8Writer(buffer)), file2.getPath()) == null) {
                return;
            }
            HttpResponse response = httpResponse;
            keepAlive = Responses.addKeepAliveIfNeed(response, (HttpRequest)request);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)buffer.readableBytes());
            }
            channel.write((Object)response);
            if (Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD) ^ true) {
                releaseBuffer = false;
                channel.write((Object)buffer);
            }
        }
        finally {
            if (releaseBuffer) {
                buffer.release();
            }
        }
        ChannelFuture future2 = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    /*
     * WARNING - void declaration
     */
    public StaticFileHandler() {
        void elements$iv;
        String[] stringArray = new String[]{"html", "htm", "shtml", "stm", "shtm"};
        StaticFileHandler staticFileHandler = this;
        Object[] objectArray = (Object[])elements$iv;
        staticFileHandler.pageFileExtensions = (String[])objectArray;
    }
}

