/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.google.common.net.InetAddresses;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.NettyKt;
import org.jetbrains.io.NettyUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0010\u001a\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0006\u0010\u0016\u001a\u00020\u0017\u001a&\u0010\u0018\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0010H\u0007\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a#\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0014\b\u0004\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001e0!H\u0086\b\u001a\n\u0010\"\u001a\u00020\u001e*\u00020\n\u001aB\u0010#\u001a\u0004\u0018\u00010\n*\u00020\u00172\u0006\u0010$\u001a\u00020%2\u000e\b\u0002\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010'2\b\b\u0002\u0010(\u001a\u00020)2\u0010\b\u0002\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+H\u0007\u001a#\u0010-\u001a\u00020\u0017*\u00020\u00172\u0014\b\u0004\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001e0!H\u0086\b\u001a \u0010/\u001a\u00020\u0010*\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0010H\u0007\u001a\n\u00100\u001a\u00020\u0010*\u00020\u0002\u001a\n\u00101\u001a\u00020\u0010*\u00020\u0002\u001a\n\u00102\u001a\u00020\u001e*\u000203\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0017\u0010\r\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0004\u00a8\u00064"}, d2={"host", "", "Lio/netty/handler/codec/http/HttpRequest;", "getHost", "(Lio/netty/handler/codec/http/HttpRequest;)Ljava/lang/String;", "origin", "getOrigin", "referrer", "getReferrer", "uriScheme", "Lio/netty/channel/Channel;", "getUriScheme", "(Lio/netty/channel/Channel;)Ljava/lang/String;", "userAgent", "getUserAgent", "isLocalHost", "", "onlyAnyOrLoopback", "hostsOnly", "isTrustedChromeExtension", "uri", "Ljava/net/URI;", "oioClientBootstrap", "Lio/netty/bootstrap/Bootstrap;", "parseAndCheckIsLocalHost", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "group", "Lio/netty/channel/EventLoopGroup;", "addChannelListener", "", "Lio/netty/channel/ChannelFuture;", "listener", "Lkotlin/Function1;", "closeAndShutdownEventLoop", "connect", "remoteAddress", "Ljava/net/InetSocketAddress;", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "maxAttemptCount", "", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "handler", "task", "isLocalOrigin", "isRegularBrowser", "isWriteFromBrowserWithoutOrigin", "shutdownIfOio", "Lio/netty/channel/EventLoop;", "platform-impl"})
public final class NettyKt {
    @NotNull
    public static final Bootstrap handler(Bootstrap $receiver, @NotNull Function1<? super Channel, Unit> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        $receiver.handler((ChannelHandler)new ChannelInitializer<Channel>(task){
            final /* synthetic */ Function1 $task;

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                this.$task.invoke((Object)channel);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
        return $receiver;
    }

    @NotNull
    public static final ServerBootstrap serverBootstrap(@NotNull EventLoopGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(group).channel(group instanceof NioEventLoopGroup ? NioServerSocketChannel.class : OioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ServerBootstrap serverBootstrap = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)serverBootstrap, (String)"bootstrap");
        return serverBootstrap;
    }

    @NotNull
    public static final Bootstrap oioClientBootstrap() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new OioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE))).channel(OioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Bootstrap bootstrap2 = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"bootstrap");
        return bootstrap2;
    }

    public static final void addChannelListener(ChannelFuture $receiver, @NotNull Function1<? super ChannelFuture, Unit> listener) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(listener){
            final /* synthetic */ Function1 $listener;

            public final void operationComplete(ChannelFuture future2) {
                ChannelFuture channelFuture = future2;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"future");
                this.$listener.invoke((Object)channelFuture);
            }
            {
                this.$listener = function1;
            }
        });
    }

    public static final void shutdownIfOio(EventLoop $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof OioEventLoopGroup) {
            EventLoop eventLoop = $receiver;
            if (eventLoop == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.netty.channel.oio.OioEventLoopGroup");
            }
            ((OioEventLoopGroup)eventLoop).shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeAndShutdownEventLoop(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        EventLoop eventLoop = $receiver.eventLoop();
        try {
            $receiver.close().awaitUninterruptibly();
        }
        finally {
            NettyKt.shutdownIfOio(eventLoop);
        }
    }

    @JvmOverloads
    @Nullable
    public static final Channel connect(Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress, @Nullable AsyncPromise<?> promise2, int maxAttemptCount, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)remoteAddress, (String)"remoteAddress");
        try {
            Condition condition = stopCondition;
            if (condition == null) {
                condition = Conditions.alwaysFalse();
            }
            return NettyUtil.doConnect($receiver, remoteAddress, promise2, maxAttemptCount, condition);
        }
        catch (Throwable e) {
            AsyncPromise<?> asyncPromise = promise2;
            Boolean bl = asyncPromise != null ? Boolean.valueOf(asyncPromise.setError(e)) : null;
            return null;
        }
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ Channel connect$default(Bootstrap bootstrap, InetSocketAddress inetSocketAddress, AsyncPromise asyncPromise, int n, Condition condition, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: connect");
        }
        if ((n2 & 2) != 0) {
            asyncPromise = null;
        }
        if ((n2 & 4) != 0) {
            n = 20;
        }
        if ((n2 & 8) != 0) {
            condition = null;
        }
        return NettyKt.connect(bootstrap, inetSocketAddress, asyncPromise, n, (Condition<Void>)condition);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap $receiver, @Nullable InetSocketAddress remoteAddress, @NotNull AsyncPromise<?> promise2, int maxAttemptCount) {
        return NettyKt.connect$default($receiver, remoteAddress, promise2, maxAttemptCount, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap $receiver, @Nullable InetSocketAddress remoteAddress, AsyncPromise<?> promise2) {
        return NettyKt.connect$default($receiver, remoteAddress, promise2, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap $receiver, InetSocketAddress remoteAddress) {
        return NettyKt.connect$default($receiver, remoteAddress, null, 0, null, 14, null);
    }

    @NotNull
    public static final String getUriScheme(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.pipeline().get(SslHandler.class) == null ? "http" : "https";
    }

    @Nullable
    public static final String getHost(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
    }

    @Nullable
    public static final String getOrigin(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.ORIGIN);
    }

    @Nullable
    public static final String getReferrer(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.REFERER);
    }

    @Nullable
    public static final String getUserAgent(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.USER_AGENT);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isLocalHost(@NotNull String host, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        if (onlyAnyOrLoopback && !InetAddresses.isInetAddress((String)host)) {
            return false;
        }
        isLocalHost.1 isLocal$ = isLocalHost.1.INSTANCE;
        try {
            InetAddress address = InetAddress.getByName(host);
            if (!isLocal$.invoke(address)) {
                return false;
            }
            if (hostsOnly && !InetAddresses.isInetAddress((String)host)) {
                void $receiver$iv;
                InetAddress inetAddress = HostsFileEntriesResolver.DEFAULT.address(host);
                InetAddress it = (InetAddress)$receiver$iv;
                return it != null && isLocalHost.1.INSTANCE.invoke(it);
            }
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static /* bridge */ /* synthetic */ boolean isLocalHost$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isLocalHost");
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalHost(string, bl, bl2);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(HttpRequest $receiver, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return NettyKt.parseAndCheckIsLocalHost(NettyKt.getOrigin($receiver), onlyAnyOrLoopback, hostsOnly) && NettyKt.parseAndCheckIsLocalHost(NettyKt.getReferrer($receiver), onlyAnyOrLoopback, hostsOnly);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean isLocalOrigin$default(HttpRequest httpRequest, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isLocalOrigin");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalOrigin(httpRequest, bl, bl2);
    }

    @JvmOverloads
    public static boolean isLocalOrigin(@NotNull HttpRequest $receiver, boolean onlyAnyOrLoopback) {
        return NettyKt.isLocalOrigin$default($receiver, onlyAnyOrLoopback, false, 2, null);
    }

    @JvmOverloads
    public static boolean isLocalOrigin(HttpRequest $receiver) {
        return NettyKt.isLocalOrigin$default($receiver, false, false, 3, null);
    }

    private static final boolean isTrustedChromeExtension(URI uri) {
        return Intrinsics.areEqual((Object)uri.getScheme(), (Object)"chrome-extension") && (Intrinsics.areEqual((Object)uri.getHost(), (Object)"hmhgeddbohgjknpmjagkdomcpobmllji") || Intrinsics.areEqual((Object)uri.getHost(), (Object)"offnedcbhjldheanlbojaefbfbllddna"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@Nullable String uri, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        if (uri == null) {
            return true;
        }
        try {
            URI parsedUri = new URI(uri);
            if (NettyKt.isTrustedChromeExtension(parsedUri)) return true;
            String string = parsedUri.getHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parsedUri.host");
            if (!NettyKt.isLocalHost(string, onlyAnyOrLoopback, hostsOnly)) return false;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean parseAndCheckIsLocalHost$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseAndCheckIsLocalHost");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.parseAndCheckIsLocalHost(string, bl, bl2);
    }

    @JvmOverloads
    public static boolean parseAndCheckIsLocalHost(@Nullable String uri, boolean onlyAnyOrLoopback) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri, onlyAnyOrLoopback, false, 4, null);
    }

    @JvmOverloads
    public static boolean parseAndCheckIsLocalHost(@Nullable String uri) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri, false, false, 6, null);
    }

    public static final boolean isRegularBrowser(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = NettyKt.getUserAgent($receiver);
        return string != null ? StringsKt.startsWith$default((String)string, (String)"Mozilla/5.0", (boolean)false, (int)2, null) : false;
    }

    public static final boolean isWriteFromBrowserWithoutOrigin(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = NettyKt.getUserAgent($receiver);
        if (string == null) {
            return false;
        }
        String userAgent = string;
        HttpMethod method = $receiver.method();
        CharSequence $receiver$iv = NettyKt.getOrigin($receiver);
        return ($receiver$iv == null || $receiver$iv.length() == 0) && NettyKt.isRegularBrowser($receiver) && (Intrinsics.areEqual((Object)method, (Object)HttpMethod.POST) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.PATCH) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.PUT) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.DELETE));
    }
}

