/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependency;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencySetupErrors {
    @NotNull
    private final Map<String, MissingModule> myMissingModules = Maps.newHashMap();
    @NotNull
    private final Map<String, MissingModule> myMissingModulesWithBackupLibraries = Maps.newHashMap();
    @NotNull
    private final Set<String> myDependentsOnModulesWithoutName = Sets.newHashSet();
    @NotNull
    private final Set<String> myDependentsOnLibrariesWithoutBinaryPath = Sets.newHashSet();

    public void addMissingModule(@NotNull String dependencyName, @NotNull String dependentName, @Nullable String backupLibraryName) {
        if (dependencyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyName", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "addMissingModule"));
        }
        if (dependentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentName", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "addMissingModule"));
        }
        Map<String, MissingModule> mapping = StringUtil.isNotEmpty((String)backupLibraryName) ? this.myMissingModulesWithBackupLibraries : this.myMissingModules;
        MissingModule missingModule = mapping.get(dependencyName);
        if (missingModule == null) {
            missingModule = new MissingModule(dependencyName, backupLibraryName);
            mapping.put(dependencyName, missingModule);
        }
        missingModule.addDependent(dependentName);
    }

    public void addMissingName(@NotNull String dependentName) {
        if (dependentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentName", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "addMissingName"));
        }
        this.myDependentsOnModulesWithoutName.add(dependentName);
    }

    public void addMissingBinaryPath(@NotNull String dependentName) {
        if (dependentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentName", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "addMissingBinaryPath"));
        }
        this.myDependentsOnLibrariesWithoutBinaryPath.add(dependentName);
    }

    @NotNull
    public List<MissingModule> getMissingModules() {
        List<MissingModule> list = DependencySetupErrors.getMissingModules(this.myMissingModules);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "getMissingModules"));
        }
        return list;
    }

    @NotNull
    public List<MissingModule> getMissingModulesWithBackupLibraries() {
        List<MissingModule> list = DependencySetupErrors.getMissingModules(this.myMissingModulesWithBackupLibraries);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "getMissingModulesWithBackupLibraries"));
        }
        return list;
    }

    @NotNull
    private static List<MissingModule> getMissingModules(@NotNull Map<String, MissingModule> missingModulesByName) {
        if (missingModulesByName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missingModulesByName", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "getMissingModules"));
        }
        if (missingModulesByName.isEmpty()) {
            List<MissingModule> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "getMissingModules"));
            }
            return list;
        }
        ArrayList missingModules = Lists.newArrayList();
        ArrayList names = Lists.newArrayList(missingModulesByName.keySet());
        if (names.size() > 1) {
            Collections.sort(names);
        }
        for (String name : names) {
            MissingModule missingModule = missingModulesByName.get(name);
            missingModule.sortDependentNames();
            missingModules.add(missingModule);
        }
        ArrayList arrayList = missingModules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "getMissingModules"));
        }
        return arrayList;
    }

    @NotNull
    public List<String> getMissingNames() {
        List<String> list = DependencySetupErrors.sortSet(this.myDependentsOnModulesWithoutName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "getMissingNames"));
        }
        return list;
    }

    @NotNull
    public List<String> getDependentsOnLibrariesWithoutBinaryPath() {
        List<String> list = DependencySetupErrors.sortSet(this.myDependentsOnLibrariesWithoutBinaryPath);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "getDependentsOnLibrariesWithoutBinaryPath"));
        }
        return list;
    }

    @NotNull
    private static List<String> sortSet(@NotNull Set<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "sortSet"));
        }
        if (set.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "sortSet"));
            }
            return list;
        }
        ArrayList sorted = Lists.newArrayList(set);
        if (sorted.size() > 1) {
            Collections.sort(sorted);
        }
        ArrayList arrayList = sorted;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/DependencySetupErrors", "sortSet"));
        }
        return arrayList;
    }

    public static class MissingModule {
        @NotNull
        public final String dependencyPath;
        @NotNull
        public final List<String> dependentNames;
        @Nullable
        public final String backupLibraryName;

        MissingModule(@NotNull String dependencyPath, @Nullable String backupLibraryName) {
            if (dependencyPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyPath", "com/android/tools/idea/gradle/dependency/DependencySetupErrors$MissingModule", "<init>"));
            }
            this.dependentNames = Lists.newArrayList();
            this.dependencyPath = dependencyPath;
            this.backupLibraryName = backupLibraryName;
        }

        void addDependent(@NotNull String dependentName) {
            if (dependentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentName", "com/android/tools/idea/gradle/dependency/DependencySetupErrors$MissingModule", "addDependent"));
            }
            this.dependentNames.add(dependentName);
        }

        void sortDependentNames() {
            if (!this.dependentNames.isEmpty()) {
                Collections.sort(this.dependentNames);
            }
        }
    }
}

