/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.CreateGradleWrapperHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class UnsupportedGradleVersionErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/service/notification/errors/UnsupportedGradleVersionErrorHandler", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/service/notification/errors/UnsupportedGradleVersionErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/UnsupportedGradleVersionErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/UnsupportedGradleVersionErrorHandler", "handleError"));
        }
        String lastLine = message.get(message.size() - 1);
        if ("Please fix the project's Gradle settings.".equals(lastLine) || lastLine.contains("Please point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)")) {
            ArrayList hyperlinks = Lists.newArrayList();
            File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
            if (wrapperPropertiesFile != null) {
                NotificationHyperlink hyperlink = FixGradleVersionInWrapperHyperlink.createIfProjectUsesGradleWrapper(project);
                if (hyperlink != null) {
                    hyperlinks.add(hyperlink);
                }
            } else {
                GradleProjectSettings gradleProjectSettings = GradleUtil.getGradleProjectSettings(project);
                if (gradleProjectSettings != null && gradleProjectSettings.getDistributionType() == DistributionType.LOCAL) {
                    hyperlinks.add(new CreateGradleWrapperHyperlink());
                }
            }
            hyperlinks.add(new OpenGradleSettingsHyperlink());
            UnsupportedGradleVersionErrorHandler.updateNotification(notification, project, error.getMessage(), hyperlinks);
            return true;
        }
        return false;
    }
}

