/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.android.tools.idea.structure.services.ServiceContext;
import com.android.tools.idea.structure.services.ServiceXmlParser;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class DeveloperService {
    @NotNull
    private final ServiceXmlParser myServiceParser;

    public DeveloperService(@NotNull ServiceXmlParser serviceParser) {
        if (serviceParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceParser", "com/android/tools/idea/structure/services/DeveloperService", "<init>"));
        }
        this.myServiceParser = serviceParser;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myServiceParser.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperService", "getModule"));
        }
        return module;
    }

    @NotNull
    public ServiceCategory getCategory() {
        ServiceCategory serviceCategory = this.myServiceParser.getServiceCategory();
        if (serviceCategory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperService", "getCategory"));
        }
        return serviceCategory;
    }

    @NotNull
    public DeveloperServiceMetadata getMetadata() {
        DeveloperServiceMetadata developerServiceMetadata = this.myServiceParser.getDeveloperServiceMetadata();
        if (developerServiceMetadata == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperService", "getMetadata"));
        }
        return developerServiceMetadata;
    }

    @NotNull
    public ServiceContext getContext() {
        ServiceContext serviceContext = this.myServiceParser.getContext();
        if (serviceContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperService", "getContext"));
        }
        return serviceContext;
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myServiceParser.getServicePanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/DeveloperService", "getPanel"));
        }
        return jPanel;
    }

    public void install() {
        Project project = this.myServiceParser.getModule().getProject();
        new WriteCommandAction.Simple(project, "Install " + this.getMetadata().getName(), new PsiFile[0]){

            protected void run() throws Throwable {
                DeveloperService.this.myServiceParser.createRecipe(true);
            }
        }.execute();
        this.getContext().snapshot();
        this.getContext().installed().set(true);
        UsageTracker.getInstance().trackEvent("devServices", "installed", this.getMetadata().getName(), null);
    }

    public void uninstall() {
        if (!this.getContext().installed().get().booleanValue()) {
            return;
        }
        final GradleBuildFile gradleFile = GradleBuildFile.get(this.getModule());
        if (gradleFile != null) {
            boolean dependenciesChanged = false;
            final List<BuildFileStatement> dependencies = gradleFile.getDependencies();
            Iterator<BuildFileStatement> iterator = dependencies.iterator();
            block0: while (iterator.hasNext()) {
                BuildFileStatement statement = iterator.next();
                if (!(statement instanceof Dependency)) continue;
                Dependency dependency = (Dependency)statement;
                for (String dependencyValue : this.getMetadata().getDependencies()) {
                    if (!dependency.getValueAsString().equals(dependencyValue)) continue;
                    iterator.remove();
                    dependenciesChanged = true;
                    continue block0;
                }
            }
            if (dependenciesChanged) {
                new WriteCommandAction.Simple(this.getModule().getProject(), "Uninstall " + this.getMetadata().getName(), new PsiFile[0]){

                    public void run() {
                        gradleFile.setValue(BuildFileKey.DEPENDENCIES, dependencies);
                    }
                }.execute();
            }
            GradleProjectImporter.getInstance().requestProjectSync(this.getModule().getProject(), null);
        }
        this.getContext().installed().set(false);
        UsageTracker.getInstance().trackEvent("devServices", "removed", this.getMetadata().getName(), null);
    }
}

