/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ChooseModulesDialog;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class GeneratePluginClassAction
extends CreateElementActionBase
implements DescriptorUtil.Patcher {
    protected final Set<XmlFile> myFilesToPatch = new HashSet<XmlFile>();
    private static final PsiElement[] CANCELED = new PsiElement[1];

    public GeneratePluginClassAction(String text, String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        PsiElement[] psiElementArray;
        block3: {
            PsiElement[] psiElements = this.invokeDialogImpl(project, directory);
            psiElementArray = psiElements == CANCELED ? PsiElement.EMPTY_ARRAY : psiElements;
            if (psiElementArray != null) break block3;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/actions/GeneratePluginClassAction", "invokeDialog"));
        }
        return psiElementArray;
        finally {
            this.myFilesToPatch.clear();
        }
    }

    protected abstract PsiElement[] invokeDialogImpl(Project var1, PsiDirectory var2);

    private void addPluginModule(Module module) {
        XmlFile pluginXml = PluginModuleType.getPluginXml(module);
        if (pluginXml != null) {
            this.myFilesToPatch.add(pluginXml);
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled()) {
            DataContext context = e.getDataContext();
            Module module = (Module)LangDataKeys.MODULE.getData(context);
            if (PluginModuleType.isPluginModuleOrDependency(module)) {
                IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
                Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
                if (view != null && project != null) {
                    PsiDirectory[] dirs;
                    ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    for (PsiDirectory dir : dirs = view.getDirectories()) {
                        if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || JavaDirectoryService.getInstance().getPackage(dir) == null) continue;
                        return;
                    }
                }
            }
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }
    }

    @Nullable
    protected static Module getModule(PsiDirectory dir) {
        VirtualFile vFile;
        Project project = dir.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (fileIndex.isInLibrarySource(vFile = dir.getVirtualFile()) || fileIndex.isInLibraryClasses(vFile)) {
            List orderEntries = fileIndex.getOrderEntriesForFile(vFile);
            if (orderEntries.isEmpty()) {
                return null;
            }
            HashSet<Module> modules = new HashSet<Module>();
            for (OrderEntry orderEntry : orderEntries) {
                modules.add(orderEntry.getOwnerModule());
            }
            Module[] candidates = modules.toArray(new Module[modules.size()]);
            Arrays.sort(candidates, ModuleManager.getInstance((Project)project).moduleDependencyComparator());
            return candidates[0];
        }
        return fileIndex.getModuleForFile(vFile);
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        Project project = directory.getProject();
        Module module = GeneratePluginClassAction.getModule(directory);
        if (module != null) {
            if (ModuleType.get((Module)module) == PluginModuleType.getInstance()) {
                this.addPluginModule(module);
            } else {
                List<Module> candidateModules = PluginModuleType.getCandidateModules(module);
                Iterator<Module> it = candidateModules.iterator();
                while (it.hasNext()) {
                    Module m = it.next();
                    if (PluginModuleType.getPluginXml(m) != null) continue;
                    it.remove();
                }
                if (candidateModules.size() == 1) {
                    this.addPluginModule(candidateModules.get(0));
                } else {
                    ChooseModulesDialog dialog = new ChooseModulesDialog(project, candidateModules, this.getTemplatePresentation().getDescription());
                    if (!dialog.showAndGet()) {
                        if (CANCELED == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/actions/GeneratePluginClassAction", "create"));
                        }
                        return CANCELED;
                    }
                    List<Module> modules = dialog.getSelectedModules();
                    for (Module m : modules) {
                        this.addPluginModule(m);
                    }
                }
            }
        }
        if (this.myFilesToPatch.size() == 0) {
            throw new IncorrectOperationException(DevKitBundle.message("error.no.plugin.xml", new Object[0]));
        }
        if (this.myFilesToPatch.size() == 0) {
            if (CANCELED == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/actions/GeneratePluginClassAction", "create"));
            }
            return CANCELED;
        }
        PsiClass klass = JavaDirectoryService.getInstance().createClass(directory, newName, this.getClassTemplateName());
        DescriptorUtil.patchPluginXml(this, klass, this.myFilesToPatch.toArray(new XmlFile[this.myFilesToPatch.size()]));
        PsiElement[] psiElementArray = new PsiElement[]{klass};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/actions/GeneratePluginClassAction", "create"));
        }
        return psiElementArray;
    }

    @NonNls
    protected abstract String getClassTemplateName();
}

