/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.converters.MavenDomConvertersRegistry;

public class MavenPluginCustomParameterValueConverter
extends WrappingConverter {
    private final String myType;

    public MavenPluginCustomParameterValueConverter(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/maven/dom/converters/MavenPluginCustomParameterValueConverter", "<init>"));
        }
        this.myType = PsiTypesUtil.boxIfPossible((String)type);
    }

    public Converter getConverter(@NotNull GenericDomValue domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "org/jetbrains/idea/maven/dom/converters/MavenPluginCustomParameterValueConverter", "getConverter"));
        }
        Project project = domElement.getManager().getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass psiClass = psiFacade.findClass(this.myType, GlobalSearchScope.allScope((Project)project));
        if (psiClass != null) {
            GenericDomValueConvertersRegistry convertersRegistry = MavenDomConvertersRegistry.getInstance().getConvertersRegistry();
            return convertersRegistry.getConverter(domElement, (PsiType)psiFacade.getElementFactory().createType(psiClass));
        }
        return null;
    }
}

