/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.serialize.AbstractDecoder;
import org.gradle.internal.serialize.Decoder;

public class InputStreamBackedDecoder
extends AbstractDecoder
implements Decoder,
Closeable {
    private final DataInputStream inputStream;

    public InputStreamBackedDecoder(InputStream inputStream) {
        this.inputStream = new DataInputStream(inputStream);
    }

    protected int maybeReadBytes(byte[] buffer, int offset, int count) throws IOException {
        return this.inputStream.read(buffer, offset, count);
    }

    protected long maybeSkip(long count) throws IOException {
        return this.inputStream.skip(count);
    }

    public long readLong() throws IOException {
        return this.inputStream.readLong();
    }

    public int readInt() throws EOFException, IOException {
        return this.inputStream.readInt();
    }

    public boolean readBoolean() throws EOFException, IOException {
        return this.inputStream.readBoolean();
    }

    public String readString() throws EOFException, IOException {
        return this.inputStream.readUTF();
    }

    public byte readByte() throws IOException {
        return (byte)(this.inputStream.readByte() & 0xFF);
    }

    public void readBytes(byte[] buffer, int offset, int count) throws IOException {
        this.inputStream.readFully(buffer, offset, count);
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

