/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ImplicitReceiversUtilsKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\b\u001a\u00020\u0003*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0007*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0013"}, d2={"getAllAccessibleFunctions", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getAllAccessibleVariables", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "getFileResolutionScope", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getResolutionScope", "Lcom/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "getVariableFromImplicitReceivers", "getVariablesFromImplicitReceivers", "ide-common"})
@JvmName(name="ScopeUtils")
public final class ScopeUtils {
    @NotNull
    public static final Collection<VariableDescriptor> getAllAccessibleVariables(LexicalScope $receiver, @NotNull Name name2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return CollectionsKt.plus(ScopeUtils.getVariablesFromImplicitReceivers($receiver, name2), (Iterable)ScopeUtilsKt.collectVariables($receiver, name2, NoLookupLocation.FROM_IDE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<FunctionDescriptor> getAllAccessibleFunctions(LexicalScope $receiver, @NotNull Name name2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Iterable $receiver$iv = ImplicitReceiversUtilsKt.getImplicitReceiversWithInstance($receiver);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv$iv;
            Iterable list$iv$iv = it.getType().getMemberScope().getContributedFunctions(name2, NoLookupLocation.FROM_IDE);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)ScopeUtilsKt.collectFunctions($receiver, name2, NoLookupLocation.FROM_IDE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<VariableDescriptor> getVariablesFromImplicitReceivers(LexicalScope $receiver, @NotNull Name name2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Iterable $receiver$iv = ImplicitReceiversUtilsKt.getImplicitReceiversWithInstance($receiver);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv$iv;
            Iterable list$iv$iv = it.getType().getMemberScope().getContributedVariables(name2, NoLookupLocation.FROM_IDE);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VariableDescriptor getVariableFromImplicitReceivers(LexicalScope $receiver, @NotNull Name name2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Iterable $receiver$iv = ImplicitReceiversUtilsKt.getImplicitReceiversWithInstance($receiver);
        for (Object element$iv : $receiver$iv) {
            void $receiver$iv2;
            ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)CollectionsKt.singleOrNull((Iterable)it.getType().getMemberScope().getContributedVariables(name2, NoLookupLocation.FROM_IDE));
            if (propertyDescriptor == null) continue;
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            PropertyDescriptor it2 = (PropertyDescriptor)$receiver$iv2;
            return it2;
        }
        return null;
    }

    @NotNull
    public static final LexicalScope getResolutionScope(PsiElement $receiver, @NotNull BindingContext bindingContext2, @NotNull ResolutionFacade resolutionFacade2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacade2, (String)"resolutionFacade");
        for (PsiElement parent2 : PsiUtilsKt.getParentsWithSelf($receiver)) {
            LexicalScope scope2;
            if (parent2 instanceof KtElement && (scope2 = (LexicalScope)bindingContext2.get(BindingContext.LEXICAL_SCOPE, parent2)) != null) {
                return scope2;
            }
            if (parent2 instanceof KtClassBody) {
                ClassDescriptorWithResolutionScopes classDescriptor;
                Object v = bindingContext2.get(BindingContext.CLASS, parent2.getParent());
                if (!(v instanceof ClassDescriptorWithResolutionScopes)) {
                    v = null;
                }
                if ((classDescriptor = (ClassDescriptorWithResolutionScopes)v) != null) {
                    LexicalScope lexicalScope = classDescriptor.getScopeForMemberDeclarationResolution();
                    Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"classDescriptor.scopeFor\u2026mberDeclarationResolution");
                    return lexicalScope;
                }
            }
            if (!(parent2 instanceof KtFile)) continue;
            return ScopeUtils.getFileResolutionScope(resolutionFacade2, (KtFile)parent2);
        }
        String message$iv = "Not in KtFile";
        throw (Throwable)new IllegalStateException(message$iv.toString());
    }

    @NotNull
    public static final LexicalScope getFileResolutionScope(ResolutionFacade $receiver, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ResolutionFacade $receiver$iv = $receiver;
        return $receiver$iv.getFrontendService(FileScopeProvider.class).getFileResolutionScope(file);
    }
}

