/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/DataClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
public final class DataClassDeclarationChecker
implements DeclarationChecker {
    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        if (((ClassDescriptor)descriptor2).isData()) {
            Object parameters2;
            KtPrimaryConstructor primaryConstructor2;
            Object object;
            if (((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() == null) {
                PsiElement $receiver$iv;
                Collection<ConstructorDescriptor> collection = ((ClassDescriptor)descriptor2).getConstructors();
                if (!$receiver$iv.isEmpty()) {
                    Unit unit;
                    PsiElement psiElement = ((KtClassOrObject)declaration).getNameIdentifier();
                    if (psiElement != null) {
                        $receiver$iv = psiElement;
                        PsiElement it = $receiver$iv;
                        diagnosticHolder.report(Errors.PRIMARY_CONSTRUCTOR_REQUIRED_FOR_DATA_CLASS.on(it));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
            }
            if ((object = (primaryConstructor2 = ((KtClassOrObject)declaration).getPrimaryConstructor())) == null || (object = ((KtConstructor)object).getValueParameters()) == null) {
                object = parameters2 = CollectionsKt.emptyList();
            }
            if (parameters2.isEmpty()) {
                Unit unit;
                KtElementImplStub ktElementImplStub = primaryConstructor2;
                PsiElement psiElement = ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getValueParameterList()) != null ? (PsiElement)ktElementImplStub : ((KtClassOrObject)declaration).getNameIdentifier();
                if (psiElement != null) {
                    void $receiver$iv;
                    PsiElement $i$a$1 = psiElement;
                    PsiElement it = (PsiElement)$receiver$iv;
                    diagnosticHolder.report(Errors.DATA_CLASS_WITHOUT_PARAMETERS.on(it));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            Iterator iterator2 = parameters2.iterator();
            while (iterator2.hasNext()) {
                KtParameter parameter = (KtParameter)iterator2.next();
                if (parameter.isVarArg()) {
                    diagnosticHolder.report(Errors.DATA_CLASS_VARARG_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                }
                if (parameter.hasValOrVar()) continue;
                diagnosticHolder.report(Errors.DATA_CLASS_NOT_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }
}

