/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NestedScrollingWidgetDetector
extends LayoutDetector {
    private int mVisitingHorizontalScroll;
    private int mVisitingVerticalScroll;
    public static final Issue ISSUE = Issue.create("NestedScrolling", "Nested scrolling widgets", "A scrolling widget such as a `ScrollView` should not contain any nested scrolling widgets since this has various usability issues", Category.CORRECTNESS, 7, Severity.WARNING, new Implementation(NestedScrollingWidgetDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public void beforeCheckFile(@NonNull Context context) {
        this.mVisitingHorizontalScroll = 0;
        this.mVisitingVerticalScroll = 0;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    @NonNull
    public Collection<String> getApplicableElements() {
        return Arrays.asList("ScrollView", "ListView", "GridView", "Gallery", "HorizontalScrollView");
    }

    private Element findOuterScrollingWidget(Node node, boolean vertical) {
        Collection<String> applicableElements = this.getApplicableElements();
        while (node != null) {
            Element element;
            String tagName;
            if (node instanceof Element && applicableElements.contains(tagName = (element = (Element)node).getTagName()) && vertical == NestedScrollingWidgetDetector.isVerticalScroll(element)) {
                return element;
            }
            node = node.getParentNode();
        }
        return null;
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        Element parent;
        boolean vertical = NestedScrollingWidgetDetector.isVerticalScroll(element);
        if (vertical) {
            ++this.mVisitingVerticalScroll;
        } else {
            ++this.mVisitingHorizontalScroll;
        }
        if ((this.mVisitingHorizontalScroll > 1 || this.mVisitingVerticalScroll > 1) && (parent = this.findOuterScrollingWidget(element.getParentNode(), vertical)) != null) {
            String format = this.mVisitingVerticalScroll > 1 ? "The vertically scrolling `%1$s` should not contain another vertically scrolling widget (`%2$s`)" : "The horizontally scrolling `%1$s` should not contain another horizontally scrolling widget (`%2$s`)";
            String msg = String.format(format, parent.getTagName(), element.getTagName());
            context.report(ISSUE, element, context.getLocation(element), msg);
        }
    }

    @Override
    public void visitElementAfter(@NonNull XmlContext context, @NonNull Element element) {
        if (NestedScrollingWidgetDetector.isVerticalScroll(element)) {
            --this.mVisitingVerticalScroll;
            assert (this.mVisitingVerticalScroll >= 0);
        } else {
            --this.mVisitingHorizontalScroll;
            assert (this.mVisitingHorizontalScroll >= 0);
        }
    }

    private static boolean isVerticalScroll(Element element) {
        String view = element.getTagName();
        if (view.equals("Gallery") || view.equals("HorizontalScrollView")) {
            return false;
        }
        assert (view.equals("ScrollView") || view.equals("ListView") || view.equals("GridView"));
        return true;
    }
}

