/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.actions;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.AntNoFileException;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class AddAntBuildFile
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/ant/config/actions/AddAntBuildFile", "actionPerformed"));
        }
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        VirtualFile[] contextFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (contextFiles == null || contextFiles.length == 0) {
            return;
        }
        AntConfiguration antConfiguration = AntConfiguration.getInstance(project);
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        files.addAll(Arrays.asList(contextFiles));
        for (AntBuildFile buildFile : antConfiguration.getBuildFiles()) {
            files.remove(buildFile.getVirtualFile());
        }
        int filesAdded = 0;
        StringBuilder errors = new StringBuilder();
        for (VirtualFile file : files) {
            try {
                antConfiguration.addBuildFile(file);
                ++filesAdded;
            }
            catch (AntNoFileException e) {
                String message = e.getMessage();
                if (message == null || message.length() == 0) {
                    message = AntBundle.message("cannot.add.build.files.from.excluded.directories.error.message", e.getFile().getPresentableUrl());
                }
                if (errors.length() > 0) {
                    errors.append("\n");
                }
                errors.append(message);
            }
        }
        if (errors.length() > 0) {
            Messages.showWarningDialog((Project)project, (String)errors.toString(), (String)AntBundle.message("cannot.add.build.file.dialog.title", new Object[0]));
        }
        if (filesAdded > 0) {
            ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.ANT_BUILD).activate(null);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/ant/config/actions/AddAntBuildFile", "update"));
        }
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && (files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null && files.length > 0) {
            for (VirtualFile file : files) {
                XmlTag rootTag;
                XmlFile xmlFile;
                XmlDocument document;
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (!(psiFile instanceof XmlFile) || (document = (xmlFile = (XmlFile)psiFile).getDocument()) == null || (rootTag = document.getRootTag()) == null || !"project".equals(rootTag.getName()) || AntConfigurationBase.getInstance(project).getAntBuildFile(psiFile) != null) continue;
                AddAntBuildFile.enable(presentation);
                return;
            }
        }
        AddAntBuildFile.disable(presentation);
    }

    private static void enable(Presentation presentation) {
        presentation.setEnabled(true);
        presentation.setVisible(true);
    }

    private static void disable(Presentation presentation) {
        presentation.setEnabled(false);
        presentation.setVisible(false);
    }
}

