/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.KotlinQuickDocumentationProvider;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.kdoc.KDocFinder;
import org.jetbrains.kotlin.idea.kdoc.KDocReferenceKt;
import org.jetbrains.kotlin.idea.kdoc.KDocRenderer;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.PsiSourceElement;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J$\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0016J&\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinQuickDocumentationProvider;", "Lcom/intellij/lang/documentation/AbstractDocumentationProvider;", "()V", "generateDoc", "", "element", "Lcom/intellij/psi/PsiElement;", "originalElement", "getDocumentationElementForLink", "psiManager", "Lcom/intellij/psi/PsiManager;", "link", "context", "getDocumentationElementForLookupItem", "object", "", "getQuickNavigateInfo", "Companion", "idea"})
public final class KotlinQuickDocumentationProvider
extends AbstractDocumentationProvider {
    private static final Logger LOG;
    private static final DescriptorRenderer DESCRIPTOR_RENDERER;
    public static final Companion Companion;

    @Nullable
    public String getQuickNavigateInfo(@Nullable PsiElement element2, @Nullable PsiElement originalElement) {
        return element2 == null ? (String)null : KotlinQuickDocumentationProvider.Companion.getText(element2, originalElement, true);
    }

    @Nullable
    public String generateDoc(@NotNull PsiElement element2, @Nullable PsiElement originalElement) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return KotlinQuickDocumentationProvider.Companion.getText(element2, originalElement, false);
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(@NotNull PsiManager psiManager, @NotNull String link, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull((Object)psiManager, (String)"psiManager");
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        if (!(context instanceof KtElement)) {
            return null;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)context, BodyResolveMode.PARTIAL);
        DeclarationDescriptor contextDescriptor = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, context);
        if (contextDescriptor == null) {
            return null;
        }
        ResolutionFacade resolutionFacade2 = ResolutionUtils.getResolutionFacade((KtElement)context);
        KDocTag kDocTag = null;
        List list2 = StringUtil.split((String)link, (String)",");
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"StringUtil.split(link, \",\")");
        Collection<DeclarationDescriptor> descriptors = KDocReferenceKt.resolveKDocLink(resolutionFacade2, contextDescriptor, kDocTag, list2);
        DeclarationDescriptor target = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)descriptors);
        if (target instanceof DeclarationDescriptorWithSource) {
            SourceElement source = ((DeclarationDescriptorWithSource)target).getSource();
            SourceElement sourceElement = source;
            if (!(sourceElement instanceof PsiSourceElement)) {
                sourceElement = null;
            }
            PsiSourceElement psiSourceElement = (PsiSourceElement)sourceElement;
            return psiSourceElement != null ? psiSourceElement.getPsi() : null;
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(@NotNull PsiManager psiManager, @Nullable Object object, @Nullable PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)psiManager, (String)"psiManager");
        if (object instanceof DeclarationLookupObject) {
            return ((DeclarationLookupObject)object).getPsiElement();
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(KotlinQuickDocumentationProvider.class);
        DESCRIPTOR_RENDERER = DescriptorRenderer.HTML.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)Companion.DESCRIPTOR_RENDERER.1.INSTANCE));
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinQuickDocumentationProvider$Companion;", "", "()V", "DESCRIPTOR_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "getDESCRIPTOR_RENDERER", "()Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getText", "", "element", "Lcom/intellij/psi/PsiElement;", "originalElement", "quickNavigation", "", "mixKotlinToJava", "declarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "renderKotlinDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "idea"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private final DescriptorRenderer getDESCRIPTOR_RENDERER() {
            return DESCRIPTOR_RENDERER;
        }

        /*
         * WARNING - void declaration
         */
        private final String getText(PsiElement element2, PsiElement originalElement, boolean quickNavigation) {
            if (element2 instanceof KtDeclaration) {
                return this.renderKotlinDeclaration((KtDeclaration)element2, quickNavigation);
            }
            if (element2 instanceof KtLightElement) {
                Object t = ((KtLightElement)element2).getOrigin();
                if (t == null) {
                    return null;
                }
                Object origin = t;
                return this.renderKotlinDeclaration((KtDeclaration)origin, quickNavigation);
            }
            if (quickNavigation) {
                BindingContext context;
                DeclarationDescriptor declarationDescriptor;
                KtReferenceExpression referenceExpression;
                KtReferenceExpression ktReferenceExpression;
                PsiElement psiElement = originalElement;
                if (psiElement != null) {
                    void $receiver$iv;
                    PsiElement psiElement2 = psiElement;
                    ktReferenceExpression = (KtReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtReferenceExpression.class, (boolean)false);
                } else {
                    ktReferenceExpression = referenceExpression = null;
                }
                if (referenceExpression != null && (declarationDescriptor = (DeclarationDescriptor)(context = ResolutionUtils.analyze(referenceExpression, BodyResolveMode.PARTIAL)).get(BindingContext.REFERENCE_TARGET, referenceExpression)) != null) {
                    return this.mixKotlinToJava(declarationDescriptor, element2, originalElement);
                }
            }
            return null;
        }

        private final String renderKotlinDeclaration(KtDeclaration declaration, boolean quickNavigation) {
            KDocTag comment;
            BindingContext context = ResolutionUtils.analyze(declaration, BodyResolveMode.PARTIAL);
            DeclarationDescriptor declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
            if (declarationDescriptor == null) {
                this.getLOG().info("Failed to find descriptor for declaration " + PsiUtilsKt.getElementTextWithContext(declaration));
                return "No documentation available";
            }
            String renderedDecl2 = this.getDESCRIPTOR_RENDERER().render(declarationDescriptor);
            if (!quickNavigation) {
                renderedDecl2 = "<pre>" + renderedDecl2 + "</pre>";
            }
            if ((comment = KDocFinder.INSTANCE.findKDoc(declarationDescriptor)) != null) {
                String renderedComment = KDocRenderer.INSTANCE.renderKDoc(comment);
                renderedDecl2 = StringsKt.startsWith$default((String)renderedComment, (String)"<p>", (boolean)false, (int)2, null) ? renderedDecl2 + renderedComment : renderedDecl2 + "<br/>" + renderedComment;
            }
            return renderedDecl2;
        }

        private final String mixKotlinToJava(DeclarationDescriptor declarationDescriptor, PsiElement element2, PsiElement originalElement) {
            String originalInfo = new JavaDocumentationProvider().getQuickNavigateInfo(element2, originalElement);
            if (originalInfo != null) {
                String renderedDecl2 = ((DescriptorRenderer)AddToStdlibKt.constant(mixKotlinToJava.renderedDecl.1.INSTANCE)).render(declarationDescriptor);
                return renderedDecl2 + "<br/>Java declaration:<br/>" + originalInfo;
            }
            return null;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ DescriptorRenderer access$getDESCRIPTOR_RENDERER$p(Companion $this) {
            return $this.getDESCRIPTOR_RENDERER();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

