/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdConfigurationOptionHelpPanel;
import com.android.tools.idea.avdmanager.AvdEditWizard;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdScaleFactor;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.ChooseDeviceDefinitionStep;
import com.android.tools.idea.avdmanager.ChooseSystemImageStep;
import com.android.tools.idea.avdmanager.DeviceDefinitionList;
import com.android.tools.idea.avdmanager.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.SkinChooser;
import com.android.tools.idea.avdmanager.StorageField;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.avdmanager.SystemImagePreview;
import com.android.tools.idea.wizard.ASGallery;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.DynamicWizardStep;
import com.android.tools.idea.wizard.DynamicWizardStepWithDescription;
import com.android.tools.idea.wizard.RadioButtonGroupBinding;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.SingleStepDialogWrapperHost;
import com.android.tools.idea.wizard.SingleStepWizard;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAvdOptionsStep
extends DynamicWizardStepWithDescription {
    private JBLabel myDeviceName;
    private JBLabel myDeviceDetails;
    private JButton myChangeDeviceButton;
    private JBLabel mySystemImageName;
    private JBLabel mySystemImageDetails;
    private JButton myChangeSystemImageButton;
    private TextFieldWithBrowseButton myExistingSdCard;
    private JComboBox myScalingComboBox;
    private ASGallery<ScreenOrientation> myOrientationToggle;
    private JPanel myRoot;
    private JCheckBox myUseHostGPUCheckBox;
    private JCheckBox myStoreASnapshotForCheckBox;
    private JComboBox myFrontCameraCombo;
    private JComboBox myBackCameraCombo;
    private JComboBox mySpeedCombo;
    private JComboBox myLatencyCombo;
    private JButton myShowAdvancedSettingsButton;
    private StorageField myRamStorage;
    private StorageField myVmHeapStorage;
    private StorageField myInternalStorage;
    private StorageField myNewSdCardStorage;
    private JBLabel myMemoryAndStorageLabel;
    private JBLabel myRamLabel;
    private JBLabel myVmHeapLabel;
    private JBLabel myInternalStorageLabel;
    private JBLabel mySdCardLabel;
    private HyperlinkLabel myHardwareSkinHelpLabel;
    private JTextField myAvdDisplayName;
    private JBLabel mySkinDefinitionLabel;
    private JBLabel myAvdId;
    private JLabel myAvdIdLabel;
    private SkinChooser mySkinComboBox;
    private JPanel myAvdDisplayNamePanel;
    private JBLabel myAvdNameLabel;
    private JCheckBox myEnableComputerKeyboard;
    private JRadioButton myBuiltInRadioButton;
    private JRadioButton myExternalRadioButton;
    private JCheckBox myDeviceFrameCheckbox;
    private JBLabel myDeviceFrameLabel;
    private Iterable<JComponent> myAdvancedOptionsComponents;
    private String myOriginalName;
    private JSeparator myStorageSeparator;
    private JBLabel myCameraLabel;
    private JBLabel myFrontCameraLabel;
    private JBLabel myBackCameraLabel;
    private JSeparator myCameraSeparator;
    private JBLabel myNetworkLabel;
    private JBLabel mySpeedLabel;
    private JBLabel myLatencyLabel;
    private JBLabel myKeyboardLabel;
    private JSeparator myKeyboardSeparator;
    private JSeparator myNetworkSeparator;
    private AvdConfigurationOptionHelpPanel myAvdConfigurationOptionHelpPanel;
    private PropertyChangeListener myFocusListener;
    private static final String ADVANCED_SETTINGS = "Advanced Settings";
    private static final String SHOW = "Show Advanced Settings";
    private static final String HIDE = "Hide Advanced Settings";
    private Set<JComponent> myErrorStateComponents;
    private static final Map<ScreenOrientation, NamedIcon> ORIENTATIONS = ImmutableMap.of((Object)ScreenOrientation.PORTRAIT, (Object)new NamedIcon("Portrait", AndroidIcons.Portrait), (Object)ScreenOrientation.LANDSCAPE, (Object)new NamedIcon("Landscape", AndroidIcons.Landscape));
    private static final ScopedDataBinder.ComponentBinding<Device, JBLabel> DEVICE_NAME_BINDING = new ScopedDataBinder.ComponentBinding<Device, JBLabel>(){

        @Override
        public void setValue(@Nullable Device newValue, @NotNull JBLabel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$18", "setValue"));
            }
            if (newValue != null) {
                component.setText(newValue.getDisplayName());
                Icon icon = DeviceDefinitionPreview.getIcon(newValue);
                component.setIcon(icon);
            }
        }
    };
    private static final ScopedDataBinder.ComponentBinding<Device, JBLabel> DEVICE_DETAILS_BINDING = new ScopedDataBinder.ComponentBinding<Device, JBLabel>(){

        @Override
        public void setValue(@Nullable Device newValue, @NotNull JBLabel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$19", "setValue"));
            }
            if (newValue != null) {
                String description = Joiner.on((char)' ').join((Object)DeviceDefinitionList.getDiagonalSize(newValue), (Object)DeviceDefinitionList.getDimensionString(newValue), new Object[]{DeviceDefinitionList.getDensityString(newValue)});
                component.setText(description);
            }
        }
    };
    private static final ScopedDataBinder.ComponentBinding<SystemImageDescription, JBLabel> SYSTEM_IMAGE_NAME_BINDING = new ScopedDataBinder.ComponentBinding<SystemImageDescription, JBLabel>(){

        @Override
        public void setValue(@Nullable SystemImageDescription newValue, @NotNull JBLabel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$20", "setValue"));
            }
            if (newValue != null) {
                String codeName = SystemImagePreview.getCodeName(newValue);
                component.setText(codeName);
                try {
                    Icon icon = IconLoader.findIcon((String)String.format("/icons/versions/%s_32.png", codeName), AndroidIcons.class);
                    component.setIcon(icon);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    };
    private final ScopedDataBinder.ComponentBinding<SystemImageDescription, JBLabel> SYSTEM_IMAGE_DESCRIPTION_BINDING;
    public static final ScopedDataBinder.ComponentBinding<ScreenOrientation, ASGallery<ScreenOrientation>> ORIENTATION_BINDING = new ScopedDataBinder.ComponentBinding<ScreenOrientation, ASGallery<ScreenOrientation>>(){

        @Override
        @Nullable
        public ScreenOrientation getValue(@NotNull ASGallery<ScreenOrientation> component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$22", "getValue"));
            }
            return component.getSelectedElement();
        }

        @Override
        public void setValue(@Nullable ScreenOrientation newValue, @NotNull ASGallery<ScreenOrientation> component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$22", "setValue"));
            }
            component.setSelectedElement(newValue);
        }
    };
    private static final ScopedDataBinder.ComponentBinding<String, JComboBox> STRING_COMBO_BINDING = new ScopedDataBinder.ComponentBinding<String, JComboBox>(){

        @Override
        public void setValue(@Nullable String newValue, @NotNull JComboBox component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$23", "setValue"));
            }
            if (newValue == null) {
                return;
            }
            for (int i = 0; i < component.getItemCount(); ++i) {
                if (!newValue.equalsIgnoreCase((String)component.getItemAt(i))) continue;
                component.setSelectedIndex(i);
            }
        }

        @Override
        @Nullable
        public String getValue(@NotNull JComboBox component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$23", "getValue"));
            }
            return component.getSelectedItem().toString().toLowerCase();
        }

        @Override
        public void addItemListener(@NotNull ItemListener listener, @NotNull JComboBox component) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$23", "addItemListener"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$23", "addItemListener"));
            }
            component.addItemListener(listener);
        }
    };

    public <T> MyActionListener<T> createListener(DynamicWizardStep step, String description, ScopedStateStore.Key<T> resultKey) {
        return new MyActionListener<T>(step, description, resultKey);
    }

    public ConfigureAvdOptionsStep(@Nullable Disposable parentDisposable) {
        super(parentDisposable);
        this.$$$setupUI$$$();
        this.myErrorStateComponents = Sets.newHashSet();
        this.SYSTEM_IMAGE_DESCRIPTION_BINDING = new ScopedDataBinder.ComponentBinding<SystemImageDescription, JBLabel>(){

            @Override
            public void setValue(@Nullable SystemImageDescription newValue, @NotNull JBLabel component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$21", "setValue"));
                }
                if (newValue != null) {
                    component.setText(newValue.getName() + " " + newValue.getAbiType());
                    ConfigureAvdOptionsStep.this.myAvdConfigurationOptionHelpPanel.setSystemImageDescription(newValue);
                }
            }
        };
        this.setBodyComponent(this.myRoot);
        this.registerAdvancedOptionsVisibility();
        this.toggleAdvancedSettings(false);
        this.myShowAdvancedSettingsButton.setText(SHOW);
        ActionListener toggleAdvancedSettingsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureAvdOptionsStep.this.myShowAdvancedSettingsButton.getText().equals(ConfigureAvdOptionsStep.SHOW)) {
                    ConfigureAvdOptionsStep.this.toggleAdvancedSettings(true);
                    ConfigureAvdOptionsStep.this.myShowAdvancedSettingsButton.setText(ConfigureAvdOptionsStep.HIDE);
                } else {
                    ConfigureAvdOptionsStep.this.toggleAdvancedSettings(false);
                    ConfigureAvdOptionsStep.this.myShowAdvancedSettingsButton.setText(ConfigureAvdOptionsStep.SHOW);
                }
            }
        };
        this.myShowAdvancedSettingsButton.addActionListener(toggleAdvancedSettingsListener);
        this.myChangeDeviceButton.addActionListener(this.createListener(new ChooseDeviceDefinitionStep(parentDisposable), "Select a device", AvdWizardConstants.DEVICE_DEFINITION_KEY));
        this.myChangeSystemImageButton.addActionListener(this.createListener(new ChooseSystemImageStep(this.getProject(), parentDisposable), "Select a system image", AvdWizardConstants.SYSTEM_IMAGE_KEY));
        ActionListener sdActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureAvdOptionsStep.this.updateSdCardSettings();
            }
        };
        this.myExternalRadioButton.addActionListener(sdActionListener);
        this.myBuiltInRadioButton.addActionListener(sdActionListener);
        this.myOrientationToggle.setOpaque(false);
        this.myFocusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JComponent component;
                Container parent;
                Object value = evt.getNewValue();
                if (evt.getNewValue() instanceof JComponent && (parent = (component = (JComponent)value).getParent()) instanceof JComponent) {
                    ((JComponent)parent).scrollRectToVisible(component.getBounds());
                }
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.myFocusListener);
    }

    @Override
    public void dispose() {
        if (this.myFocusListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.myFocusListener);
        }
    }

    private void updateSdCardSettings() {
        boolean useExisting = this.myState.get(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY);
        if (useExisting) {
            this.myExistingSdCard.setEnabled(true);
            this.myNewSdCardStorage.setEnabled(false);
        } else {
            this.myExistingSdCard.setEnabled(false);
            this.myNewSdCardStorage.setEnabled(true);
        }
    }

    @Override
    public void init() {
        super.init();
        this.registerComponents();
        this.deregister(this.getDescriptionLabel());
        this.getDescriptionLabel().setVisible(false);
        Device device = this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        SystemImageDescription systemImage = this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY);
        if (this.myState.get(AvdWizardConstants.DISPLAY_NAME_KEY) == null || this.myState.get(AvdWizardConstants.DISPLAY_NAME_KEY).isEmpty()) {
            assert (device != null && systemImage != null);
            String avdName = String.format(Locale.getDefault(), "%1$s API %2$d", device.getDisplayName(), systemImage.getVersion().getApiLevel());
            avdName = ConfigureAvdOptionsStep.uniquifyDisplayName(avdName);
            this.myState.put(AvdWizardConstants.DISPLAY_NAME_KEY, avdName);
        }
        this.myAvdConfigurationOptionHelpPanel.setSystemImageDescription(systemImage);
        Boolean editMode = this.myState.get(AvdWizardConstants.IS_IN_EDIT_MODE_KEY);
        editMode = editMode == null ? Boolean.FALSE : editMode;
        String string = this.myOriginalName = editMode != false ? this.myState.get(AvdWizardConstants.DISPLAY_NAME_KEY) : "";
        if (device.getDefaultHardware().getKeyboard().equals((Object)Keyboard.QWERTY)) {
            this.myEnableComputerKeyboard.setEnabled(false);
        }
        if (this.myState.get(AvdWizardConstants.DEFAULT_ORIENTATION_KEY) == null) {
            this.myState.put(AvdWizardConstants.DEFAULT_ORIENTATION_KEY, device.getDefaultState().getOrientation());
        }
        this.myAvdId.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigureAvdOptionsStep.this.myAvdId.requestFocusInWindow();
            }
        });
        File customSkin = this.myState.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY);
        File backupSkin = this.myState.get(AvdWizardConstants.BACKUP_SKIN_FILE_KEY);
        this.myState.put(AvdWizardConstants.DEVICE_FRAME_KEY, backupSkin == null || customSkin != null);
        this.myState.put(AvdWizardConstants.DISPLAY_SKIN_FILE_KEY, AvdEditWizard.resolveSkinPath(this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY).getDefaultHardware().getSkinFile(), this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY)));
        if (customSkin == null) {
            customSkin = backupSkin;
        }
        File hardwareSkin = AvdEditWizard.resolveSkinPath(device.getDefaultHardware().getSkinFile(), systemImage);
        if (customSkin != null && !FileUtil.filesEqual((File)customSkin, (File)hardwareSkin)) {
            this.mySkinComboBox.getComboBox().setSelectedItem(customSkin);
        }
    }

    @Override
    public boolean commitStep() {
        if (!this.myState.containsKey(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY) || !this.myState.get(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY).booleanValue()) {
            int result;
            Storage orig = this.myState.get(AvdWizardConstants.SD_CARD_STORAGE_KEY);
            Storage current = this.myState.get(AvdWizardConstants.DISPLAY_SD_SIZE_KEY);
            if (orig != null && !orig.equals((Object)current) && (result = Messages.showYesNoDialog((Project)null, (String)"Changing the size of the built-in SD card will erase the current contents of the card. Continue?", (String)"Confirm Data Wipe", (Icon)AllIcons.General.QuestionDialog)) != 0) {
                return false;
            }
        }
        File displayFile = this.myState.get(AvdWizardConstants.DISPLAY_SKIN_FILE_KEY);
        boolean hasFrame = this.myState.getNotNull(AvdWizardConstants.DEVICE_FRAME_KEY, false);
        this.myState.put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, hasFrame ? displayFile : AvdWizardConstants.NO_SKIN);
        this.myState.put(AvdWizardConstants.BACKUP_SKIN_FILE_KEY, hasFrame ? null : displayFile);
        return super.commitStep();
    }

    private static String uniquifyDisplayName(String name) {
        int suffix = 1;
        String result = name;
        while (ConfigureAvdOptionsStep.findAvdWithName(result)) {
            result = String.format("%1$s %2$d", name, ++suffix);
        }
        return result;
    }

    private static boolean findAvdWithName(String name) {
        for (AvdInfo avd : AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(false)) {
            if (!AvdManagerConnection.getAvdDisplayName(avd).equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        Device device = this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        if (device != null) {
            this.toggleOptionals(device);
        }
        this.updateSdCardSettings();
        if (this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY).getVersion().getApiLevel() <= 15) {
            this.myUseHostGPUCheckBox.setEnabled(false);
            this.myUseHostGPUCheckBox.setText("Use Host GPU (Requires API > 15)");
            this.myUseHostGPUCheckBox.setSelected(false);
        } else {
            this.myUseHostGPUCheckBox.setEnabled(true);
            this.myUseHostGPUCheckBox.setText("Use Host GPU");
        }
    }

    @Override
    public boolean validate() {
        String displayName;
        File layoutFile;
        Boolean useExistingSd;
        Storage internal;
        Storage vmHeap;
        this.clearErrorState();
        boolean valid = true;
        Storage ram = this.myState.get(AvdWizardConstants.RAM_STORAGE_KEY);
        if (ram == null || ram.getSizeAsUnit(Storage.Unit.MiB) < 128L) {
            this.setErrorState("RAM must be a numeric (integer) value of at least 128MB. Recommendation is 1GB.", new JComponent[]{this.myMemoryAndStorageLabel, this.myRamLabel, this.myRamStorage});
            valid = false;
        }
        if ((vmHeap = this.myState.get(AvdWizardConstants.VM_HEAP_STORAGE_KEY)) == null || vmHeap.getSizeAsUnit(Storage.Unit.MiB) < 16L) {
            this.setErrorState("VM Heap must be a numeric (integer) value of at least 16MB.", new JComponent[]{this.myMemoryAndStorageLabel, this.myVmHeapLabel, this.myVmHeapStorage});
            valid = false;
        }
        if ((internal = this.myState.get(AvdWizardConstants.INTERNAL_STORAGE_KEY)) == null || internal.getSizeAsUnit(Storage.Unit.MiB) < 200L) {
            this.setErrorState("Internal storage must be a numeric (integer) value of at least 200MB.", new JComponent[]{this.myMemoryAndStorageLabel, this.myInternalStorageLabel, this.myInternalStorage});
            valid = false;
        }
        if ((useExistingSd = this.myState.get(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY)) != null && useExistingSd.booleanValue()) {
            String path = this.myState.get(AvdWizardConstants.DISPLAY_SD_LOCATION_KEY);
            if (path == null || !new File(path).isFile()) {
                this.setErrorState("The specified SD image file must be a valid image file", new JComponent[]{this.myMemoryAndStorageLabel, this.mySdCardLabel, this.myExistingSdCard});
                valid = false;
            }
        } else {
            Storage sdCard = this.myState.get(AvdWizardConstants.DISPLAY_SD_SIZE_KEY);
            if (sdCard != null && sdCard.getSizeAsUnit(Storage.Unit.MiB) < 10L) {
                this.setErrorState("The SD card must be larger than 10MB", new JComponent[]{this.myMemoryAndStorageLabel, this.mySdCardLabel, this.myNewSdCardStorage});
                valid = false;
            }
        }
        File skinFile = this.myState.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY);
        if (skinFile != null && !skinFile.equals(AvdWizardConstants.NO_SKIN) && !(layoutFile = new File(skinFile, "layout")).isFile()) {
            this.setErrorState("The skin directory does not point to a valid skin.", new JComponent[]{this.myDeviceFrameLabel, this.mySkinComboBox});
            valid = false;
        }
        Boolean gpu = this.myState.get(AvdWizardConstants.USE_HOST_GPU_KEY);
        Boolean snapshot = this.myState.get(AvdWizardConstants.USE_SNAPSHOT_KEY);
        if (gpu != null && snapshot != null && gpu.booleanValue() && snapshot.booleanValue()) {
            this.setErrorState("GPU Emulation and Snapshot cannot by used simultaneously.", this.myUseHostGPUCheckBox, this.myStoreASnapshotForCheckBox);
            valid = false;
        }
        if ((displayName = this.myState.get(AvdWizardConstants.DISPLAY_NAME_KEY)) != null) {
            if (!(displayName = displayName.trim()).equals(this.myOriginalName) && ConfigureAvdOptionsStep.findAvdWithName(displayName)) {
                this.setErrorState(String.format("An AVD with the name \"%1$s\" already exists.", displayName), new JComponent[]{this.myAvdDisplayNamePanel, this.myAvdNameLabel});
                valid = false;
            }
            if (!displayName.matches("^[0-9a-zA-Z-_. ()]+$")) {
                this.setErrorState("The AVD name can only contain the characters a-z A-Z 0-9 . _ - ( )", new JComponent[]{this.myAvdDisplayNamePanel, this.myAvdNameLabel});
                valid = false;
            }
        }
        Device device = this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        SystemImageDescription systemImage = this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY);
        if (!ChooseSystemImageStep.systemImageMatchesDevice(systemImage, device)) {
            this.setErrorState("The selected system image is incompatible with the selected device.", new JComponent[]{this.mySystemImageDetails});
            valid = false;
        }
        return valid;
    }

    private void clearErrorState() {
        for (JComponent c : this.myErrorStateComponents) {
            if (c instanceof JLabel) {
                c.setForeground(JBColor.foreground());
                ((JLabel)c).setIcon(null);
                continue;
            }
            if (c instanceof StorageField) {
                ((StorageField)c).setError(false);
                continue;
            }
            if (c instanceof JCheckBox) {
                c.setForeground(JBColor.foreground());
                continue;
            }
            c.setBorder(null);
        }
        this.myAvdConfigurationOptionHelpPanel.setErrorMessage("");
        this.setErrorHtml(null);
    }

    private void setErrorState(String message, JComponent ... errorComponents) {
        boolean isVisible = false;
        for (JComponent c : errorComponents) {
            if (!c.isShowing()) continue;
            isVisible = true;
            break;
        }
        if (!isVisible) {
            this.setErrorHtml(message);
        } else {
            this.myAvdConfigurationOptionHelpPanel.setErrorMessage(message);
            for (JComponent c : errorComponents) {
                if (c instanceof JLabel) {
                    c.setForeground((Color)JBColor.RED);
                    ((JLabel)c).setIcon(AllIcons.General.BalloonError);
                } else if (c instanceof StorageField) {
                    ((StorageField)c).setError(true);
                } else if (c instanceof JCheckBox) {
                    c.setForeground((Color)JBColor.RED);
                } else {
                    c.setBorder(new LineBorder((Color)JBColor.RED));
                }
                this.myErrorStateComponents.add(c);
            }
        }
    }

    private void registerComponents() {
        this.register(AvdWizardConstants.DISPLAY_NAME_KEY, this.myAvdDisplayName);
        this.register(AvdWizardConstants.AVD_ID_KEY, (JLabel)this.myAvdId);
        this.registerValueDeriver(AvdWizardConstants.AVD_ID_KEY, new ScopedDataBinder.ValueDeriver<String>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 5.makeSetOf(AvdWizardConstants.DISPLAY_NAME_KEY);
            }

            @Override
            @Nullable
            public String deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable String currentValue) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$5", "deriveValue"));
                }
                String displayName = state.get(AvdWizardConstants.DISPLAY_NAME_KEY);
                if (displayName != null) {
                    return AvdEditWizard.cleanAvdName(AvdManagerConnection.getDefaultAvdManagerConnection(), displayName, !displayName.equals(ConfigureAvdOptionsStep.this.myOriginalName));
                }
                return "";
            }
        });
        this.setControlDescription(this.myAvdDisplayName, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.DISPLAY_NAME_KEY));
        this.setControlDescription((Component)this.myAvdId, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.AVD_ID_KEY));
        this.register(AvdWizardConstants.DEVICE_DEFINITION_KEY, this.myDeviceName, DEVICE_NAME_BINDING);
        this.register(AvdWizardConstants.DEVICE_DEFINITION_KEY, this.myDeviceDetails, DEVICE_DETAILS_BINDING);
        this.register(AvdWizardConstants.SYSTEM_IMAGE_KEY, this.mySystemImageName, SYSTEM_IMAGE_NAME_BINDING);
        this.register(AvdWizardConstants.SYSTEM_IMAGE_KEY, this.mySystemImageDetails, this.SYSTEM_IMAGE_DESCRIPTION_BINDING);
        this.register(AvdWizardConstants.RAM_STORAGE_KEY, this.myRamStorage, this.myRamStorage.getBinding());
        this.setControlDescription(this.myRamStorage, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.RAM_STORAGE_KEY));
        this.register(AvdWizardConstants.VM_HEAP_STORAGE_KEY, this.myVmHeapStorage, this.myVmHeapStorage.getBinding());
        this.setControlDescription(this.myVmHeapStorage, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.VM_HEAP_STORAGE_KEY));
        this.register(AvdWizardConstants.INTERNAL_STORAGE_KEY, this.myInternalStorage, this.myInternalStorage.getBinding());
        this.setControlDescription(this.myInternalStorage, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.INTERNAL_STORAGE_KEY));
        this.register(AvdWizardConstants.DISPLAY_SD_SIZE_KEY, this.myNewSdCardStorage, this.myNewSdCardStorage.getBinding());
        this.setControlDescription(this.myNewSdCardStorage, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.SD_CARD_STORAGE_KEY));
        this.register(AvdWizardConstants.USE_SNAPSHOT_KEY, this.myStoreASnapshotForCheckBox);
        this.setControlDescription(this.myStoreASnapshotForCheckBox, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.USE_SNAPSHOT_KEY));
        this.register(AvdWizardConstants.USE_HOST_GPU_KEY, this.myUseHostGPUCheckBox);
        this.setControlDescription(this.myUseHostGPUCheckBox, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.USE_HOST_GPU_KEY));
        if (Boolean.FALSE.equals(this.myState.get(AvdWizardConstants.IS_IN_EDIT_MODE_KEY))) {
            this.registerValueDeriver(AvdWizardConstants.RAM_STORAGE_KEY, new MemoryValueDeriver(){

                @Override
                @Nullable
                protected Storage getStorage(@NotNull Device device) {
                    if (device == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$6", "getStorage"));
                    }
                    return AvdWizardConstants.getDefaultRam(device.getDefaultHardware());
                }
            });
            this.registerValueDeriver(AvdWizardConstants.VM_HEAP_STORAGE_KEY, new MemoryValueDeriver(){

                @Override
                @Nullable
                protected Storage getStorage(@NotNull Device device) {
                    if (device == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$7", "getStorage"));
                    }
                    return ConfigureAvdOptionsStep.calculateVmHeap(device);
                }
            });
            this.registerValueDeriver(AvdWizardConstants.DISPLAY_NAME_KEY, new ScopedDataBinder.ValueDeriver<String>(){

                @Override
                @Nullable
                public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                    return 8.makeSetOf(AvdWizardConstants.DEVICE_DEFINITION_KEY, AvdWizardConstants.SYSTEM_IMAGE_KEY);
                }

                @Override
                @Nullable
                public String deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable String currentValue) {
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$8", "deriveValue"));
                    }
                    Device device = state.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
                    SystemImageDescription systemImage = state.get(AvdWizardConstants.SYSTEM_IMAGE_KEY);
                    if (device != null && systemImage != null) {
                        return ConfigureAvdOptionsStep.uniquifyDisplayName(String.format(Locale.getDefault(), "%1$s API %2$d", device.getDisplayName(), systemImage.getVersion().getApiLevel()));
                    }
                    return null;
                }
            });
        }
        this.registerValueDeriver(AvdWizardConstants.DISPLAY_SKIN_FILE_KEY, new ScopedDataBinder.ValueDeriver<File>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 9.makeSetOf(AvdWizardConstants.DEVICE_DEFINITION_KEY, AvdWizardConstants.SYSTEM_IMAGE_KEY);
            }

            @Override
            @Nullable
            public File deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable File currentValue) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$9", "deriveValue"));
                }
                return AvdEditWizard.resolveSkinPath(ConfigureAvdOptionsStep.this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY).getDefaultHardware().getSkinFile(), ConfigureAvdOptionsStep.this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY));
            }
        });
        this.registerValueDeriver(AvdWizardConstants.USE_HOST_GPU_KEY, new ScopedDataBinder.ValueDeriver<Boolean>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 10.makeSetOf(AvdWizardConstants.DEVICE_DEFINITION_KEY);
            }

            @Override
            @Nullable
            public Boolean deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable Boolean currentValue) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$10", "deriveValue"));
                }
                Device device = ConfigureAvdOptionsStep.this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
                if (device != null && device.isScreenRound()) {
                    return false;
                }
                return ConfigureAvdOptionsStep.this.myState.get(AvdWizardConstants.USE_HOST_GPU_KEY);
            }
        });
        this.registerValueDeriver(AvdWizardConstants.DEVICE_FRAME_KEY, new ScopedDataBinder.ValueDeriver<Boolean>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 11.makeSetOf(AvdWizardConstants.DISPLAY_SKIN_FILE_KEY);
            }

            @Override
            public boolean respectUserEdits() {
                return false;
            }

            @Override
            @Nullable
            public Boolean deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable Boolean currentValue) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$11", "deriveValue"));
                }
                File displaySkinPath = ConfigureAvdOptionsStep.this.myState.get(AvdWizardConstants.DISPLAY_SKIN_FILE_KEY);
                boolean hasSkin = displaySkinPath != null && !FileUtil.filesEqual((File)AvdWizardConstants.NO_SKIN, (File)displaySkinPath);
                ConfigureAvdOptionsStep.this.myDeviceFrameCheckbox.setEnabled(hasSkin);
                return hasSkin && ConfigureAvdOptionsStep.this.myState.getNotNull(AvdWizardConstants.DEVICE_FRAME_KEY, false) != false;
            }
        });
        this.register(AvdWizardConstants.DEFAULT_ORIENTATION_KEY, this.myOrientationToggle, ORIENTATION_BINDING);
        this.setControlDescription(this.myOrientationToggle, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.DEFAULT_ORIENTATION_KEY));
        this.myOrientationToggle.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConfigureAvdOptionsStep.this.saveState(ConfigureAvdOptionsStep.this.myOrientationToggle);
            }
        });
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, true);
            }
        };
        fileChooserDescriptor.setHideIgnored(false);
        this.myExistingSdCard.addBrowseFolderListener("Select SD Card", "Select an existing SD card image", this.getProject(), fileChooserDescriptor);
        this.register(AvdWizardConstants.DISPLAY_SD_LOCATION_KEY, this.myExistingSdCard);
        this.setControlDescription((Component)this.myExistingSdCard, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.EXISTING_SD_LOCATION));
        this.register(AvdWizardConstants.FRONT_CAMERA_KEY, this.myFrontCameraCombo, STRING_COMBO_BINDING);
        this.setControlDescription(this.myFrontCameraCombo, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.FRONT_CAMERA_KEY));
        this.register(AvdWizardConstants.BACK_CAMERA_KEY, this.myBackCameraCombo, STRING_COMBO_BINDING);
        this.setControlDescription(this.myBackCameraCombo, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.BACK_CAMERA_KEY));
        this.register(AvdWizardConstants.SCALE_SELECTION_KEY, this.myScalingComboBox, new ScopedDataBinder.ComponentBinding<AvdScaleFactor, JComboBox>(){

            @Override
            public void addActionListener(@NotNull ActionListener listener, @NotNull JComboBox component) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$14", "addActionListener"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$14", "addActionListener"));
                }
                component.addActionListener(listener);
            }

            @Override
            @Nullable
            public AvdScaleFactor getValue(@NotNull JComboBox component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$14", "getValue"));
                }
                return (AvdScaleFactor)((Object)component.getSelectedItem());
            }

            @Override
            public void setValue(@Nullable AvdScaleFactor newValue, @NotNull JComboBox component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$14", "setValue"));
                }
                if (newValue != null) {
                    component.setSelectedItem((Object)newValue);
                }
            }
        });
        this.setControlDescription(this.myScalingComboBox, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.SCALE_SELECTION_KEY));
        this.register(AvdWizardConstants.NETWORK_LATENCY_KEY, this.myLatencyCombo, STRING_COMBO_BINDING);
        this.setControlDescription(this.myLatencyCombo, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.NETWORK_LATENCY_KEY));
        this.register(AvdWizardConstants.NETWORK_SPEED_KEY, this.mySpeedCombo, STRING_COMBO_BINDING);
        this.setControlDescription(this.mySpeedCombo, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.NETWORK_SPEED_KEY));
        this.register(KEY_DESCRIPTION, this.myAvdConfigurationOptionHelpPanel, new ScopedDataBinder.ComponentBinding<String, AvdConfigurationOptionHelpPanel>(){

            @Override
            public void setValue(@Nullable String newValue, @NotNull AvdConfigurationOptionHelpPanel component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$15", "setValue"));
                }
                component.setDescriptionText(newValue);
            }
        });
        this.register(AvdWizardConstants.DISPLAY_SKIN_FILE_KEY, this.mySkinComboBox, this.mySkinComboBox.getBinding());
        this.setControlDescription((Component)((Object)this.mySkinComboBox), this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY));
        this.register(AvdWizardConstants.DEVICE_FRAME_KEY, this.myDeviceFrameCheckbox);
        this.setControlDescription(this.myDeviceFrameCheckbox, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.DEVICE_FRAME_KEY));
        if (!this.myState.containsKey(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY)) {
            this.myState.put(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY, true);
        }
        this.register(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY, this.myEnableComputerKeyboard);
        this.setControlDescription(this.myEnableComputerKeyboard, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY));
        RadioButtonGroupBinding sdCardBinding = new RadioButtonGroupBinding(ImmutableMap.of((Object)this.myExternalRadioButton, (Object)true, (Object)this.myBuiltInRadioButton, (Object)false));
        this.register(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY, this.myExternalRadioButton, sdCardBinding);
        this.setControlDescription(this.myExternalRadioButton, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.EXISTING_SD_LOCATION));
        this.register(AvdWizardConstants.DISPLAY_USE_EXTERNAL_SD_KEY, this.myBuiltInRadioButton, sdCardBinding);
        this.setControlDescription(this.myBuiltInRadioButton, this.myAvdConfigurationOptionHelpPanel.getDescription(AvdWizardConstants.SD_CARD_STORAGE_KEY));
        this.invokeUpdate(null);
    }

    private void createUIComponents() {
        this.myOrientationToggle = new ASGallery<ScreenOrientation>(JBList.createDefaultListModel((Object[])new Object[]{ScreenOrientation.PORTRAIT, ScreenOrientation.LANDSCAPE}), new Function<ScreenOrientation, Image>(){

            public Image apply(ScreenOrientation input) {
                return IconUtil.toImage((Icon)((NamedIcon)ORIENTATIONS.get(input)).myIcon);
            }
        }, new Function<ScreenOrientation, String>(){

            public String apply(ScreenOrientation input) {
                return ((NamedIcon)ORIENTATIONS.get(input)).myName;
            }
        }, new Dimension(50, 50));
        this.myOrientationToggle.setCellMargin(new Insets(3, 5, 3, 5));
        this.myOrientationToggle.setBackground(JBColor.background());
        this.myOrientationToggle.setForeground(JBColor.foreground());
        this.myScalingComboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(AvdScaleFactor.class));
        this.myHardwareSkinHelpLabel = new HyperlinkLabel("How do I create a custom hardware skin?");
        this.myHardwareSkinHelpLabel.setHyperlinkTarget("http://developer.android.com/tools/devices/managing-avds.html#skins");
        this.mySkinComboBox = new SkinChooser(this.getProject());
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Configure AVD Options" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "getStepName"));
        }
        return "Configure AVD Options";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        if ("Android Virtual Device (AVD)" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "getStepTitle"));
        }
        return "Android Virtual Device (AVD)";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return "Verify Configuration";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myAvdDisplayName;
    }

    private void registerAdvancedOptionsVisibility() {
        this.myAdvancedOptionsComponents = Iterables.concat((Iterable[])new Iterable[]{this.getMemoryAndStorageComponents(), this.getCameraComponents(), this.getNetworkComponents(), this.getSkinComponents(), this.getKeyboardComponents(), this.getAvdNameComponents()});
    }

    private List<JComponent> getAvdNameComponents() {
        return ImmutableList.of((Object)this.myAvdIdLabel, (Object)this.myAvdId);
    }

    private List<JComponent> getKeyboardComponents() {
        return ImmutableList.of((Object)this.myEnableComputerKeyboard, (Object)this.myKeyboardSeparator, (Object)this.myKeyboardLabel);
    }

    private List<JComponent> getSkinComponents() {
        return ImmutableList.of((Object)this.mySkinComboBox, (Object)this.mySkinDefinitionLabel, (Object)this.myHardwareSkinHelpLabel);
    }

    private List<JComponent> getMemoryAndStorageComponents() {
        return ImmutableList.of((Object)this.myMemoryAndStorageLabel, (Object)this.myRamLabel, (Object)this.myVmHeapLabel, (Object)this.myInternalStorageLabel, (Object)this.mySdCardLabel, (Object)this.myRamStorage, (Object)this.myVmHeapStorage, (Object)this.myInternalStorage, (Object)this.myExistingSdCard, (Object)this.myExternalRadioButton, (Object)this.myNewSdCardStorage, (Object)this.myBuiltInRadioButton, (Object[])new JComponent[]{this.myStorageSeparator});
    }

    private List<JComponent> getCameraComponents() {
        return ImmutableList.of((Object)this.myCameraLabel, (Object)this.myCameraSeparator, (Object)this.myBackCameraLabel, (Object)this.myFrontCameraLabel, (Object)this.myBackCameraCombo, (Object)this.myFrontCameraCombo);
    }

    private List<JComponent> getNetworkComponents() {
        return ImmutableList.of((Object)this.myNetworkLabel, (Object)this.mySpeedLabel, (Object)this.mySpeedCombo, (Object)this.myLatencyCombo, (Object)this.myLatencyLabel, (Object)this.myNetworkSeparator);
    }

    private void toggleAdvancedSettings(boolean show) {
        for (JComponent c : this.myAdvancedOptionsComponents) {
            c.setVisible(show);
        }
        this.validate();
        this.myRoot.validate();
    }

    private void toggleOptionals(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "toggleOptionals"));
        }
        this.myFrontCameraCombo.setEnabled(device.getDefaultHardware().getCamera(CameraLocation.FRONT) != null);
        this.myBackCameraCombo.setEnabled(device.getDefaultHardware().getCamera(CameraLocation.BACK) != null);
        this.myOrientationToggle.setEnabled(device.getDefaultState().getOrientation() != ScreenOrientation.SQUARE);
    }

    public static Storage calculateVmHeap(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep", "calculateVmHeap"));
        }
        Screen s = device.getDefaultHardware().getScreen();
        ScreenSize size = s.getSize();
        Density density = s.getPixelDensity();
        int vmHeapSize = 32;
        if (size.equals((Object)ScreenSize.XLARGE)) {
            switch (density) {
                case LOW: 
                case MEDIUM: {
                    vmHeapSize = 32;
                    break;
                }
                case TV: 
                case HIGH: 
                case DPI_280: {
                    vmHeapSize = 64;
                    break;
                }
                case XHIGH: 
                case DPI_400: 
                case XXHIGH: 
                case DPI_560: 
                case XXXHIGH: {
                    vmHeapSize = 128;
                    break;
                }
            }
        } else {
            switch (density) {
                case LOW: 
                case MEDIUM: {
                    vmHeapSize = 16;
                    break;
                }
                case TV: 
                case HIGH: 
                case DPI_280: {
                    vmHeapSize = 32;
                    break;
                }
                case XHIGH: 
                case DPI_400: 
                case XXHIGH: 
                case DPI_560: 
                case XXXHIGH: {
                    vmHeapSize = 64;
                    break;
                }
            }
        }
        return new Storage((long)vmHeapSize, Storage.Unit.MiB);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        AvdConfigurationOptionHelpPanel avdConfigurationOptionHelpPanel;
        JButton jButton;
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JButton jButton2;
        JButton jButton3;
        JTextField jTextField;
        JPanel jPanel;
        JBLabel jBLabel2;
        JSeparator jSeparator;
        JCheckBox jCheckBox2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton;
        StorageField storageField;
        JRadioButton jRadioButton2;
        StorageField storageField2;
        StorageField storageField3;
        StorageField storageField4;
        JSeparator jSeparator2;
        JBLabel jBLabel5;
        JBLabel jBLabel6;
        JBLabel jBLabel7;
        JBLabel jBLabel8;
        JBLabel jBLabel9;
        JBLabel jBLabel10;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JBLabel jBLabel11;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JBLabel jBLabel12;
        JBLabel jBLabel13;
        JSeparator jSeparator3;
        JBLabel jBLabel14;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JBLabel jBLabel15;
        JBLabel jBLabel16;
        JSeparator jSeparator4;
        JBLabel jBLabel17;
        JBLabel jBLabel18;
        JBLabel jBLabel19;
        JBLabel jBLabel20;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRoot = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 2, 1, 0, 3, 7, 3, null, null, new Dimension(720, -1)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(33, 4, new Insets(3, 3, 3, 10), -1, 5, false, false));
        jBScrollPane.setViewportView(jPanel3);
        this.myDeviceName = jBLabel20 = new JBLabel();
        jPanel3.add((Component)jBLabel20, new GridConstraints(3, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myDeviceDetails = jBLabel19 = new JBLabel();
        jBLabel19.setText("No Hardware Profile Selected");
        jPanel3.add((Component)jBLabel19, new GridConstraints(3, 1, 1, 2, 8, 0, 2, 0, null, null, null));
        this.mySystemImageName = jBLabel18 = new JBLabel();
        jPanel3.add((Component)jBLabel18, new GridConstraints(5, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        this.mySystemImageDetails = jBLabel17 = new JBLabel();
        jBLabel17.setText("No System Image Selected");
        jPanel3.add((Component)jBLabel17, new GridConstraints(5, 1, 1, 2, 8, 0, 2, 0, null, null, null));
        JSeparator jSeparator5 = new JSeparator();
        jPanel3.add((Component)jSeparator5, new GridConstraints(4, 0, 1, 4, 1, 1, 3, 1, null, null, null));
        JSeparator jSeparator6 = new JSeparator();
        jPanel3.add((Component)jSeparator6, new GridConstraints(6, 0, 1, 4, 1, 1, 3, 1, null, null, null));
        JBLabel jBLabel21 = new JBLabel();
        jBLabel21.setEnabled(true);
        jBLabel21.setText("<html>Startup size<br>and<br>orientation</html>");
        jBLabel21.setHorizontalTextPosition(10);
        jPanel3.add((Component)jBLabel21, new GridConstraints(7, 0, 1, 1, 9, 0, 0, 0, null, new Dimension(100, -1), null));
        JComboBox jComboBox5 = this.myScalingComboBox;
        jPanel3.add((Component)jComboBox5, new GridConstraints(7, 2, 1, 2, 8, 0, 2, 0, null, null, null));
        ASGallery<ScreenOrientation> aSGallery = this.myOrientationToggle;
        jPanel3.add(aSGallery, new GridConstraints(8, 2, 1, 2, 9, 0, 3, 3, null, new Dimension(200, 50), null));
        JBLabel jBLabel22 = new JBLabel();
        jBLabel22.setText("Scale:");
        jPanel3.add((Component)jBLabel22, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel23 = new JBLabel();
        jBLabel23.setText("Orientation:");
        jPanel3.add((Component)jBLabel23, new GridConstraints(8, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCameraSeparator = jSeparator4 = new JSeparator();
        jPanel3.add((Component)jSeparator4, new GridConstraints(9, 0, 1, 4, 1, 1, 3, 1, null, null, null));
        this.myCameraLabel = jBLabel16 = new JBLabel();
        jBLabel16.setEnabled(true);
        jBLabel16.setText("Camera");
        jBLabel16.setHorizontalTextPosition(10);
        jPanel3.add((Component)jBLabel16, new GridConstraints(10, 0, 2, 1, 9, 0, 0, 0, null, new Dimension(100, -1), null));
        this.myBackCameraLabel = jBLabel15 = new JBLabel();
        jBLabel15.setText("Back:");
        jPanel3.add((Component)jBLabel15, new GridConstraints(11, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(82, 15), null));
        this.myFrontCameraCombo = jComboBox4 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("None");
        defaultComboBoxModel.addElement("Emulated");
        defaultComboBoxModel.addElement("Webcam0");
        jComboBox4.setModel(defaultComboBoxModel);
        jPanel3.add(jComboBox4, new GridConstraints(10, 2, 1, 2, 8, 0, 6, 0, null, null, null));
        this.myBackCameraCombo = jComboBox3 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("None");
        defaultComboBoxModel2.addElement("Emulated");
        defaultComboBoxModel2.addElement("Webcam0");
        jComboBox3.setModel(defaultComboBoxModel2);
        jPanel3.add(jComboBox3, new GridConstraints(11, 2, 1, 2, 8, 0, 6, 0, null, null, null));
        this.myFrontCameraLabel = jBLabel14 = new JBLabel();
        jBLabel14.setText("Front:");
        jPanel3.add((Component)jBLabel14, new GridConstraints(10, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(82, 15), null));
        this.myNetworkSeparator = jSeparator3 = new JSeparator();
        jPanel3.add((Component)jSeparator3, new GridConstraints(12, 0, 1, 4, 1, 1, 3, 1, null, null, null));
        this.mySpeedLabel = jBLabel13 = new JBLabel();
        jBLabel13.setText("Speed:");
        jPanel3.add((Component)jBLabel13, new GridConstraints(13, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(82, 15), null));
        this.myLatencyLabel = jBLabel12 = new JBLabel();
        jBLabel12.setText("Latency:");
        jPanel3.add((Component)jBLabel12, new GridConstraints(14, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(82, 15), null));
        this.mySpeedCombo = jComboBox2 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel3.addElement("Full");
        defaultComboBoxModel3.addElement("HSDPA");
        defaultComboBoxModel3.addElement("UMTS");
        defaultComboBoxModel3.addElement("EDGE");
        defaultComboBoxModel3.addElement("GPRS");
        defaultComboBoxModel3.addElement("HSCSD");
        defaultComboBoxModel3.addElement("GSM");
        jComboBox2.setModel(defaultComboBoxModel3);
        jPanel3.add(jComboBox2, new GridConstraints(13, 2, 1, 2, 8, 0, 6, 0, null, null, null));
        this.myLatencyCombo = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel4 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel4.addElement("None");
        defaultComboBoxModel4.addElement("UMTS");
        defaultComboBoxModel4.addElement("EDGE");
        defaultComboBoxModel4.addElement("GPRS");
        jComboBox.setModel(defaultComboBoxModel4);
        jPanel3.add(jComboBox, new GridConstraints(14, 2, 1, 2, 8, 0, 6, 0, null, null, null));
        this.myNetworkLabel = jBLabel11 = new JBLabel();
        jBLabel11.setEnabled(true);
        jBLabel11.setText("Network");
        jBLabel11.setHorizontalTextPosition(10);
        jPanel3.add((Component)jBLabel11, new GridConstraints(13, 0, 2, 1, 9, 0, 0, 0, null, new Dimension(100, -1), null));
        JBLabel jBLabel24 = new JBLabel();
        jBLabel24.setEnabled(true);
        jBLabel24.setText("<html>Emulated<br>Performance</html>");
        jBLabel24.setHorizontalTextPosition(10);
        jPanel3.add((Component)jBLabel24, new GridConstraints(16, 0, 3, 1, 9, 0, 3, 0, null, new Dimension(100, -1), null));
        this.myUseHostGPUCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Use Host GPU");
        jPanel3.add((Component)jCheckBox4, new GridConstraints(16, 2, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myStoreASnapshotForCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Store a snapshot for faster startup");
        jPanel3.add((Component)jCheckBox3, new GridConstraints(17, 2, 1, 2, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel25 = new JBLabel();
        jBLabel25.setEnabled(false);
        jBLabel25.setText("You can either use Host GPU or Snapshots");
        jPanel3.add((Component)jBLabel25, new GridConstraints(18, 2, 1, 2, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel26 = new JBLabel();
        this.myAvdIdLabel = jBLabel26;
        jBLabel26.setText("AVD Id");
        jPanel3.add((Component)jBLabel26, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAvdId = jBLabel10 = new JBLabel();
        jPanel3.add((Component)jBLabel10, new GridConstraints(1, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JSeparator jSeparator7 = new JSeparator();
        jPanel3.add((Component)jSeparator7, new GridConstraints(2, 0, 1, 4, 1, 1, 3, 1, null, null, null));
        this.myMemoryAndStorageLabel = jBLabel9 = new JBLabel();
        jBLabel9.setEnabled(true);
        jBLabel9.setText("<html>Memory<br>and<br>Storage</html>");
        jBLabel9.setHorizontalTextPosition(10);
        jPanel3.add((Component)jBLabel9, new GridConstraints(20, 0, 5, 1, 9, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myRamLabel = jBLabel8 = new JBLabel();
        jBLabel8.setText("RAM:");
        jPanel3.add((Component)jBLabel8, new GridConstraints(20, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myVmHeapLabel = jBLabel7 = new JBLabel();
        jBLabel7.setText("VM heap:");
        jPanel3.add((Component)jBLabel7, new GridConstraints(21, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInternalStorageLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Internal Storage:");
        jPanel3.add((Component)jBLabel6, new GridConstraints(22, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySdCardLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("SD card:");
        jPanel3.add((Component)jBLabel5, new GridConstraints(23, 1, 2, 1, 9, 0, 3, 0, null, null, null));
        this.myStorageSeparator = jSeparator2 = new JSeparator();
        jPanel3.add((Component)jSeparator2, new GridConstraints(19, 0, 1, 4, 1, 1, 3, 1, null, null, null));
        this.myRamStorage = storageField4 = new StorageField();
        jPanel3.add((Component)storageField4, new GridConstraints(20, 2, 1, 2, 8, 0, 3, 3, null, new Dimension(200, -1), null));
        this.myVmHeapStorage = storageField3 = new StorageField();
        jPanel3.add((Component)storageField3, new GridConstraints(21, 2, 1, 2, 8, 0, 3, 3, null, new Dimension(200, -1), null));
        this.myInternalStorage = storageField2 = new StorageField();
        jPanel3.add((Component)storageField2, new GridConstraints(22, 2, 1, 2, 8, 0, 3, 3, null, new Dimension(200, -1), null));
        this.myBuiltInRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Studio-managed");
        jPanel3.add((Component)jRadioButton2, new GridConstraints(23, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNewSdCardStorage = storageField = new StorageField();
        jPanel3.add((Component)storageField, new GridConstraints(23, 3, 1, 1, 9, 0, 7, 0, null, new Dimension(200, -1), null));
        this.myExternalRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("External file");
        jPanel3.add((Component)jRadioButton, new GridConstraints(24, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExistingSdCard = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setVisible(true);
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(24, 3, 1, 1, 8, 0, 7, 3, null, null, null));
        JSeparator jSeparator8 = new JSeparator();
        jPanel3.add((Component)jSeparator8, new GridConstraints(25, 0, 1, 4, 1, 1, 3, 1, null, null, null));
        this.myDeviceFrameLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Device Frame");
        jPanel3.add((Component)jBLabel4, new GridConstraints(26, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyboardLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Keyboard");
        jPanel3.add((Component)jBLabel3, new GridConstraints(30, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnableComputerKeyboard = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Enable keyboard input");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(30, 1, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myKeyboardSeparator = jSeparator = new JSeparator();
        jPanel3.add((Component)jSeparator, new GridConstraints(29, 0, 1, 4, 1, 1, 3, 1, null, null, null));
        this.myAvdNameLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("AVD Name");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAvdDisplayNamePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 1, 1, 3, 0, 1, 3, 3, null, null, null));
        this.myAvdDisplayName = jTextField = new JTextField();
        jTextField.setText("");
        jPanel.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(31, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myChangeDeviceButton = jButton3 = new JButton();
        jButton3.setText("Change...");
        jPanel3.add((Component)jButton3, new GridConstraints(3, 3, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myChangeSystemImageButton = jButton2 = new JButton();
        jButton2.setText("Change...");
        jPanel3.add((Component)jButton2, new GridConstraints(5, 3, 1, 1, 4, 0, 3, 0, null, null, null));
        JSeparator jSeparator9 = new JSeparator();
        jPanel3.add((Component)jSeparator9, new GridConstraints(15, 0, 1, 4, 1, 1, 3, 1, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myHardwareSkinHelpLabel;
        hyperlinkLabel.setVisible(true);
        jPanel3.add((Component)hyperlinkLabel, new GridConstraints(28, 1, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myDeviceFrameCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable Device Frame");
        jPanel3.add((Component)jCheckBox, new GridConstraints(26, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        SkinChooser skinChooser = this.mySkinComboBox;
        ((Component)((Object)skinChooser)).setVisible(true);
        jPanel3.add((Component)((Object)skinChooser), new GridConstraints(27, 2, 1, 2, 8, 0, 3, 3, null, null, null));
        this.mySkinDefinitionLabel = jBLabel = new JBLabel();
        jBLabel.setText("<html>Custom<br>skin definition</html>");
        jPanel3.add((Component)jBLabel, new GridConstraints(27, 1, 1, 1, 9, 0, 3, 0, null, new Dimension(100, -1), null));
        this.myShowAdvancedSettingsButton = jButton = new JButton();
        jButton.setText("");
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myAvdConfigurationOptionHelpPanel = avdConfigurationOptionHelpPanel = new AvdConfigurationOptionHelpPanel();
        JComponent jComponent = avdConfigurationOptionHelpPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 1, 2, 1, 0, 2, 3, 3, null, new Dimension(360, -1), null));
        jBLabel22.setLabelFor(jComboBox5);
        jBLabel15.setLabelFor(jComboBox3);
        jBLabel14.setLabelFor(jComboBox4);
        jBLabel13.setLabelFor(jComboBox2);
        jBLabel12.setLabelFor(jComboBox);
        jBLabel26.setLabelFor(jTextField);
        jBLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static abstract class MemoryValueDeriver
    extends ScopedDataBinder.ValueDeriver<Storage> {
        private MemoryValueDeriver() {
        }

        @Override
        @Nullable
        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            return MemoryValueDeriver.makeSetOf(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        }

        @Override
        @Nullable
        public Storage deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable Storage currentValue) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$MemoryValueDeriver", "deriveValue"));
            }
            Device device = state.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
            if (device != null) {
                return this.getStorage(device);
            }
            return null;
        }

        @Nullable
        protected abstract Storage getStorage(@NotNull Device var1);
    }

    private static final class NamedIcon {
        @NotNull
        private final String myName;
        @NotNull
        private final Icon myIcon;

        public NamedIcon(@NotNull String name, @NotNull Icon icon) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$NamedIcon", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$NamedIcon", "<init>"));
            }
            this.myName = name;
            this.myIcon = icon;
        }
    }

    private class MyActionListener<T>
    implements ActionListener {
        DynamicWizardStep myStep;
        String myDescription;
        ScopedStateStore.Key<T> myResultKey;

        public MyActionListener(DynamicWizardStep step, String description, ScopedStateStore.Key<T> resultKey) {
            this.myStep = step;
            this.myDescription = description;
            this.myResultKey = resultKey;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SingleStepWizard wizard = new SingleStepWizard(ConfigureAvdOptionsStep.this.getProject(), ConfigureAvdOptionsStep.this.getModule(), this.myStep, new SingleStepDialogWrapperHost(ConfigureAvdOptionsStep.this.getProject())){

                @Override
                @NotNull
                protected String getProgressTitle() {
                    if ("Updating AVD..." == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureAvdOptionsStep$MyActionListener$1", "getProgressTitle"));
                    }
                    return "Updating AVD...";
                }

                @Override
                protected String getWizardActionDescription() {
                    return MyActionListener.this.myDescription;
                }
            };
            ScopedStateStore subState = wizard.getState();
            subState.putAllInWizardScope(ConfigureAvdOptionsStep.this.myState);
            subState.put(AvdWizardConstants.IS_IN_EDIT_MODE_KEY, false);
            ((DynamicWizard)wizard).init();
            if (wizard.showAndGet()) {
                ConfigureAvdOptionsStep.this.myState.put(this.myResultKey, subState.get(this.myResultKey));
            }
        }
    }
}

