/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.chartlib.EventData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractClientToggleAction;
import icons.AndroidIcons;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ToggleAllocationTrackingAction
extends AbstractClientToggleAction {
    private final EventData myEvents;
    private EventData.Event myEvent;

    public ToggleAllocationTrackingAction(@NotNull DeviceContext context, @NotNull EventData events) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "<init>"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "<init>"));
        }
        super(context, AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]), null, AndroidIcons.Ddms.AllocationTracker);
        this.myEvents = events;
    }

    @Override
    protected boolean isSelected(@NotNull Client c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "isSelected"));
        }
        return c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON;
    }

    @Override
    protected void setSelected(@NotNull Client c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "setSelected"));
        }
        long now = System.currentTimeMillis();
        if (c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON) {
            c.requestAllocationDetails();
            c.enableAllocationTracker(false);
            if (this.myEvent == null) {
                this.myEvent = this.myEvents.start(now, 2);
            }
            this.myEvent.stop(now);
            this.myEvent = null;
        } else {
            c.enableAllocationTracker(true);
            if (this.myEvent != null) {
                this.myEvent.stop(now);
            }
            this.myEvent = this.myEvents.start(now, 2);
        }
        c.requestAllocationStatus();
    }

    @Override
    @NotNull
    protected String getActiveText(@NotNull Client c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "getActiveText"));
        }
        String string = c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON ? AndroidBundle.message("android.ddms.actions.allocationtracker.stop", new Object[0]) : AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "getActiveText"));
        }
        return string;
    }
}

