/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackTraceExpander {
    private final String myContinuationPrefix;
    private final String myStackTracePrefix;
    private final String myExpandedStackTracePrefix;
    private final String myCauseLinePrefix;
    private static final Pattern EXCEPTION_LINE_PATTERN = Pattern.compile("^at .*(.*)$");
    private static final Pattern ELIDED_LINE_PATTERN = Pattern.compile("^... (\\d+) more$");
    private final List<String> myPreviousStack = new ArrayList<String>();
    private final List<String> myCurrentStack = new ArrayList<String>();

    public StackTraceExpander(String continuationLinePrefix, String stackTraceLinePrefix, String expandedStackTracePrefix, String stackTraceCauseLinePrefix) {
        this.myContinuationPrefix = continuationLinePrefix;
        this.myStackTracePrefix = stackTraceLinePrefix;
        this.myExpandedStackTracePrefix = expandedStackTracePrefix;
        this.myCauseLinePrefix = stackTraceCauseLinePrefix;
    }

    public String expand(String line) {
        line = line.trim();
        boolean isInTrace = !this.myCurrentStack.isEmpty() || !this.myPreviousStack.isEmpty();
        boolean isStackTrace = StackTraceExpander.isStackFrame(line);
        if (!isStackTrace && !isInTrace) {
            return this.myContinuationPrefix + line;
        }
        if (isStackTrace) {
            this.myCurrentStack.add(line);
            return this.myStackTracePrefix + line;
        }
        if (StackTraceExpander.isCauseLine(line)) {
            this.myPreviousStack.clear();
            for (String s : this.myCurrentStack) {
                this.myPreviousStack.add(s);
            }
            this.myCurrentStack.clear();
            return this.myCauseLinePrefix + line;
        }
        int elidedFrameCount = StackTraceExpander.getElidedFrameCount(line);
        if (elidedFrameCount > 0) {
            if (elidedFrameCount <= this.myPreviousStack.size()) {
                StringBuilder sb = new StringBuilder();
                for (int i = this.myPreviousStack.size() - elidedFrameCount; i < this.myPreviousStack.size(); ++i) {
                    String frame = this.myPreviousStack.get(i);
                    sb.append(this.myExpandedStackTracePrefix);
                    sb.append(frame);
                    this.myCurrentStack.add(frame);
                    if (i == this.myPreviousStack.size() - 1) continue;
                    sb.append('\n');
                }
                return sb.toString();
            }
            return this.myStackTracePrefix + line;
        }
        this.myCurrentStack.clear();
        this.myPreviousStack.clear();
        return this.myContinuationPrefix + line;
    }

    static boolean isStackFrame(String line) {
        return EXCEPTION_LINE_PATTERN.matcher(line).matches();
    }

    static int getElidedFrameCount(String line) {
        Matcher matcher = ELIDED_LINE_PATTERN.matcher(line);
        return matcher.matches() ? StringUtil.parseInt((String)matcher.group(1), (int)-1) : -1;
    }

    private static boolean isCauseLine(String line) {
        return line.startsWith("Caused by:");
    }
}

