/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.memory;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.chartlib.EventData;
import com.android.tools.chartlib.TimelineComponent;
import com.android.tools.chartlib.TimelineData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.GcAction;
import com.android.tools.idea.ddms.actions.ToggleAllocationTrackingAction;
import com.android.tools.idea.ddms.hprof.DumpHprofAction;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.DeviceSampler;
import com.android.tools.idea.monitor.TimelineEventListener;
import com.android.tools.idea.monitor.actions.RecordingAction;
import com.android.tools.idea.monitor.memory.MemorySampler;
import com.android.tools.idea.monitor.memory.actions.ToggleDebugRender;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryMonitorView
extends BaseMonitorView
implements TimelineEventListener,
HierarchyListener,
DeviceContext.DeviceSelectionListener {
    public static final int SAMPLES = 2048;
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    private static final int SAMPLE_FREQUENCY_MS = 500;
    @NotNull
    private final DeviceContext myDeviceContext;
    @NotNull
    private TimelineComponent myTimelineComponent;
    @NotNull
    private MemorySampler myMemorySampler;
    private final EventData myEvents;
    public static final int EVENT_HPROF = 1;
    public static final int EVENT_ALLOC = 2;

    public MemoryMonitorView(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/memory/MemoryMonitorView", "<init>"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "com/android/tools/idea/monitor/memory/MemoryMonitorView", "<init>"));
        }
        super(project);
        this.myDeviceContext = deviceContext;
        float bufferTimeInSeconds = 0.75f;
        float initialMax = 5.0f;
        float initialMarker = 2.0f;
        TimelineData data = new TimelineData(2, 2048);
        this.myEvents = new EventData();
        this.myTimelineComponent = new TimelineComponent(data, this.myEvents, bufferTimeInSeconds, initialMax, Float.MAX_VALUE, initialMarker);
        this.myTimelineComponent.configureUnits("MB");
        this.myTimelineComponent.configureStream(0, "Allocated", (Color)new JBColor(7908313, 7908313));
        this.myTimelineComponent.configureStream(1, "Free", (Color)new JBColor(12242140, 5331036));
        this.myTimelineComponent.configureEvent(1, 0, AndroidIcons.Ddms.DumpHprof, (Color)new JBColor(9612742, 7439507), (Color)new JBColor(2838156, 13100543), false);
        this.myTimelineComponent.configureEvent(2, 0, AndroidIcons.Ddms.AllocationTracker, (Color)new JBColor(9612742, 7439507), (Color)new JBColor(2838156, 13100543), true);
        this.myTimelineComponent.configureType(1, TimelineComponent.Style.SOLID);
        this.myTimelineComponent.configureType(2, TimelineComponent.Style.DASHED);
        this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
        this.setComponent((JComponent)this.myTimelineComponent);
        this.myMemorySampler = new MemorySampler(data, 500);
        this.myMemorySampler.addListener(this);
        this.myContentPane.addHierarchyListener(this);
        this.myDeviceContext.addListener(this, (Disposable)project);
    }

    @NotNull
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        if (Boolean.getBoolean("enable.experimental.actions")) {
            group.add((AnAction)new RecordingAction(this.myMemorySampler));
        }
        group.add((AnAction)new GcAction(this.myDeviceContext));
        group.add((AnAction)new DumpHprofAction(this.myProject, this.myDeviceContext, this.myEvents));
        group.add((AnAction)new ToggleAllocationTrackingAction(this.myDeviceContext, this.myEvents));
        if (Boolean.getBoolean("studio.profiling.debug")) {
            group.addSeparator();
            group.add((AnAction)new ToggleDebugRender(this.myTimelineComponent));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/memory/MemoryMonitorView", "getToolbarActions"));
        }
        return defaultActionGroup;
    }

    @NotNull
    public ComponentWithActions createComponent() {
        ComponentWithActions.Impl impl = new ComponentWithActions.Impl(this.getToolbarActions(), null, null, null, (JComponent)this.myContentPane);
        if (impl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/memory/MemoryMonitorView", "createComponent"));
        }
        return impl;
    }

    @Override
    public void deviceSelected(@Nullable IDevice device) {
    }

    @Override
    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/monitor/memory/MemoryMonitorView", "deviceChanged"));
        }
    }

    @Override
    public void clientSelected(@Nullable Client c) {
        this.myMemorySampler.setClient(c);
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    protected DeviceSampler getSampler() {
        return this.myMemorySampler;
    }
}

