/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithRangeAdjuster;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.WrapWithCustomTemplateAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageSurrounders;
import com.intellij.lang.folding.CustomFoldingSurroundDescriptor;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler");
    private static final String CHOOSER_TITLE = CodeInsightBundle.message((String)"surround.with.chooser.title", (Object[])new Object[0]);

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler", "invoke"));
        }
        SurroundWithHandler.invoke(project, editor, file2, null);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, Surrounder surrounder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler", "invoke"));
        }
        if (!CodeInsightUtilBase.prepareEditorForWrite(editor)) {
            return;
        }
        if (file2 instanceof PsiCompiledElement) {
            HintManager.getInstance().showErrorHint(editor, "Can't modify decompiled code");
            return;
        }
        List<AnAction> applicable = SurroundWithHandler.buildSurroundActions(project, editor, file2, surrounder);
        if (applicable != null) {
            SurroundWithHandler.showPopup(editor, applicable);
        } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
            HintManager.getInstance().showErrorHint(editor, "Couldn't find Surround With variants applicable to the current context");
        }
    }

    @Nullable
    public static List<AnAction> buildSurroundActions(Project project, Editor editor, PsiFile file2, @Nullable Surrounder surrounder) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            selectionModel.selectLineAtCaret();
        }
        int startOffset = selectionModel.getSelectionStart();
        int endOffset = selectionModel.getSelectionEnd();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement element1 = file2.findElementAt(startOffset);
        PsiElement element2 = file2.findElementAt(endOffset - 1);
        if (element1 == null || element2 == null) {
            return null;
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        for (SurroundWithRangeAdjuster adjuster : (SurroundWithRangeAdjuster[])Extensions.getExtensions((ExtensionPointName)SurroundWithRangeAdjuster.EP_NAME)) {
            if ((textRange = adjuster.adjustSurroundWithRange(file2, textRange)) != null) continue;
            return null;
        }
        startOffset = textRange.getStartOffset();
        endOffset = textRange.getEndOffset();
        element1 = file2.findElementAt(startOffset);
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        assert (element1 != null);
        Language l = element1.getParent().getLanguage();
        ArrayList<SurroundDescriptor> surroundDescriptors = new ArrayList<SurroundDescriptor>();
        surroundDescriptors.addAll(LanguageSurrounders.INSTANCE.allForLanguage(l));
        if (l != baseLanguage) {
            surroundDescriptors.addAll(LanguageSurrounders.INSTANCE.allForLanguage(baseLanguage));
        }
        surroundDescriptors.add(CustomFoldingSurroundDescriptor.INSTANCE);
        int exclusiveCount = 0;
        ArrayList<SurroundDescriptor> exclusiveSurroundDescriptors = new ArrayList<SurroundDescriptor>();
        for (SurroundDescriptor sd : surroundDescriptors) {
            if (!sd.isExclusive()) continue;
            ++exclusiveCount;
            exclusiveSurroundDescriptors.add(sd);
        }
        if (exclusiveCount > 0) {
            surroundDescriptors = exclusiveSurroundDescriptors;
        }
        if (surrounder != null) {
            SurroundWithHandler.invokeSurrounderInTests(project, editor, file2, surrounder, startOffset, endOffset, surroundDescriptors);
            return null;
        }
        LinkedHashMap surrounders = ContainerUtil.newLinkedHashMap();
        for (SurroundDescriptor descriptor : surroundDescriptors) {
            PsiElement[] elements = descriptor.getElementsToSurround(file2, startOffset, endOffset);
            if (elements.length <= 0) continue;
            for (PsiElement psiElement : elements) {
                assert (psiElement != null) : "descriptor " + descriptor + " returned null element";
                assert (psiElement.isValid()) : descriptor;
            }
            for (PsiElement psiElement : descriptor.getSurrounders()) {
                surrounders.put(psiElement, elements);
            }
        }
        return SurroundWithHandler.doBuildSurroundActions(project, editor, file2, surrounders);
    }

    private static void invokeSurrounderInTests(Project project, Editor editor, PsiFile file2, Surrounder surrounder, int startOffset, int endOffset, List<SurroundDescriptor> surroundDescriptors) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        for (SurroundDescriptor descriptor : surroundDescriptors) {
            PsiElement[] elements = descriptor.getElementsToSurround(file2, startOffset, endOffset);
            if (elements.length <= 0) continue;
            for (Surrounder descriptorSurrounder : descriptor.getSurrounders()) {
                if (!surrounder.getClass().equals(descriptorSurrounder.getClass())) continue;
                SurroundWithHandler.doSurround(project, editor, surrounder, elements);
                return;
            }
        }
    }

    private static void showPopup(Editor editor, List<AnAction> applicable) {
        DataContext context = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
        JBPopupFactory.ActionSelectionAid mnemonics = JBPopupFactory.ActionSelectionAid.MNEMONICS;
        DefaultActionGroup group = new DefaultActionGroup(applicable.toArray(new AnAction[applicable.size()]));
        JBPopupFactory.getInstance().createActionGroupPopup(CHOOSER_TITLE, (ActionGroup)group, context, mnemonics, true).showInBestPositionFor(editor);
    }

    static void doSurround(Project project, Editor editor, Surrounder surrounder, PsiElement[] elements) {
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        try {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            int col = editor.getCaretModel().getLogicalPosition().column;
            int line = editor.getCaretModel().getLogicalPosition().line;
            if (!editor.getCaretModel().supportsMultipleCarets()) {
                LogicalPosition pos = new LogicalPosition(0, 0);
                editor.getCaretModel().moveToLogicalPosition(pos);
            }
            TextRange range = surrounder.surroundElements(project, editor, elements);
            if (TemplateManager.getInstance(project).getActiveTemplate(editor) == null && InplaceRefactoring.getActiveInplaceRenamer(editor) == null) {
                LogicalPosition pos1 = new LogicalPosition(line, col);
                editor.getCaretModel().moveToLogicalPosition(pos1);
            }
            if (range != null) {
                int offset = range.getStartOffset();
                editor.getCaretModel().removeSecondaryCarets();
                editor.getCaretModel().moveToOffset(offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static List<AnAction> doBuildSurroundActions(Project project, Editor editor, PsiFile file2, Map<Surrounder, PsiElement[]> surrounders) {
        ArrayList<AnAction> applicable = new ArrayList<AnAction>();
        boolean hasEnabledSurrounders = false;
        HashSet<Character> usedMnemonicsSet = new HashSet<Character>();
        int index = 0;
        for (Map.Entry<Surrounder, PsiElement[]> entry : surrounders.entrySet()) {
            PsiElement[] elements;
            Surrounder surrounder = entry.getKey();
            if (!surrounder.isApplicable(elements = entry.getValue())) continue;
            char mnemonic = index < 9 ? (char)((char)(48 + index + 1)) : (index == 9 ? (char)'0' : (char)(65 + index - 10));
            ++index;
            usedMnemonicsSet.add(Character.valueOf(Character.toUpperCase(mnemonic)));
            applicable.add(new InvokeSurrounderAction(surrounder, project, editor, elements, mnemonic));
            hasEnabledSurrounders = true;
        }
        List<CustomLiveTemplate> customTemplates = TemplateManagerImpl.listApplicableCustomTemplates(editor, file2, true);
        List<TemplateImpl> templates = TemplateManagerImpl.listApplicableTemplateWithInsertingDummyIdentifier(editor, file2, true);
        if (!templates.isEmpty() || !customTemplates.isEmpty()) {
            applicable.add((AnAction)new Separator("Live templates"));
        }
        for (TemplateImpl template : templates) {
            applicable.add(new InvokeTemplateAction(template, editor, project, usedMnemonicsSet));
            hasEnabledSurrounders = true;
        }
        for (CustomLiveTemplate customTemplate : customTemplates) {
            applicable.add(new WrapWithCustomTemplateAction(customTemplate, editor, file2, usedMnemonicsSet));
            hasEnabledSurrounders = true;
        }
        if (!templates.isEmpty() || !customTemplates.isEmpty()) {
            applicable.add((AnAction)Separator.getInstance());
            applicable.add(new ConfigureTemplatesAction());
        }
        return hasEnabledSurrounders ? applicable : null;
    }

    private static class ConfigureTemplatesAction
    extends AnAction {
        private ConfigureTemplatesAction() {
            super("Configure Live Templates...");
        }

        public void actionPerformed(AnActionEvent e) {
            ShowSettingsUtil.getInstance().showSettingsDialog((Project)e.getData(CommonDataKeys.PROJECT), "Live Templates");
        }
    }

    private static class InvokeSurrounderAction
    extends AnAction {
        private final Surrounder mySurrounder;
        private final Project myProject;
        private final Editor myEditor;
        private final PsiElement[] myElements;

        public InvokeSurrounderAction(Surrounder surrounder, Project project, Editor editor, PsiElement[] elements, char mnemonic) {
            super('\u001b' + String.valueOf(mnemonic) + ". " + surrounder.getTemplateDescription());
            this.mySurrounder = surrounder;
            this.myProject = project;
            this.myEditor = editor;
            this.myElements = elements;
        }

        public void actionPerformed(AnActionEvent e) {
            new WriteCommandAction(this.myProject, new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Exception {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/generation/surroundWith/SurroundWithHandler$InvokeSurrounderAction$1", "run"));
                    }
                    SurroundWithHandler.doSurround(InvokeSurrounderAction.this.myProject, InvokeSurrounderAction.this.myEditor, InvokeSurrounderAction.this.mySurrounder, InvokeSurrounderAction.this.myElements);
                }
            }.execute();
        }
    }
}

